/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.writable.coins;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.dbflute.Entity;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.util.DfTypeUtil;

public class DateUpdateAdjuster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncatePrecisionOfEntityProperty(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The argument 'entity' should not be null.");
        }
        DBMeta dbmeta = entity.asDBMeta();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        boolean createdBySelect = entity.createdBySelect();
        if (createdBySelect) {
            entity.clearMarkAsSelect();
        }
        try {
            for (ColumnInfo columnInfo : columnInfoList) {
                Object dateValue;
                if (!columnInfo.isObjectNativeTypeDate() || (dateValue = columnInfo.read(entity)) == null) continue;
                columnInfo.write(entity, this.doTruncatePrecisionIfHasTime(columnInfo, dateValue));
            }
        }
        finally {
            if (createdBySelect) {
                entity.markAsSelect();
            }
        }
    }

    protected Object doTruncatePrecisionIfHasTime(ColumnInfo columnInfo, Object value) {
        Integer datetimePrecision;
        if (value == null) {
            throw new IllegalArgumentException("The argument 'value' should not be null.");
        }
        if (columnInfo.isObjectNativeTypeDate() && ((datetimePrecision = columnInfo.getDatetimePrecision()) == null || datetimePrecision == 0)) {
            if (value instanceof LocalDateTime) {
                return ((LocalDateTime)value).truncatedTo(ChronoUnit.SECONDS);
            }
            if (value instanceof LocalTime) {
                return ((LocalTime)value).truncatedTo(ChronoUnit.SECONDS);
            }
            if (value instanceof Date && !(value instanceof java.sql.Date)) {
                Calendar cal = DfTypeUtil.toCalendar(value);
                DfTypeUtil.clearCalendarMillisecond(cal);
                return DfTypeUtil.toDate(cal);
            }
        }
        return value;
    }
}

