/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.datavec.image.data.Image;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseImageLoader
implements Serializable {
    protected static final Logger log = LoggerFactory.getLogger(BaseImageLoader.class);
    public static final File BASE_DIR = new File(System.getProperty("user.home"));
    public static final String[] ALLOWED_FORMATS = new String[]{"tif", "jpg", "png", "jpeg", "bmp", "JPEG", "JPG", "TIF", "PNG"};
    protected Random rng = new Random(System.currentTimeMillis());
    protected long height = -1L;
    protected long width = -1L;
    protected long channels = -1L;
    protected boolean centerCropIfNeeded = false;
    protected ImageTransform imageTransform = null;
    protected MultiPageMode multiPageMode = null;

    public String[] getAllowedFormats() {
        return ALLOWED_FORMATS;
    }

    public abstract INDArray asRowVector(File var1) throws IOException;

    public abstract INDArray asRowVector(InputStream var1) throws IOException;

    public abstract INDArray asMatrix(File var1) throws IOException;

    public abstract INDArray asMatrix(InputStream var1) throws IOException;

    public abstract Image asImageMatrix(File var1) throws IOException;

    public abstract Image asImageMatrix(InputStream var1) throws IOException;

    public static void downloadAndUntar(Map urlMap, File fullDir) {
        try {
            String fileName;
            File file = new File(fullDir, urlMap.get("filesFilename").toString());
            if (!file.isFile()) {
                FileUtils.copyURLToFile((URL)new URL(urlMap.get("filesURL").toString()), (File)file);
            }
            if ((fileName = file.toString()).endsWith(".tgz") || fileName.endsWith(".tar.gz") || fileName.endsWith(".gz") || fileName.endsWith(".zip")) {
                ArchiveUtils.unzipFileTo((String)file.getAbsolutePath(), (String)fullDir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to fetch images", e);
        }
    }

    public static enum MultiPageMode {
        MINIBATCH,
        CHANNELS,
        FIRST;

    }
}

