/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;

public class RotateImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    float centerx;
    float centery;
    float angle;
    float scale;
    int interMode = 1;
    int borderMode = 0;
    opencv_core.Scalar borderValue = opencv_core.Scalar.ZERO;

    public RotateImageTransform(float angle) {
        this(null, 0.0f, 0.0f, angle, 0.0f);
    }

    public RotateImageTransform(Random random, float angle) {
        this(random, 0.0f, 0.0f, angle, 0.0f);
    }

    public RotateImageTransform(Random random, float centerx, float centery, float angle, float scale) {
        super(random);
        this.centerx = centerx;
        this.centery = centery;
        this.angle = angle;
        this.scale = scale;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        float cy = (float)(mat.rows() / 2) + this.centery * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        float cx = (float)(mat.cols() / 2) + this.centerx * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        float a = this.angle * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        float s = 1.0f + this.scale * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        opencv_core.Mat result = new opencv_core.Mat();
        opencv_core.Mat M = opencv_imgproc.getRotationMatrix2D((opencv_core.Point2f)new opencv_core.Point2f(cx, cy), (double)this.angle, (double)this.scale);
        opencv_imgproc.warpAffine((opencv_core.Mat)mat, (opencv_core.Mat)result, (opencv_core.Mat)M, (opencv_core.Size)mat.size(), (int)this.interMode, (int)this.borderMode, (opencv_core.Scalar)this.borderValue);
        return new ImageWritable(this.converter.convert((Object)result));
    }

    public int interMode() {
        return this.interMode;
    }

    public RotateImageTransform interMode(int interMode) {
        this.interMode = interMode;
        return this;
    }

    public int borderMode() {
        return this.borderMode;
    }

    public RotateImageTransform borderMode(int borderMode) {
        this.borderMode = borderMode;
        return this;
    }

    public opencv_core.Scalar borderValue() {
        return this.borderValue;
    }

    public RotateImageTransform borderValue(opencv_core.Scalar borderValue) {
        this.borderValue = borderValue;
        return this;
    }
}

