/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.arrow.recordreader;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.partition.PartitionMetaData;
import org.datavec.api.split.partition.Partitioner;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.arrow.ArrowConverter;
import org.datavec.arrow.recordreader.ArrowWritableRecordBatch;

public class ArrowRecordWriter
implements RecordWriter {
    private Configuration configuration;
    private Schema schema;
    private Partitioner partitioner;

    public ArrowRecordWriter(Schema schema) {
        this.schema = schema;
    }

    public boolean supportsBatch() {
        return true;
    }

    public void initialize(InputSplit inputSplit, Partitioner partitioner) throws Exception {
        this.partitioner = partitioner;
        partitioner.init(inputSplit);
    }

    public void initialize(Configuration configuration, InputSplit split, Partitioner partitioner) throws Exception {
        this.setConf(configuration);
        this.partitioner = partitioner;
    }

    public PartitionMetaData write(List<Writable> record) throws IOException {
        return this.writeBatch(Arrays.asList(record));
    }

    public PartitionMetaData writeBatch(List<List<Writable>> batch) throws IOException {
        if (this.partitioner.needsNewPartition()) {
            this.partitioner.currentOutputStream().flush();
            this.partitioner.currentOutputStream().close();
            this.partitioner.openNewStream();
        }
        if (batch instanceof ArrowWritableRecordBatch) {
            ArrowWritableRecordBatch arrowWritableRecordBatch = (ArrowWritableRecordBatch)((Object)batch);
            ArrowConverter.writeRecordBatchTo((List<List<Writable>>)((Object)arrowWritableRecordBatch), this.schema, this.partitioner.currentOutputStream());
        } else {
            ArrowConverter.writeRecordBatchTo(batch, this.schema, this.partitioner.currentOutputStream());
        }
        this.partitioner.currentOutputStream().flush();
        return PartitionMetaData.builder().numRecordsUpdated(batch.size()).build();
    }

    public void close() {
    }

    public void setConf(Configuration conf) {
        this.configuration = conf;
    }

    public Configuration getConf() {
        return this.configuration;
    }
}

