/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.jackson;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.records.reader.impl.jackson.FieldSelection;
import org.datavec.api.records.reader.impl.jackson.JacksonReaderUtils;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.core.type.TypeReference;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class JacksonRecordReader
extends BaseRecordReader {
    private static final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
    private FieldSelection selection;
    private ObjectMapper mapper;
    private boolean shuffle;
    private long rngSeed;
    private PathLabelGenerator labelGenerator;
    private int labelPosition;
    private InputSplit is;
    private Random r;
    private String charset = StandardCharsets.UTF_8.name();
    private URI[] uris;
    private int cursor = 0;

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper) {
        this(selection, mapper, false);
    }

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper, boolean shuffle) {
        this(selection, mapper, shuffle, System.currentTimeMillis(), null);
    }

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper, boolean shuffle, long rngSeed, PathLabelGenerator labelGenerator) {
        this(selection, mapper, shuffle, rngSeed, labelGenerator, -1);
    }

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper, boolean shuffle, long rngSeed, PathLabelGenerator labelGenerator, int labelPosition) {
        this.selection = selection;
        this.mapper = mapper;
        this.shuffle = shuffle;
        this.rngSeed = rngSeed;
        if (shuffle) {
            this.r = new Random(rngSeed);
        }
        this.labelGenerator = labelGenerator;
        this.labelPosition = labelPosition;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        if (split instanceof FileSplit) {
            throw new UnsupportedOperationException("Cannot use JacksonRecordReader with FileSplit");
        }
        super.initialize(this.inputSplit);
        this.uris = split.locations();
        if (this.shuffle) {
            List<URI> list = Arrays.asList(this.uris);
            Collections.shuffle(list, this.r);
            this.uris = list.toArray(new URI[this.uris.length]);
        }
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    @Override
    public List<Writable> next() {
        String fileAsString;
        if (this.uris == null) {
            throw new IllegalStateException("URIs are null. Not initialized?");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        URI uri = this.uris[this.cursor++];
        this.invokeListeners(uri);
        try (InputStream s = (InputStream)this.streamCreatorFn.apply((Object)uri);){
            fileAsString = IOUtils.toString((InputStream)s, (String)this.charset);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading URI file", e);
        }
        return this.readValues(uri, fileAsString);
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.uris.length;
    }

    @Override
    public List<String> getLabels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.cursor = 0;
        if (this.shuffle) {
            List<URI> list = Arrays.asList(this.uris);
            Collections.shuffle(list, this.r);
            this.uris = list.toArray(new URI[this.uris.length]);
        }
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(dataInputStream));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return this.readValues(uri, sb.toString());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
    }

    @Override
    public Configuration getConf() {
        return null;
    }

    private List<Writable> readValues(URI uri, String fileContents) {
        List<Writable> out = JacksonReaderUtils.parseRecord(fileContents, this.selection, this.mapper);
        if (this.labelGenerator != null) {
            Writable label = this.labelGenerator.getLabelForPath(uri);
            List<String[]> paths = this.selection.getFieldPaths();
            if (this.labelPosition >= paths.size() || this.labelPosition == -1) {
                out.add(label);
            } else {
                out.add(this.labelPosition, label);
            }
        }
        return out;
    }

    @Override
    public Record nextRecord() {
        URI currentURI = this.uris[this.cursor];
        List<Writable> writables = this.next();
        RecordMetaDataURI meta = new RecordMetaDataURI(currentURI, JacksonRecordReader.class);
        return new org.datavec.api.records.impl.Record(writables, meta);
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<Record> out = new ArrayList<Record>();
        for (RecordMetaData metaData : recordMetaDatas) {
            String fileAsString;
            URI uri = metaData.getURI();
            try {
                fileAsString = FileUtils.readFileToString((File)new File(uri.toURL().getFile()));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading URI file", e);
            }
            List<Writable> writables = this.readValues(uri, fileAsString);
            out.add(new org.datavec.api.records.impl.Record(writables, metaData));
        }
        return out;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

