/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"inputSchema", "columnsToRemoveIdx", "indicesToRemove"})
public class RemoveColumnsTransform
extends BaseTransform
implements ColumnOp {
    private int[] columnsToRemoveIdx;
    private String[] columnsToRemove;
    private Set<Integer> indicesToRemove;
    private String[] leftOverColumns;

    public RemoveColumnsTransform(String ... columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    @Override
    public void setInputSchema(Schema schema) {
        super.setInputSchema(schema);
        for (String s : this.columnsToRemove) {
            if (this.inputSchema.hasColumn(s)) continue;
            throw new IllegalStateException("Cannot remove column \"" + s + "\": column does not exist. All columns for input schema: " + this.inputSchema.getColumnNames());
        }
        this.leftOverColumns = new String[schema.numColumns() - this.columnsToRemove.length];
        this.indicesToRemove = new HashSet<Integer>();
        int i = 0;
        this.columnsToRemoveIdx = new int[this.columnsToRemove.length];
        for (String s : this.columnsToRemove) {
            int idx = schema.getIndexOfColumn(s);
            if (idx < 0) {
                throw new RuntimeException("Column \"" + s + "\" not found");
            }
            this.columnsToRemoveIdx[i++] = idx;
            this.indicesToRemove.add(idx);
        }
        int leftOverColumnsIdx = 0;
        List<String> columnTest = Arrays.asList(this.columnsToRemove);
        List<String> origColumnNames = schema.getColumnNames();
        for (int remove = 0; remove < schema.numColumns(); ++remove) {
            if (columnTest.contains(origColumnNames.get(remove))) continue;
            this.leftOverColumns[leftOverColumnsIdx++] = origColumnNames.get(remove);
        }
    }

    @Override
    public Schema transform(Schema schema) {
        int nToRemove = this.columnsToRemove.length;
        int newNumColumns = schema.numColumns() - nToRemove;
        if (newNumColumns <= 0) {
            throw new IllegalStateException("Number of columns after executing operation is " + newNumColumns + " (is <= 0). origColumns = " + schema.getColumnNames() + ", toRemove = " + Arrays.toString(this.columnsToRemove));
        }
        List<String> origNames = schema.getColumnNames();
        List<ColumnMetaData> origMeta = schema.getColumnMetaData();
        HashSet set = new HashSet();
        Collections.addAll(set, this.columnsToRemove);
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(newNumColumns);
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> metaIter = origMeta.iterator();
        while (namesIter.hasNext()) {
            String n = namesIter.next();
            ColumnMetaData t = metaIter.next();
            if (set.contains(n)) continue;
            newMeta.add(t);
        }
        return schema.newSchema(newMeta);
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            ArrayList<String> list = new ArrayList<String>();
            for (Writable w : writables) {
                list.add(w.toString());
            }
            String toString = StringUtils.join(list, (String)",");
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString() + " and record " + toString);
        }
        ArrayList<Writable> outList = new ArrayList<Writable>(writables.size() - this.columnsToRemove.length);
        int i = 0;
        for (Writable w : writables) {
            if (this.indicesToRemove.contains(i++)) continue;
            outList.add(w);
        }
        return outList;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    @Override
    public String toString() {
        return "RemoveColumnsTransform(" + Arrays.toString(this.columnsToRemove) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveColumnsTransform o2 = (RemoveColumnsTransform)o;
        return Arrays.equals(this.columnsToRemove, o2.columnsToRemove);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.columnsToRemove);
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return this.leftOverColumns;
    }

    @Override
    public String[] columnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public int[] getColumnsToRemoveIdx() {
        return this.columnsToRemoveIdx;
    }

    public String[] getColumnsToRemove() {
        return this.columnsToRemove;
    }

    public Set<Integer> getIndicesToRemove() {
        return this.indicesToRemove;
    }

    public String[] getLeftOverColumns() {
        return this.leftOverColumns;
    }

    public void setColumnsToRemoveIdx(int[] columnsToRemoveIdx) {
        this.columnsToRemoveIdx = columnsToRemoveIdx;
    }

    public void setColumnsToRemove(String[] columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    public void setIndicesToRemove(Set<Integer> indicesToRemove) {
        this.indicesToRemove = indicesToRemove;
    }

    public void setLeftOverColumns(String[] leftOverColumns) {
        this.leftOverColumns = leftOverColumns;
    }
}

