/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.jackson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.datavec.api.records.reader.impl.jackson.FieldSelection;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.core.type.TypeReference;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class JacksonReaderUtils {
    private static final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};

    private JacksonReaderUtils() {
    }

    public static List<Writable> parseRecord(String line, FieldSelection selection, ObjectMapper mapper) {
        Map map;
        ArrayList<Writable> out = new ArrayList<Writable>();
        List<String[]> paths = selection.getFieldPaths();
        List<Writable> valueIfMissing = selection.getValueIfMissing();
        try {
            map = (Map)mapper.readValue(line, typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing file", e);
        }
        for (int i = 0; i < paths.size(); ++i) {
            Object[] currPath = paths.get(i);
            String value = null;
            Map currMap = map;
            for (int j = 0; j < currPath.length; ++j) {
                if (currMap.containsKey(currPath[j])) {
                    Object o = currMap.get(currPath[j]);
                    if (j == currPath.length - 1) {
                        if (o instanceof String) {
                            value = (String)o;
                            continue;
                        }
                        if (o instanceof Number) {
                            value = o.toString();
                            continue;
                        }
                        throw new IllegalStateException("Expected to find String on path " + Arrays.toString(currPath) + ", found " + o.getClass() + " with value " + o);
                    }
                    if (!(o instanceof Map)) continue;
                    currMap = (Map)o;
                    continue;
                }
                value = null;
                break;
            }
            Writable outputWritable = value == null ? valueIfMissing.get(i) : new Text(value);
            out.add(outputWritable);
        }
        return out;
    }
}

