/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class FileRecordReader
extends BaseRecordReader {
    protected Iterator<URI> locationsIterator;
    protected Configuration conf;
    protected URI currentUri;
    protected List<String> labels;
    protected boolean appendLabel = false;
    protected String charset = StandardCharsets.UTF_8.name();

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        super.initialize(split);
        this.doInitialize(split);
    }

    protected void doInitialize(InputSplit split) {
        URI[] locations;
        if (this.labels == null && this.appendLabel && (locations = split.locations()).length > 0) {
            HashSet<String> labels = new HashSet<String>();
            for (URI u : locations) {
                String[] pathSplit = u.toString().split("[/\\\\]");
                labels.add(pathSplit[pathSplit.length - 2]);
            }
            this.labels = new ArrayList<String>(labels);
            Collections.sort(this.labels);
        }
        this.locationsIterator = split.locationsIterator();
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.appendLabel = conf.getBoolean(APPEND_LABEL, true);
        this.doInitialize(split);
        this.inputSplit = split;
        this.conf = conf;
    }

    @Override
    public List<Writable> next() {
        return this.nextRecord().getRecord();
    }

    private List<Writable> loadFromStream(URI uri, InputStream next, Charset charset) {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        try {
            if (!(next instanceof BufferedInputStream)) {
                next = new BufferedInputStream(next);
            }
            String s = IOUtils.toString((InputStream)next, (Charset)charset);
            ret.add(new Text(s));
            if (this.appendLabel) {
                int idx = this.getLabel(uri);
                ret.add(new IntWritable(idx));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading from input stream: " + uri);
        }
        return ret;
    }

    public int getCurrentLabel() {
        return this.getLabel(this.currentUri);
    }

    public int getLabel(URI uri) {
        String s = uri.toString();
        int lastIdx = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
        String sub = s.substring(0, lastIdx);
        int secondLastIdx = Math.max(sub.lastIndexOf(47), sub.lastIndexOf(92));
        String name = s.substring(secondLastIdx + 1, lastIdx);
        return this.labels.indexOf(name);
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Override
    public boolean hasNext() {
        return this.locationsIterator.hasNext();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<List<Writable>> next(int num) {
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>(num);
        int numBatches = 0;
        while (this.hasNext() && numBatches < num) {
            ret.add(this.next());
        }
        return ret;
    }

    @Override
    public void reset() {
        if (this.inputSplit == null) {
            throw new UnsupportedOperationException("Cannot reset without first initializing");
        }
        try {
            this.doInitialize(this.inputSplit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error during LineRecordReader reset", e);
        }
    }

    @Override
    public boolean resetSupported() {
        if (this.inputSplit != null) {
            return this.inputSplit.resetSupported();
        }
        return false;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        String line;
        this.invokeListeners(uri);
        BufferedReader br = new BufferedReader(new InputStreamReader(dataInputStream));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return Collections.singletonList(new Text(sb.toString()));
    }

    @Override
    public Record nextRecord() {
        List<Writable> ret;
        URI next = this.locationsIterator.next();
        this.invokeListeners(next);
        try (InputStream s = (InputStream)this.streamCreatorFn.apply((Object)next);){
            ret = this.loadFromStream(next, s, Charset.forName(this.charset));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from stream for URI: " + next);
        }
        return new org.datavec.api.records.impl.Record(ret, new RecordMetaDataURI(next, FileRecordReader.class));
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<Record> out = new ArrayList<Record>();
        for (RecordMetaData meta : recordMetaDatas) {
            List<Writable> list;
            URI uri = meta.getURI();
            try (InputStream s = (InputStream)this.streamCreatorFn.apply((Object)uri);){
                list = this.loadFromStream(uri, s, Charset.forName(this.charset));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading from stream for URI: " + uri);
            }
            out.add(new org.datavec.api.records.impl.Record(list, meta));
        }
        return out;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

