/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.integer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class IntegerColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public IntegerColumnsMathOpTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="mathOp") MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData(String newColumnName, Schema inputSchema) {
        return new IntegerMetaData(newColumnName);
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                int sum = 0;
                for (Writable w : input) {
                    sum += w.toInt();
                }
                return new IntWritable(sum);
            }
            case Subtract: {
                return new IntWritable(input[0].toInt() - input[1].toInt());
            }
            case Multiply: {
                int product = 1;
                for (Writable w : input) {
                    product *= w.toInt();
                }
                return new IntWritable(product);
            }
            case Divide: {
                return new IntWritable(input[0].toInt() / input[1].toInt());
            }
            case Modulus: {
                return new IntWritable(input[0].toInt() % input[1].toInt());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public String toString() {
        return "IntegerColumnsMathOpTransform(newColumnName=\"" + this.newColumnName + "\",mathOp=" + (Object)((Object)this.mathOp) + ",columns=" + Arrays.toString(this.columns) + ")";
    }

    @Override
    public Object map(Object input) {
        List list = (List)input;
        switch (this.mathOp) {
            case Add: {
                int sum = 0;
                for (Integer w : list) {
                    sum += w.intValue();
                }
                return sum;
            }
            case Subtract: {
                return new IntWritable((Integer)list.get(0) - (Integer)list.get(1));
            }
            case Multiply: {
                int product = 1;
                for (Integer w : list) {
                    product *= w.intValue();
                }
                return product;
            }
            case Divide: {
                return (Integer)list.get(0) / (Integer)list.get(1);
            }
            case Modulus: {
                return (Integer)list.get(0) % (Integer)list.get(1);
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Object mapSequence(Object sequence) {
        List seq = (List)sequence;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (List step : seq) {
            ret.add((Integer)this.map((Object)step));
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerColumnsMathOpTransform)) {
            return false;
        }
        IntegerColumnsMathOpTransform other = (IntegerColumnsMathOpTransform)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IntegerColumnsMathOpTransform;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

