/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class DoubleColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public DoubleColumnsMathOpTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="columns") List<String> columns) {
        this(newColumnName, mathOp, columns.toArray(new String[columns.size()]));
    }

    public DoubleColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData(String newColumnName, Schema inputSchema) {
        return new DoubleMetaData(newColumnName);
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                double sum = 0.0;
                for (Writable w : input) {
                    sum += w.toDouble();
                }
                return new DoubleWritable(sum);
            }
            case Subtract: {
                return new DoubleWritable(input[0].toDouble() - input[1].toDouble());
            }
            case Multiply: {
                double product = 1.0;
                for (Writable w : input) {
                    product *= w.toDouble();
                }
                return new DoubleWritable(product);
            }
            case Divide: {
                return new DoubleWritable(input[0].toDouble() / input[1].toDouble());
            }
            case Modulus: {
                return new DoubleWritable(input[0].toDouble() % input[1].toDouble());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public String toString() {
        return "DoubleColumnsMathOpTransform(newColumnName=\"" + this.newColumnName + "\",mathOp=" + (Object)((Object)this.mathOp) + ",columns=" + Arrays.toString(this.columns) + ")";
    }

    @Override
    public Object map(Object input) {
        List row = (List)input;
        switch (this.mathOp) {
            case Add: {
                double sum = 0.0;
                for (Double w : row) {
                    sum += w.doubleValue();
                }
                return sum;
            }
            case Subtract: {
                return (Double)row.get(0) - (Double)row.get(1);
            }
            case Multiply: {
                double product = 1.0;
                for (Double w : row) {
                    product *= w.doubleValue();
                }
                return product;
            }
            case Divide: {
                return (Double)row.get(0) / (Double)row.get(1);
            }
            case Modulus: {
                return (Double)row.get(0) % (Double)row.get(1);
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Object mapSequence(Object sequence) {
        List seq = (List)sequence;
        ArrayList<Double> ret = new ArrayList<Double>();
        for (List step : seq) {
            ret.add((Double)this.map((Object)step));
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleColumnsMathOpTransform)) {
            return false;
        }
        DoubleColumnsMathOpTransform other = (DoubleColumnsMathOpTransform)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleColumnsMathOpTransform;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

