/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence;

import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.transform.reduce.IAssociativeReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema"})
public class ReduceSequenceTransform
implements Transform {
    private IAssociativeReducer reducer;
    private Schema inputSchema;

    public ReduceSequenceTransform(@JsonProperty(value="reducer") IAssociativeReducer reducer) {
        this.reducer = reducer;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        if (inputSchema != null && !(inputSchema instanceof SequenceSchema)) {
            throw new IllegalArgumentException("Invalid input: input schema must be a SequenceSchema");
        }
        Schema oneStepSchema = this.reducer.transform(inputSchema);
        List<ColumnMetaData> meta = oneStepSchema.getColumnMetaData();
        return new SequenceSchema(meta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.reducer.setInputSchema(inputSchema);
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("ReduceSequenceTransform can only be applied on sequences");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        IAggregableReduceOp<List<Writable>, List<Writable>> accu = this.reducer.aggregableReducer();
        for (List<Writable> l : sequence) {
            accu.accept(l);
        }
        return Collections.singletonList(accu.get());
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("ReduceSequenceTransform can only be applied on sequences");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Needs to be implemented");
    }

    public String toString() {
        return "ReduceSequenceTransform(reducer=" + this.reducer + ")";
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return this.columnNames();
    }

    @Override
    public String[] columnNames() {
        return this.getInputSchema().getColumnNames().toArray(new String[this.getInputSchema().numColumns()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReduceSequenceTransform)) {
            return false;
        }
        ReduceSequenceTransform other = (ReduceSequenceTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IAssociativeReducer this$reducer = this.getReducer();
        IAssociativeReducer other$reducer = other.getReducer();
        return !(this$reducer == null ? other$reducer != null : !this$reducer.equals(other$reducer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReduceSequenceTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IAssociativeReducer $reducer = this.getReducer();
        result = result * 59 + ($reducer == null ? 43 : $reducer.hashCode());
        return result;
    }

    public IAssociativeReducer getReducer() {
        return this.reducer;
    }

    public void setReducer(IAssociativeReducer reducer) {
        this.reducer = reducer;
    }
}

