/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.io.filters.PathFilter;
import org.datavec.api.split.CollectionInputSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.api.util.files.ShuffledListIterator;
import org.datavec.api.util.files.UriFromPathIterator;

public abstract class BaseInputSplit
implements InputSplit {
    protected List<String> uriStrings;
    protected int[] iterationOrder;
    protected long length = 0L;

    @Override
    public boolean canWriteToLocation(URI location) {
        return location.isAbsolute();
    }

    @Override
    public String addNewLocation() {
        throw new UnsupportedOperationException("Unable to add new location.");
    }

    @Override
    public String addNewLocation(String location) {
        throw new UnsupportedOperationException("Unable to add new location.");
    }

    @Override
    public URI[] locations() {
        if (this.uriStrings == null) {
            this.uriStrings = new ArrayList<String>();
        }
        URI[] uris = new URI[this.uriStrings.size()];
        int i = 0;
        for (String s : this.uriStrings) {
            try {
                uris[i++] = new URI(s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uris;
    }

    @Override
    public Iterator<URI> locationsIterator() {
        return new UriFromPathIterator(this.locationsPathIterator());
    }

    @Override
    public Iterator<String> locationsPathIterator() {
        if (this.iterationOrder == null) {
            return this.uriStrings.iterator();
        }
        return new ShuffledListIterator<String>(this.uriStrings, this.iterationOrder);
    }

    @Override
    public long length() {
        return 0L;
    }

    public InputSplit[] sample(PathFilter pathFilter, double ... weights) {
        URI[] paths;
        URI[] uRIArray = paths = pathFilter != null ? pathFilter.filter(this.locations()) : this.locations();
        if (weights != null && weights.length > 0 && weights[0] != 1.0) {
            int i;
            InputSplit[] splits = new InputSplit[weights.length];
            double totalWeight = 0.0;
            for (int i2 = 0; i2 < weights.length; ++i2) {
                totalWeight += weights[i2];
            }
            double cumulWeight = 0.0;
            int[] partitions = new int[weights.length + 1];
            for (i = 0; i < weights.length; ++i) {
                partitions[i] = (int)Math.round(cumulWeight * (double)paths.length / totalWeight);
                cumulWeight += weights[i];
            }
            partitions[weights.length] = paths.length;
            for (i = 0; i < weights.length; ++i) {
                ArrayList<URI> uris = new ArrayList<URI>();
                for (int j = partitions[i]; j < partitions[i + 1]; ++j) {
                    uris.add(paths[j]);
                }
                splits[i] = new CollectionInputSplit(uris);
            }
            return splits;
        }
        return new InputSplit[]{new CollectionInputSplit(Arrays.asList(paths))};
    }
}

