/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"formatters", "formatter"})
public class StringToTimeTransform
extends BaseColumnTransform {
    private final String timeFormat;
    private final DateTimeZone timeZone;
    private final Locale locale;
    private final Long minValidTime;
    private final Long maxValidTime;
    private static final String[] formats = new String[]{"YYYY-MM-dd'T'HH:mm:ss", "YYYY-MM-dd", "YYYY-MM-dd'T'HH:mm:ss'Z'", "YYYY-MM-dd'T'HH:mm:ssZ", "YYYY-MM-dd'T'HH:mm:ss.SSS'Z'", "YYYY-MM-dd'T'HH:mm:ss.SSSZ", "YYYY-MM-dd HH:mm:ss", "MM/dd/YYYY HH:mm:ss", "MM/dd/YYYY'T'HH:mm:ss.SSS'Z'", "MM/dd/YYYY'T'HH:mm:ss.SSSZ", "MM/dd/YYYY'T'HH:mm:ss.SSS", "MM/dd/YYYY'T'HH:mm:ssZ", "MM/dd/YYYY'T'HH:mm:ss", "YYYY:MM:dd HH:mm:ss", "YYYYMMdd", "YYYY-MM-dd HH:mm:ss", "MM/dd/YYYY HH:mm"};
    private transient DateTimeFormatter[] formatters;
    private transient DateTimeFormatter formatter;

    public StringToTimeTransform(String columnName, TimeZone timeZone) {
        this(columnName, null, timeZone, null, null, null);
    }

    public StringToTimeTransform(String columnName, TimeZone timeZone, Locale locale) {
        this(columnName, null, timeZone, locale, null, null);
    }

    public StringToTimeTransform(String columnName, String timeFormat, TimeZone timeZone) {
        this(columnName, timeFormat, timeZone, null, null, null);
    }

    public StringToTimeTransform(String columnName, String timeFormat, TimeZone timeZone, Locale locale) {
        this(columnName, timeFormat, timeZone, locale, null, null);
    }

    public StringToTimeTransform(String columnName, DateTimeZone timeZone, Locale locale) {
        this(columnName, null, timeZone, locale, null, null);
    }

    public StringToTimeTransform(String columnName, String timeFormat, DateTimeZone timeZone) {
        this(columnName, timeFormat, timeZone, null, null, null);
    }

    public StringToTimeTransform(String columnName, String timeFormat, DateTimeZone timeZone, Locale locale) {
        this(columnName, timeFormat, timeZone, locale, null, null);
    }

    public StringToTimeTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="timeFormat") String timeFormat, @JsonProperty(value="timeZone") TimeZone timeZone, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="minValidTime") Long minValidTime, @JsonProperty(value="maxValidTime") Long maxValidTime) {
        this(columnName, timeFormat, DateTimeZone.forTimeZone((TimeZone)timeZone), locale, minValidTime, maxValidTime);
    }

    public StringToTimeTransform(String columnName, String timeFormat, DateTimeZone timeZone, Locale locale, Long minValidTime, Long maxValidTime) {
        super(columnName);
        this.timeFormat = timeFormat;
        this.timeZone = timeZone;
        this.locale = locale;
        this.minValidTime = minValidTime;
        this.maxValidTime = maxValidTime;
        if (timeFormat != null) {
            this.formatter = locale != null ? DateTimeFormat.forPattern((String)timeFormat).withZone(timeZone).withLocale(locale) : DateTimeFormat.forPattern((String)timeFormat).withZone(timeZone);
        } else {
            ArrayList<DateTimeFormatter> dateFormatList = new ArrayList<DateTimeFormatter>();
            this.formatters = new DateTimeFormatter[formats.length];
            for (int i = 0; i < this.formatters.length; ++i) {
                if (locale != null) {
                    dateFormatList.add(DateTimeFormat.forPattern((String)formats[i]).withZone(timeZone).withLocale(locale));
                    continue;
                }
                dateFormatList.add(DateTimeFormat.forPattern((String)formats[i]).withZone(timeZone));
            }
            this.formatters = dateFormatList.toArray(new DateTimeFormatter[dateFormatList.size()]);
        }
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        return new TimeMetaData(newName, this.timeZone, this.minValidTime, this.maxValidTime);
    }

    @Override
    public Writable map(Writable columnWritable) {
        String str = columnWritable.toString().trim();
        if (str.contains("'T'")) {
            str = str.replaceFirst("'T'", "T");
        }
        if (this.formatter == null) {
            long result = -1L;
            if (Pattern.compile("\\.[0-9]+").matcher(str).find()) {
                str = str.replaceAll("\\.[0-9]+", "");
            }
            for (DateTimeFormatter formatter : this.formatters) {
                try {
                    result = formatter.parseMillis(str);
                    return new LongWritable(result);
                }
                catch (Exception exception) {
                }
            }
            if (result < 0L) {
                throw new IllegalStateException("Unable to parse date time " + str);
            }
        } else {
            long time = this.formatter.parseMillis(str);
            return new LongWritable(time);
        }
        throw new IllegalStateException("Unable to parse date time " + str);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringToTimeTransform(timeZone=").append(this.timeZone);
        if (this.minValidTime != null) {
            sb.append(",minValidTime=").append(this.minValidTime);
        }
        if (this.maxValidTime != null) {
            if (this.minValidTime != null) {
                sb.append(",");
            }
            sb.append("maxValidTime=").append(this.maxValidTime);
        }
        sb.append(")");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.timeFormat != null) {
            this.formatter = DateTimeFormat.forPattern((String)this.timeFormat).withZone(this.timeZone);
        } else {
            ArrayList<DateTimeFormatter> dateFormatList = new ArrayList<DateTimeFormatter>();
            this.formatters = new DateTimeFormatter[formats.length];
            for (int i = 0; i < this.formatters.length; ++i) {
                dateFormatList.add(DateTimeFormat.forPattern((String)formats[i]).withZone(this.timeZone));
            }
            this.formatters = dateFormatList.toArray(new DateTimeFormatter[dateFormatList.size()]);
        }
    }

    @Override
    public Object map(Object input) {
        return null;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Long getMinValidTime() {
        return this.minValidTime;
    }

    public Long getMaxValidTime() {
        return this.maxValidTime;
    }

    public DateTimeFormatter[] getFormatters() {
        return this.formatters;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatters(DateTimeFormatter[] formatters) {
        this.formatters = formatters;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringToTimeTransform)) {
            return false;
        }
        StringToTimeTransform other = (StringToTimeTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$minValidTime = this.getMinValidTime();
        Long other$minValidTime = other.getMinValidTime();
        if (this$minValidTime == null ? other$minValidTime != null : !((Object)this$minValidTime).equals(other$minValidTime)) {
            return false;
        }
        Long this$maxValidTime = this.getMaxValidTime();
        Long other$maxValidTime = other.getMaxValidTime();
        if (this$maxValidTime == null ? other$maxValidTime != null : !((Object)this$maxValidTime).equals(other$maxValidTime)) {
            return false;
        }
        String this$timeFormat = this.getTimeFormat();
        String other$timeFormat = other.getTimeFormat();
        if (this$timeFormat == null ? other$timeFormat != null : !this$timeFormat.equals(other$timeFormat)) {
            return false;
        }
        DateTimeZone this$timeZone = this.getTimeZone();
        DateTimeZone other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        return !(this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringToTimeTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $minValidTime = this.getMinValidTime();
        result = result * 59 + ($minValidTime == null ? 43 : ((Object)$minValidTime).hashCode());
        Long $maxValidTime = this.getMaxValidTime();
        result = result * 59 + ($maxValidTime == null ? 43 : ((Object)$maxValidTime).hashCode());
        String $timeFormat = this.getTimeFormat();
        result = result * 59 + ($timeFormat == null ? 43 : $timeFormat.hashCode());
        DateTimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        return result;
    }
}

