/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.sequence;

import java.util.List;
import java.util.Set;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SequenceLengthCondition
implements Condition {
    private ConditionOp op;
    private Integer length;
    private Set<Integer> set;
    private Schema inputSchema;

    public SequenceLengthCondition(ConditionOp op, int length) {
        this(op, length, null);
    }

    public SequenceLengthCondition(ConditionOp op, Set<Integer> set) {
        this(op, null, set);
    }

    private SequenceLengthCondition(@JsonProperty(value="op") ConditionOp op, @JsonProperty(value="length") Integer length, @JsonProperty(value="set") Set<Integer> set) {
        if (set != null & op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can only use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.length = length;
        this.set = set;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public String outputColumnName() {
        return this.inputSchema.getColumnNames().get(0);
    }

    @Override
    public String[] outputColumnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String[] columnNames() {
        return this.outputColumnNames();
    }

    @Override
    public String columnName() {
        return this.outputColumnName();
    }

    @Override
    public boolean condition(List<Writable> list) {
        throw new UnsupportedOperationException("Cannot apply SequenceLengthCondition on non-sequence data");
    }

    @Override
    public boolean condition(Object input) {
        throw new UnsupportedOperationException("Cannot apply SequenceLengthCondition on non-sequence data");
    }

    @Override
    public boolean conditionSequence(List<List<Writable>> sequence) {
        return this.op.apply(sequence.size(), this.length == null ? 0 : this.length, this.set);
    }

    @Override
    public boolean conditionSequence(Object sequence) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.inputSchema = schema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceLengthCondition)) {
            return false;
        }
        SequenceLengthCondition other = (SequenceLengthCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        ConditionOp this$op = this.getOp();
        ConditionOp other$op = other.getOp();
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        Set<Integer> this$set = this.getSet();
        Set<Integer> other$set = other.getSet();
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceLengthCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        ConditionOp $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        Set<Integer> $set = this.getSet();
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }

    public ConditionOp getOp() {
        return this.op;
    }

    public Integer getLength() {
        return this.length;
    }

    public Set<Integer> getSet() {
        return this.set;
    }

    public void setOp(ConditionOp op) {
        this.op = op;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setSet(Set<Integer> set) {
        this.set = set;
    }

    public String toString() {
        return "SequenceLengthCondition(op=" + (Object)((Object)this.getOp()) + ", length=" + this.getLength() + ", set=" + this.getSet() + ", inputSchema=" + this.getInputSchema() + ")";
    }
}

