/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ops;

import java.beans.ConstructorProperties;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.writable.Writable;

public class AggregableCheckingOp<T>
implements IAggregableReduceOp<Writable, T> {
    private IAggregableReduceOp<Writable, T> operation;
    private ColumnMetaData metaData;

    @Override
    public <W extends IAggregableReduceOp<Writable, T>> void combine(W accu) {
        AggregableCheckingOp accumulator;
        if (accu instanceof AggregableCheckingOp) {
            accumulator = (AggregableCheckingOp)accu;
            if (this.metaData.getColumnType() != accumulator.getMetaData().getColumnType()) {
                throw new IllegalArgumentException("Invalid merge with operation on " + accumulator.getMetaData().getName() + " of type " + (Object)((Object)accumulator.getMetaData().getColumnType()) + " expected " + this.metaData.getName() + " of type " + (Object)((Object)this.metaData.getColumnType()));
            }
        } else {
            throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
        }
        this.operation.combine(accumulator);
    }

    @Override
    public void accept(Writable writable) {
        if (this.metaData.isValid(writable)) {
            this.operation.accept(writable);
        }
    }

    @Override
    public T get() {
        return this.operation.get();
    }

    @ConstructorProperties(value={"operation", "metaData"})
    public AggregableCheckingOp(IAggregableReduceOp<Writable, T> operation, ColumnMetaData metaData) {
        this.operation = operation;
        this.metaData = metaData;
    }

    public IAggregableReduceOp<Writable, T> getOperation() {
        return this.operation;
    }

    public ColumnMetaData getMetaData() {
        return this.metaData;
    }
}

