/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.collection;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataIndex;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;

public class CollectionSequenceRecordReader
extends BaseRecordReader
implements SequenceRecordReader {
    private Iterator<? extends Collection<? extends Collection<Writable>>> records;
    private final Collection<? extends Collection<? extends Collection<Writable>>> original;
    private int count = 0;

    public CollectionSequenceRecordReader(Collection<? extends Collection<? extends Collection<Writable>>> records) {
        this.records = records.iterator();
        this.original = records;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    @Override
    public List<Writable> next() {
        throw new UnsupportedOperationException("next() not supported for CollectionSequencRecordReader; use sequenceRecord()");
    }

    @Override
    public boolean hasNext() {
        return this.records.hasNext();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
    }

    @Override
    public Configuration getConf() {
        return null;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public void reset() {
        this.records = this.original.iterator();
        this.count = 0;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Generating records from DataInputStream not supported for SequenceCollectionRecordReader");
    }

    @Override
    public Record nextRecord() {
        return new org.datavec.api.records.impl.Record(this.next(), null);
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        throw new UnsupportedOperationException("Loading from metadata not yet implemented");
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        throw new UnsupportedOperationException("Loading from metadata not yet implemented");
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        List<List<Writable>> record = CollectionSequenceRecordReader.toList(this.records.next());
        this.invokeListeners(record);
        ++this.count;
        return record;
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Generating records from DataInputStream not supported for SequenceCollectionRecordReader");
    }

    @Override
    public SequenceRecord nextSequence() {
        return new org.datavec.api.records.impl.SequenceRecord(this.sequenceRecord(), new RecordMetaDataIndex(this.count - 1, null, CollectionSequenceRecordReader.class));
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadSequenceFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        LinkedHashSet<Integer> toLoad = new LinkedHashSet<Integer>();
        for (RecordMetaData recordMetaData : recordMetaDatas) {
            if (!(recordMetaData instanceof RecordMetaDataIndex)) {
                throw new IllegalArgumentException("Expected RecordMetaDataIndex; got: " + recordMetaData);
            }
            long idx = ((RecordMetaDataIndex)recordMetaData).getIndex();
            if (idx >= (long)this.original.size()) {
                throw new IllegalStateException("Cannot get index " + idx + " from collection: contains " + this.original + " elements");
            }
            toLoad.add((int)idx);
        }
        ArrayList<SequenceRecord> out = new ArrayList<SequenceRecord>();
        Iterator<? extends Collection<? extends Collection<Writable>>> iter = this.original.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Collection<? extends Collection<Writable>> c = iter.next();
            if (!toLoad.contains(i++)) continue;
            List<List<Writable>> record = CollectionSequenceRecordReader.toList(c);
            org.datavec.api.records.impl.SequenceRecord r = new org.datavec.api.records.impl.SequenceRecord(record, new RecordMetaDataIndex(i - 1, null, CollectionSequenceRecordReader.class));
            out.add(r);
        }
        return out;
    }

    private static List<List<Writable>> toList(Collection<? extends Collection<Writable>> next) {
        ArrayList<List<Writable>> record = new ArrayList<List<Writable>>();
        for (Collection<Writable> collection : next) {
            record.add(new ArrayList<Writable>(collection));
        }
        return record;
    }
}

