/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ops;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.writable.Writable;

public class AggregableMultiOp<T>
implements IAggregableReduceOp<T, List<Writable>> {
    @NonNull
    private List<IAggregableReduceOp<T, Writable>> operations;

    @Override
    public void accept(T t) {
        for (int i = 0; i < this.operations.size(); ++i) {
            this.operations.get(i).accept(t);
        }
    }

    @Override
    public <U extends IAggregableReduceOp<T, List<Writable>>> void combine(U accu) {
        if (accu instanceof AggregableMultiOp) {
            AggregableMultiOp accumulator = (AggregableMultiOp)accu;
            List<IAggregableReduceOp<T, Writable>> otherAccumulators = accumulator.getOperations();
            if (this.operations.size() != otherAccumulators.size()) {
                throw new IllegalArgumentException("Tried to combine() incompatible " + this.getClass().getName() + " operators: received " + otherAccumulators.size() + " operations, expected " + this.operations.size());
            }
            for (int i = 0; i < this.operations.size(); ++i) {
                this.operations.get(i).combine(otherAccumulators.get(i));
            }
        } else {
            throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
        }
    }

    @Override
    public List<Writable> get() {
        ArrayList<Writable> res = new ArrayList<Writable>(this.operations.size());
        for (int i = 0; i < this.operations.size(); ++i) {
            res.add((Writable)this.operations.get(i).get());
        }
        return res;
    }

    @ConstructorProperties(value={"operations"})
    public AggregableMultiOp(@NonNull List<IAggregableReduceOp<T, Writable>> operations) {
        if (operations == null) {
            throw new NullPointerException("operations");
        }
        this.operations = operations;
    }

    @NonNull
    public List<IAggregableReduceOp<T, Writable>> getOperations() {
        return this.operations;
    }
}

