/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class StringMetaData
extends BaseColumnMetaData {
    private final String regex;
    private final Integer minLength;
    private final Integer maxLength;

    public StringMetaData() {
        super(null);
        this.regex = null;
        this.minLength = null;
        this.maxLength = null;
    }

    public StringMetaData(String name) {
        this(name, null, null, null);
    }

    public StringMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="regex") String mustMatchRegex, @JsonProperty(value="minLength") Integer minLength, @JsonProperty(value="maxLength") Integer maxLength) {
        super(name);
        this.regex = mustMatchRegex;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.String;
    }

    @Override
    public boolean isValid(Writable writable) {
        String str = writable.toString();
        int len = str.length();
        if (this.minLength != null && len < this.minLength) {
            return false;
        }
        if (this.maxLength != null && len > this.maxLength) {
            return false;
        }
        return this.regex == null || str.matches(this.regex);
    }

    @Override
    public boolean isValid(Object input) {
        String str = input.toString();
        int len = str.length();
        if (this.minLength != null && len < this.minLength) {
            return false;
        }
        if (this.maxLength != null && len > this.maxLength) {
            return false;
        }
        return this.regex == null || str.matches(this.regex);
    }

    @Override
    public StringMetaData clone() {
        return new StringMetaData(this.name, this.regex, this.minLength, this.maxLength);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringMetaData(name=\"").append(this.name).append("\",");
        if (this.minLength != null) {
            sb.append("minLengthAllowed=").append(this.minLength);
        }
        if (this.maxLength != null) {
            if (this.minLength != null) {
                sb.append(",");
            }
            sb.append("maxLengthAllowed=").append(this.maxLength);
        }
        if (this.regex != null) {
            if (this.minLength != null || this.maxLength != null) {
                sb.append(",");
            }
            sb.append("regex=").append(this.regex);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringMetaData)) {
            return false;
        }
        StringMetaData other = (StringMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$regex = this.regex;
        String other$regex = other.regex;
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        Integer this$minLength = this.minLength;
        Integer other$minLength = other.minLength;
        if (this$minLength == null ? other$minLength != null : !((Object)this$minLength).equals(other$minLength)) {
            return false;
        }
        Integer this$maxLength = this.maxLength;
        Integer other$maxLength = other.maxLength;
        return !(this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringMetaData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $regex = this.regex;
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        Integer $minLength = this.minLength;
        result = result * 59 + ($minLength == null ? 43 : ((Object)$minLength).hashCode());
        Integer $maxLength = this.maxLength;
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        return result;
    }
}

