/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.misc;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVMLightRecordReader
extends LineRecordReader {
    private static final Logger log = LoggerFactory.getLogger(SVMLightRecordReader.class);
    public static final String NAME_SPACE = SVMLightRecordReader.class.getName();
    public static final String NUM_FEATURES = NAME_SPACE + ".numfeatures";
    public static final String ZERO_BASED_INDEXING = NAME_SPACE + ".zeroBasedIndexing";
    public static final String MULTILABEL = NAME_SPACE + ".multilabel";
    public static final String NUM_LABELS = NAME_SPACE + ".numLabels";
    public static final String COMMENT_CHAR = "#";
    public static final String ALLOWED_DELIMITERS = "[ \t]";
    public static final String PREFERRED_DELIMITER = " ";
    public static final String FEATURE_DELIMITER = ":";
    public static final String LABEL_DELIMITER = ",";
    public static final String QID_PREFIX = "qid";
    public static final Writable ZERO = new DoubleWritable(0.0);
    public static final Writable ONE = new DoubleWritable(1.0);
    public static final Writable LABEL_ZERO = new IntWritable(0);
    public static final Writable LABEL_ONE = new IntWritable(1);
    protected int numFeatures = -1;
    protected boolean zeroBasedIndexing = true;
    protected boolean appendLabel = true;
    protected boolean multilabel = false;
    protected int numLabels = -1;
    protected Writable recordLookahead = null;
    public static final String NUM_ATTRIBUTES = NAME_SPACE + ".numattributes";

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.setConf(conf);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.numFeatures = conf.getInt(NUM_FEATURES, -1);
        if (this.numFeatures < 0) {
            this.numFeatures = conf.getInt(NUM_ATTRIBUTES, -1);
        }
        if (this.numFeatures < 0) {
            throw new UnsupportedOperationException("numFeatures must be set in configuration");
        }
        this.appendLabel = conf.getBoolean(APPEND_LABEL, true);
        this.multilabel = conf.getBoolean(MULTILABEL, false);
        this.zeroBasedIndexing = conf.getBoolean(ZERO_BASED_INDEXING, true);
        this.numLabels = conf.getInt(NUM_LABELS, -1);
        if (this.multilabel && this.numLabels < 0) {
            throw new UnsupportedOperationException("numLabels must be set in confirmation for multilabel problems");
        }
    }

    protected Writable getNextRecord() {
        Writable w = null;
        if (this.recordLookahead != null) {
            w = this.recordLookahead;
            this.recordLookahead = null;
        }
        while (w == null && super.hasNext() && (w = super.next().iterator().next()).toString().startsWith(COMMENT_CHAR)) {
            w = null;
        }
        return w;
    }

    @Override
    public boolean hasNext() {
        this.recordLookahead = this.getNextRecord();
        return this.recordLookahead != null;
    }

    @Override
    public List<Writable> next() {
        int index;
        Writable w = this.getNextRecord();
        if (w == null) {
            throw new NoSuchElementException("No next element found!");
        }
        String line = w.toString();
        ArrayList<Writable> record = new ArrayList<Writable>();
        String[] tokens = line.split(COMMENT_CHAR, 2)[0].trim().split(ALLOWED_DELIMITERS);
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            String[] featureTokens = token.split(FEATURE_DELIMITER);
            if (featureTokens[0].startsWith(QID_PREFIX)) continue;
            index = -1;
            try {
                index = Integer.parseInt(featureTokens[0]);
                if (index < 0) {
                    throw new NumberFormatException("");
                }
            }
            catch (NumberFormatException e) {
                String msg = String.format("Feature index must be positive integer (found %s)", featureTokens[i].toString());
                throw new NumberFormatException(msg);
            }
            if (!this.zeroBasedIndexing) {
                if (index == 0) {
                    throw new IndexOutOfBoundsException("Found feature with index " + index + " but not using zero-based indexing");
                }
                --index;
            }
            if (this.numFeatures >= 0 && index >= this.numFeatures) {
                throw new IndexOutOfBoundsException("Found " + (index + 1) + " features in record, expected " + this.numFeatures);
            }
            while (record.size() < index) {
                record.add(ZERO);
            }
            record.add(new DoubleWritable(Double.parseDouble(featureTokens[1])));
        }
        while (record.size() < this.numFeatures) {
            record.add(ZERO);
        }
        if (this.appendLabel) {
            String[] labelTokens;
            ArrayList<Writable> labels = new ArrayList<Writable>();
            if (this.multilabel) {
                labelTokens = tokens[0].split(LABEL_DELIMITER);
                for (int i = 0; i < labelTokens.length; ++i) {
                    index = -1;
                    try {
                        index = Integer.parseInt(labelTokens[i]);
                        if (index < 0) {
                            throw new NumberFormatException("");
                        }
                    }
                    catch (NumberFormatException e) {
                        String msg = String.format("Multilabel index must be positive integer (found %s)", labelTokens[i].toString());
                        throw new NumberFormatException(msg);
                    }
                    if (!this.zeroBasedIndexing) {
                        if (index == 0) {
                            throw new IndexOutOfBoundsException("Found label with index " + index + " but not using zero-based indexing");
                        }
                        --index;
                    }
                    if (this.numLabels >= 0 && index >= this.numLabels) {
                        throw new IndexOutOfBoundsException("Found " + (index + 1) + " labels in record, expected " + this.numLabels);
                    }
                    while (labels.size() < index) {
                        labels.add(LABEL_ZERO);
                    }
                    labels.add(LABEL_ONE);
                }
                while (labels.size() < this.numLabels) {
                    labels.add(LABEL_ZERO);
                }
            } else {
                labelTokens = tokens[0].split(LABEL_DELIMITER);
                if (this.numLabels < 0) {
                    this.numLabels = labelTokens.length;
                }
                if (labelTokens.length != this.numLabels) {
                    throw new IndexOutOfBoundsException("Found " + labelTokens.length + " labels in record, expected " + this.numLabels);
                }
                for (int i = 0; i < labelTokens.length; ++i) {
                    try {
                        labels.add(new IntWritable(Integer.parseInt(labelTokens[i])));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        labels.add(new DoubleWritable(Double.parseDouble(labelTokens[i])));
                    }
                }
            }
            record.addAll(labels);
        }
        return record;
    }

    @Override
    public Record nextRecord() {
        throw new UnsupportedOperationException("nextRecord has not been implemented for SVMLightRecordReader");
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading SVMLightRecordReader data from DataInputStream not yet implemented");
    }

    @Override
    public void reset() {
        super.reset();
        this.recordLookahead = null;
    }

    @Override
    protected void onLocationOpen(URI location) {
        super.onLocationOpen(location);
        this.recordLookahead = null;
    }
}

