/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import java.util.TimeZone;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTimeZone;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class TimeMetaData
extends BaseColumnMetaData {
    private final DateTimeZone timeZone;
    private final Long minValidTime;
    private final Long maxValidTime;

    public TimeMetaData(String name) {
        this(name, DateTimeZone.UTC, null, null);
    }

    public TimeMetaData(String name, TimeZone timeZone) {
        this(name, timeZone, null, null);
    }

    public TimeMetaData(String name, DateTimeZone timeZone) {
        this(name, timeZone, null, null);
    }

    public TimeMetaData(String name, TimeZone timeZone, Long minValidTime, Long maxValidTime) {
        super(name);
        this.timeZone = DateTimeZone.forTimeZone((TimeZone)timeZone);
        this.minValidTime = minValidTime;
        this.maxValidTime = maxValidTime;
    }

    public TimeMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="timeZone") DateTimeZone timeZone, @JsonProperty(value="minValidTime") Long minValidTime, @JsonProperty(value="maxValidTime") Long maxValidTime) {
        super(name);
        this.timeZone = timeZone;
        this.minValidTime = minValidTime;
        this.maxValidTime = maxValidTime;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Time;
    }

    @Override
    public boolean isValid(Writable writable) {
        long epochMillisec;
        if (writable instanceof LongWritable) {
            epochMillisec = writable.toLong();
        } else {
            try {
                epochMillisec = Long.parseLong(writable.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (this.minValidTime != null && epochMillisec < this.minValidTime) {
            return false;
        }
        return this.maxValidTime == null || epochMillisec <= this.maxValidTime;
    }

    @Override
    public TimeMetaData clone() {
        return new TimeMetaData(this.name, this.timeZone, this.minValidTime, this.maxValidTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeMetaData(name=\"").append(this.name).append("\",timeZone=").append(this.timeZone.getID());
        if (this.minValidTime != null) {
            sb.append("minValidTime=").append(this.minValidTime);
        }
        if (this.maxValidTime != null) {
            if (this.minValidTime != null) {
                sb.append(",");
            }
            sb.append("maxValidTime=").append(this.maxValidTime);
        }
        sb.append(")");
        return sb.toString();
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public Long getMinValidTime() {
        return this.minValidTime;
    }

    public Long getMaxValidTime() {
        return this.maxValidTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeMetaData)) {
            return false;
        }
        TimeMetaData other = (TimeMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateTimeZone this$timeZone = this.getTimeZone();
        DateTimeZone other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        Long this$minValidTime = this.getMinValidTime();
        Long other$minValidTime = other.getMinValidTime();
        if (this$minValidTime == null ? other$minValidTime != null : !((Object)this$minValidTime).equals(other$minValidTime)) {
            return false;
        }
        Long this$maxValidTime = this.getMaxValidTime();
        Long other$maxValidTime = other.getMaxValidTime();
        return !(this$maxValidTime == null ? other$maxValidTime != null : !((Object)this$maxValidTime).equals(other$maxValidTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeMetaData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        DateTimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        Long $minValidTime = this.getMinValidTime();
        result = result * 59 + ($minValidTime == null ? 43 : ((Object)$minValidTime).hashCode());
        Long $maxValidTime = this.getMaxValidTime();
        result = result * 59 + ($maxValidTime == null ? 43 : ((Object)$maxValidTime).hashCode());
        return result;
    }
}

