/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTimeFieldType;

public class DateTimeFieldTypeDeserializer
extends JsonDeserializer<DateTimeFieldType> {
    private static final Map<String, DateTimeFieldType> map = DateTimeFieldTypeDeserializer.getMap();

    private static Map<String, DateTimeFieldType> getMap() {
        HashMap<String, DateTimeFieldType> ret = new HashMap<String, DateTimeFieldType>();
        ret.put(DateTimeFieldType.centuryOfEra().getName(), DateTimeFieldType.centuryOfEra());
        ret.put(DateTimeFieldType.clockhourOfDay().getName(), DateTimeFieldType.clockhourOfDay());
        ret.put(DateTimeFieldType.clockhourOfHalfday().getName(), DateTimeFieldType.clockhourOfHalfday());
        ret.put(DateTimeFieldType.dayOfMonth().getName(), DateTimeFieldType.dayOfMonth());
        ret.put(DateTimeFieldType.dayOfWeek().getName(), DateTimeFieldType.dayOfWeek());
        ret.put(DateTimeFieldType.dayOfYear().getName(), DateTimeFieldType.dayOfYear());
        ret.put(DateTimeFieldType.era().getName(), DateTimeFieldType.era());
        ret.put(DateTimeFieldType.halfdayOfDay().getName(), DateTimeFieldType.halfdayOfDay());
        ret.put(DateTimeFieldType.hourOfDay().getName(), DateTimeFieldType.hourOfDay());
        ret.put(DateTimeFieldType.hourOfHalfday().getName(), DateTimeFieldType.hourOfHalfday());
        ret.put(DateTimeFieldType.millisOfDay().getName(), DateTimeFieldType.millisOfDay());
        ret.put(DateTimeFieldType.millisOfSecond().getName(), DateTimeFieldType.millisOfSecond());
        ret.put(DateTimeFieldType.minuteOfDay().getName(), DateTimeFieldType.minuteOfDay());
        ret.put(DateTimeFieldType.minuteOfHour().getName(), DateTimeFieldType.minuteOfHour());
        ret.put(DateTimeFieldType.secondOfDay().getName(), DateTimeFieldType.secondOfDay());
        ret.put(DateTimeFieldType.secondOfMinute().getName(), DateTimeFieldType.secondOfMinute());
        ret.put(DateTimeFieldType.weekOfWeekyear().getName(), DateTimeFieldType.weekOfWeekyear());
        ret.put(DateTimeFieldType.weekyear().getName(), DateTimeFieldType.weekyear());
        ret.put(DateTimeFieldType.weekyearOfCentury().getName(), DateTimeFieldType.weekyearOfCentury());
        ret.put(DateTimeFieldType.year().getName(), DateTimeFieldType.year());
        ret.put(DateTimeFieldType.yearOfCentury().getName(), DateTimeFieldType.yearOfCentury());
        ret.put(DateTimeFieldType.yearOfEra().getName(), DateTimeFieldType.yearOfEra());
        return ret;
    }

    public DateTimeFieldType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String value = node.get("fieldType").textValue();
        return map.get(value);
    }
}

