/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

@JsonIgnoreProperties(value={"inputSchema", "outputOrder"})
public class ReorderColumnsTransform
implements Transform {
    private final List<String> newOrder;
    private Schema inputSchema;
    private int[] outputOrder;

    public ReorderColumnsTransform(String ... newOrder) {
        this(Arrays.asList(newOrder));
    }

    public ReorderColumnsTransform(@JsonProperty(value="newOrder") List<String> newOrder) {
        this.newOrder = newOrder;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        for (String s : this.newOrder) {
            if (inputSchema.hasColumn(s)) continue;
            throw new IllegalStateException("Input schema does not contain column with name \"" + s + "\"");
        }
        if (inputSchema.numColumns() < this.newOrder.size()) {
            throw new IllegalArgumentException("Schema has " + inputSchema.numColumns() + " column but newOrder has " + this.newOrder.size() + " columns");
        }
        List<String> origNames = inputSchema.getColumnNames();
        List<ColumnMetaData> origMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> outMeta = new ArrayList<ColumnMetaData>();
        boolean[] taken = new boolean[origNames.size()];
        for (String s : this.newOrder) {
            int idx = inputSchema.getIndexOfColumn(s);
            outMeta.add(origMeta.get(idx));
            taken[idx] = true;
        }
        for (int i = 0; i < taken.length; ++i) {
            if (taken[i]) continue;
            outMeta.add(origMeta.get(i));
        }
        return inputSchema.newSchema(outMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        for (String s : this.newOrder) {
            if (inputSchema.hasColumn(s)) continue;
            throw new IllegalStateException("Input schema does not contain column with name \"" + s + "\"");
        }
        if (inputSchema.numColumns() < this.newOrder.size()) {
            throw new IllegalArgumentException("Schema has " + inputSchema.numColumns() + " columns but newOrder has " + this.newOrder.size() + " columns");
        }
        List<String> origNames = inputSchema.getColumnNames();
        this.outputOrder = new int[origNames.size()];
        boolean[] taken = new boolean[origNames.size()];
        int j = 0;
        for (String s : this.newOrder) {
            int idx = inputSchema.getIndexOfColumn(s);
            taken[idx] = true;
            this.outputOrder[j++] = idx;
        }
        for (int i = 0; i < taken.length; ++i) {
            if (taken[i]) continue;
            this.outputOrder[j++] = i;
        }
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        ArrayList<Writable> out = new ArrayList<Writable>();
        for (int i : this.outputOrder) {
            out.add(writables.get(i));
        }
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReorderColumnsTransform o2 = (ReorderColumnsTransform)o;
        if (!this.newOrder.equals(o2.newOrder)) {
            return false;
        }
        return Arrays.equals(this.outputOrder, o2.outputOrder);
    }

    public int hashCode() {
        int result = this.newOrder.hashCode();
        result = 31 * result + Arrays.hashCode(this.outputOrder);
        return result;
    }

    public String toString() {
        return "ReorderColumnsTransform(newOrder=" + this.newOrder + ")";
    }
}

