/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.reduce;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.ReduceOp;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.reduce.ColumnReduction;
import org.datavec.api.transform.reduce.IReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

@JsonIgnoreProperties(value={"schema", "keyColumnsSet"})
public class Reducer
implements IReducer {
    private Schema schema;
    private final List<String> keyColumns;
    private final Set<String> keyColumnsSet;
    private final ReduceOp defaultOp;
    private final Map<String, ReduceOp> opMap;
    private Map<String, ColumnReduction> customReductions;
    private Map<String, ConditionalReduction> conditionalReductions;
    private Set<String> ignoreInvalidInColumns;

    private Reducer(Builder builder) {
        this(builder.keyColumns == null ? null : Arrays.asList(builder.keyColumns), builder.defaultOp, builder.opMap, builder.customReductions, builder.conditionalReductions, builder.ignoreInvalidInColumns);
    }

    public Reducer(@JsonProperty(value="keyColumns") List<String> keyColumns, @JsonProperty(value="defaultOp") ReduceOp defaultOp, @JsonProperty(value="opMap") Map<String, ReduceOp> opMap, @JsonProperty(value="customReductions") Map<String, ColumnReduction> customReductions, @JsonProperty(value="conditionalReductions") Map<String, ConditionalReduction> conditionalReductions, @JsonProperty(value="ignoreInvalidInColumns") Set<String> ignoreInvalidInColumns) {
        this.keyColumns = keyColumns;
        this.keyColumnsSet = keyColumns == null ? null : new HashSet<String>(keyColumns);
        this.defaultOp = defaultOp;
        this.opMap = opMap;
        this.customReductions = customReductions;
        this.conditionalReductions = conditionalReductions;
        this.ignoreInvalidInColumns = ignoreInvalidInColumns;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.schema = schema;
        for (ConditionalReduction cr : this.conditionalReductions.values()) {
            cr.getCondition().setInputSchema(schema);
        }
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public List<String> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public Schema transform(Schema schema) {
        int nCols = schema.numColumns();
        List<String> colNames = schema.getColumnNames();
        List<ColumnMetaData> meta = schema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(nCols);
        for (int i = 0; i < nCols; ++i) {
            String outName;
            Serializable reduction;
            String name = colNames.get(i);
            ColumnMetaData inMeta = meta.get(i);
            if (this.keyColumnsSet != null && this.keyColumnsSet.contains(name)) {
                newMeta.add(inMeta);
                continue;
            }
            if (this.customReductions != null && this.customReductions.containsKey(name)) {
                reduction = this.customReductions.get(name);
                outName = reduction.getColumnOutputName(name);
                ColumnMetaData outMeta = reduction.getColumnOutputMetaData(outName, inMeta);
                newMeta.add(outMeta);
                continue;
            }
            if (this.conditionalReductions != null && this.conditionalReductions.containsKey(name)) {
                reduction = this.conditionalReductions.get(name);
                outName = ((ConditionalReduction)reduction).getOutputName();
                ColumnMetaData m = Reducer.getMetaForColumn(((ConditionalReduction)reduction).getReduction(), name, inMeta);
                m.setName(outName);
                newMeta.add(m);
                continue;
            }
            ReduceOp op = this.opMap.get(name);
            if (op == null) {
                op = this.defaultOp;
            }
            newMeta.add(Reducer.getMetaForColumn(op, name, inMeta));
        }
        return schema.newSchema(newMeta);
    }

    private static ColumnMetaData getMetaForColumn(ReduceOp op, String name, ColumnMetaData inMeta) {
        inMeta = inMeta.clone();
        switch (op) {
            case Min: {
                inMeta.setName("min(" + name + ")");
                return inMeta;
            }
            case Max: {
                inMeta.setName("max(" + name + ")");
                return inMeta;
            }
            case Range: {
                inMeta.setName("range(" + name + ")");
                return inMeta;
            }
            case TakeFirst: {
                inMeta.setName("first(" + name + ")");
                return inMeta;
            }
            case TakeLast: {
                inMeta.setName("last(" + name + ")");
                return inMeta;
            }
            case Sum: {
                String outName = "sum(" + name + ")";
                ColumnMetaData outMeta = inMeta instanceof IntegerMetaData || inMeta instanceof LongMetaData ? new LongMetaData(outName) : (inMeta instanceof DoubleMetaData ? new DoubleMetaData(outName) : inMeta);
                outMeta.setName(outName);
                return outMeta;
            }
            case Mean: {
                return new DoubleMetaData("mean(" + name + ")");
            }
            case Stdev: {
                return new DoubleMetaData("stdev(" + name + ")");
            }
            case Count: {
                return new IntegerMetaData("count", 0, null);
            }
            case CountUnique: {
                return new IntegerMetaData("countUnique(" + name + ")", 0, null);
            }
        }
        throw new UnsupportedOperationException("Unknown or not implemented op: " + (Object)((Object)op));
    }

    @Override
    public List<Writable> reduce(List<List<Writable>> examplesList) {
        if (this.schema == null) {
            throw new IllegalStateException("Error: Schema has not been set");
        }
        int nCols = this.schema.numColumns();
        List<String> colNames = this.schema.getColumnNames();
        ArrayList<Writable> out = new ArrayList<Writable>(nCols);
        ArrayList<Writable> tempColumnValues = new ArrayList<Writable>(examplesList.size());
        for (int i = 0; i < nCols; ++i) {
            ReduceOp op;
            String colName = colNames.get(i);
            if (this.keyColumnsSet != null && this.keyColumnsSet.contains(colName)) {
                out.add(examplesList.get(0).get(i));
                continue;
            }
            for (List<Writable> list : examplesList) {
                tempColumnValues.add(list.get(i));
            }
            if (this.customReductions != null && this.customReductions.containsKey(colName)) {
                ColumnReduction reduction = this.customReductions.get(colName);
                Writable reducedColumn = reduction.reduceColumn(tempColumnValues);
                out.add(reducedColumn);
                continue;
            }
            boolean conditionalOp = false;
            if (this.conditionalReductions != null && this.conditionalReductions.containsKey(colName)) {
                ConditionalReduction reduction = this.conditionalReductions.get(colName);
                Condition c = reduction.getCondition();
                ArrayList filteredColumnValues = new ArrayList();
                int j = 0;
                for (List<Writable> example : examplesList) {
                    if (c.condition(example)) {
                        filteredColumnValues.add(tempColumnValues.get(j));
                    }
                    ++j;
                }
                tempColumnValues = filteredColumnValues;
                conditionalOp = true;
            }
            ColumnType type = this.schema.getType(i);
            ReduceOp reduceOp = op = conditionalOp ? this.conditionalReductions.get(colName).getReduction() : this.opMap.get(colName);
            if (op == null) {
                op = this.defaultOp;
            }
            out.add(this.reduceColumn(op, type, tempColumnValues, this.ignoreInvalidInColumns.contains(colName), this.schema.getMetaData(i)));
            tempColumnValues.clear();
        }
        return out;
    }

    private Writable reduceColumn(ReduceOp op, ColumnType type, List<Writable> values, boolean ignoreInvalid, ColumnMetaData metaData) {
        switch (type) {
            case Integer: 
            case Long: {
                return this.reduceLongColumn(op, values, ignoreInvalid, metaData);
            }
            case Double: {
                return this.reduceDoubleColumn(op, values, ignoreInvalid, metaData);
            }
            case String: 
            case Categorical: {
                return this.reduceStringOrCategoricalColumn(op, values, ignoreInvalid, metaData);
            }
            case Time: {
                return this.reduceTimeColumn(op, values, ignoreInvalid, metaData);
            }
            case Bytes: {
                return this.reduceBytesColumn(op, values);
            }
        }
        throw new UnsupportedOperationException("Unknown or not implemented column type: " + (Object)((Object)type));
    }

    private Writable reduceLongColumn(ReduceOp op, List<Writable> values, boolean ignoreInvalid, ColumnMetaData metaData) {
        switch (op) {
            case Min: {
                long min = Long.MAX_VALUE;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    min = Math.min(min, w.toLong());
                }
                return new LongWritable(min);
            }
            case Max: {
                long max = Long.MIN_VALUE;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    max = Math.max(max, w.toLong());
                }
                return new LongWritable(max);
            }
            case Range: {
                long min2 = Long.MAX_VALUE;
                long max2 = Long.MIN_VALUE;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    long l = w.toLong();
                    min2 = Math.min(min2, l);
                    max2 = Math.max(max2, l);
                }
                return new LongWritable(max2 - min2);
            }
            case Sum: 
            case Mean: {
                long sum = 0L;
                int count = 0;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    sum += w.toLong();
                    ++count;
                }
                if (op == ReduceOp.Sum) {
                    return new LongWritable(sum);
                }
                if (count > 0) {
                    return new DoubleWritable((double)sum / (double)count);
                }
                return new DoubleWritable(0.0);
            }
            case Stdev: {
                double[] arr = new double[values.size()];
                int i = 0;
                int countValid = 0;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    arr[i++] = w.toLong();
                    ++countValid;
                }
                if (ignoreInvalid && countValid < arr.length) {
                    arr = Arrays.copyOfRange(arr, 0, countValid);
                }
                return new DoubleWritable(new StandardDeviation().evaluate(arr));
            }
            case Count: {
                if (ignoreInvalid) {
                    int countValid2 = 0;
                    for (Writable w : values) {
                        if (!metaData.isValid(w)) continue;
                        ++countValid2;
                    }
                    return new IntWritable(countValid2);
                }
                return new IntWritable(values.size());
            }
            case CountUnique: {
                HashSet<Long> set = new HashSet<Long>();
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    set.add(w.toLong());
                }
                return new IntWritable(set.size());
            }
            case TakeFirst: {
                if (values.size() > 0) {
                    return values.get(0);
                }
                return new LongWritable(0L);
            }
            case TakeLast: {
                if (values.size() > 0) {
                    return values.get(values.size() - 1);
                }
                return new LongWritable(0L);
            }
        }
        throw new UnsupportedOperationException("Unknown or not implement op: " + (Object)((Object)op));
    }

    private Writable reduceDoubleColumn(ReduceOp op, List<Writable> values, boolean ignoreInvalid, ColumnMetaData metaData) {
        switch (op) {
            case Min: {
                double min = Double.MAX_VALUE;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    min = Math.min(min, w.toDouble());
                }
                return new DoubleWritable(min);
            }
            case Max: {
                double max = -1.7976931348623157E308;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    max = Math.max(max, w.toDouble());
                }
                return new DoubleWritable(max);
            }
            case Range: {
                double min2 = Double.MAX_VALUE;
                double max2 = -1.7976931348623157E308;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    double d = w.toDouble();
                    min2 = Math.min(min2, d);
                    max2 = Math.max(max2, d);
                }
                return new DoubleWritable(max2 - min2);
            }
            case Sum: 
            case Mean: {
                double sum = 0.0;
                int count = 0;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    sum += w.toDouble();
                    ++count;
                }
                if (op == ReduceOp.Sum) {
                    return new DoubleWritable(sum);
                }
                if (count > 0) {
                    return new DoubleWritable(sum / (double)count);
                }
                return new DoubleWritable(0.0);
            }
            case Stdev: {
                double[] arr = new double[values.size()];
                int i = 0;
                int countValid = 0;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    arr[i++] = w.toDouble();
                    ++countValid;
                }
                if (ignoreInvalid && countValid < arr.length) {
                    arr = Arrays.copyOfRange(arr, 0, countValid);
                }
                return new DoubleWritable(new StandardDeviation().evaluate(arr));
            }
            case Count: {
                if (ignoreInvalid) {
                    int countValid2 = 0;
                    for (Writable w : values) {
                        if (!metaData.isValid(w)) continue;
                        ++countValid2;
                    }
                    return new IntWritable(countValid2);
                }
                return new IntWritable(values.size());
            }
            case CountUnique: {
                HashSet<Double> set = new HashSet<Double>();
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    set.add(w.toDouble());
                }
                return new IntWritable(set.size());
            }
            case TakeFirst: {
                if (values.size() > 0) {
                    return values.get(0);
                }
                return new DoubleWritable(0.0);
            }
            case TakeLast: {
                if (values.size() > 0) {
                    return values.get(values.size() - 1);
                }
                return new DoubleWritable(0.0);
            }
        }
        throw new UnsupportedOperationException("Unknown or not implement op: " + (Object)((Object)op));
    }

    private Writable reduceStringOrCategoricalColumn(ReduceOp op, List<Writable> values, boolean ignoreInvalid, ColumnMetaData metaData) {
        switch (op) {
            case Count: {
                if (ignoreInvalid) {
                    int countValid = 0;
                    for (Writable w : values) {
                        if (!metaData.isValid(w)) continue;
                        ++countValid;
                    }
                    return new IntWritable(countValid);
                }
                return new IntWritable(values.size());
            }
            case CountUnique: {
                HashSet<String> set = new HashSet<String>();
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    set.add(w.toString());
                }
                return new IntWritable(set.size());
            }
            case TakeFirst: {
                if (values.size() > 0) {
                    return values.get(0);
                }
                return new Text("");
            }
            case TakeLast: {
                if (values.size() > 0) {
                    return values.get(values.size() - 1);
                }
                return new Text("");
            }
        }
        throw new UnsupportedOperationException("Cannot execute op \"" + (Object)((Object)op) + "\" on String/Categorical column " + "(can only perform Count, CountUnique, TakeFirst and TakeLast ops on categorical columns)");
    }

    private Writable reduceTimeColumn(ReduceOp op, List<Writable> values, boolean ignoreInvalid, ColumnMetaData metaData) {
        switch (op) {
            case Min: {
                long min = Long.MAX_VALUE;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    min = Math.min(min, w.toLong());
                }
                return new LongWritable(min);
            }
            case Max: {
                long max = Long.MIN_VALUE;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    max = Math.max(max, w.toLong());
                }
                return new LongWritable(max);
            }
            case Mean: {
                long sum = 0L;
                int count = 0;
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    sum += w.toLong();
                    ++count;
                }
                return count > 0 ? new LongWritable(sum / (long)count) : new LongWritable(0L);
            }
            case Count: {
                if (ignoreInvalid) {
                    int countValid = 0;
                    for (Writable w : values) {
                        if (!metaData.isValid(w)) continue;
                        ++countValid;
                    }
                    return new IntWritable(countValid);
                }
                return new IntWritable(values.size());
            }
            case CountUnique: {
                HashSet<Long> set = new HashSet<Long>();
                for (Writable w : values) {
                    if (ignoreInvalid && !metaData.isValid(w)) continue;
                    set.add(w.toLong());
                }
                return new IntWritable(set.size());
            }
            case TakeFirst: {
                if (values.size() > 0) {
                    return values.get(0);
                }
                return new LongWritable(0L);
            }
            case TakeLast: {
                if (values.size() > 0) {
                    return values.get(values.size() - 1);
                }
                return new LongWritable(0L);
            }
            case Range: 
            case Sum: 
            case Stdev: {
                throw new UnsupportedOperationException("Reduction op \"" + (Object)((Object)op) + "\" not supported on time columns");
            }
        }
        throw new UnsupportedOperationException("Reduce ops for time columns: not yet implemented");
    }

    private Writable reduceBytesColumn(ReduceOp op, List<Writable> list) {
        if (op == ReduceOp.TakeFirst) {
            return list.get(0);
        }
        if (op == ReduceOp.TakeLast) {
            return list.get(list.size() - 1);
        }
        throw new UnsupportedOperationException("Cannot execute op \"" + (Object)((Object)op) + "\" on Bytes column " + "(can only perform TakeFirst or TakeLast ops on Bytes columns)");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Reducer(");
        if (this.keyColumns != null) {
            sb.append("keyColumns=").append(this.keyColumns).append(",");
        }
        sb.append("defaultOp=").append((Object)this.defaultOp);
        if (this.opMap != null) {
            sb.append(",opMap=").append(this.opMap);
        }
        if (this.customReductions != null) {
            sb.append(",customReductions=").append(this.customReductions);
        }
        if (this.conditionalReductions != null) {
            sb.append(",conditionalReductions=").append(this.conditionalReductions);
        }
        if (this.ignoreInvalidInColumns != null) {
            sb.append(",ignoreInvalidInColumns=").append(this.ignoreInvalidInColumns);
        }
        sb.append(")");
        return sb.toString();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Set<String> getKeyColumnsSet() {
        return this.keyColumnsSet;
    }

    public ReduceOp getDefaultOp() {
        return this.defaultOp;
    }

    public Map<String, ReduceOp> getOpMap() {
        return this.opMap;
    }

    public Map<String, ColumnReduction> getCustomReductions() {
        return this.customReductions;
    }

    public Map<String, ConditionalReduction> getConditionalReductions() {
        return this.conditionalReductions;
    }

    public Set<String> getIgnoreInvalidInColumns() {
        return this.ignoreInvalidInColumns;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setCustomReductions(Map<String, ColumnReduction> customReductions) {
        this.customReductions = customReductions;
    }

    public void setConditionalReductions(Map<String, ConditionalReduction> conditionalReductions) {
        this.conditionalReductions = conditionalReductions;
    }

    public void setIgnoreInvalidInColumns(Set<String> ignoreInvalidInColumns) {
        this.ignoreInvalidInColumns = ignoreInvalidInColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reducer)) {
            return false;
        }
        Reducer other = (Reducer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$keyColumns = this.getKeyColumns();
        List<String> other$keyColumns = other.getKeyColumns();
        if (this$keyColumns == null ? other$keyColumns != null : !((Object)this$keyColumns).equals(other$keyColumns)) {
            return false;
        }
        ReduceOp this$defaultOp = this.getDefaultOp();
        ReduceOp other$defaultOp = other.getDefaultOp();
        if (this$defaultOp == null ? other$defaultOp != null : !((Object)((Object)this$defaultOp)).equals((Object)other$defaultOp)) {
            return false;
        }
        Map<String, ReduceOp> this$opMap = this.getOpMap();
        Map<String, ReduceOp> other$opMap = other.getOpMap();
        if (this$opMap == null ? other$opMap != null : !((Object)this$opMap).equals(other$opMap)) {
            return false;
        }
        Map<String, ColumnReduction> this$customReductions = this.getCustomReductions();
        Map<String, ColumnReduction> other$customReductions = other.getCustomReductions();
        if (this$customReductions == null ? other$customReductions != null : !((Object)this$customReductions).equals(other$customReductions)) {
            return false;
        }
        Map<String, ConditionalReduction> this$conditionalReductions = this.getConditionalReductions();
        Map<String, ConditionalReduction> other$conditionalReductions = other.getConditionalReductions();
        if (this$conditionalReductions == null ? other$conditionalReductions != null : !((Object)this$conditionalReductions).equals(other$conditionalReductions)) {
            return false;
        }
        Set<String> this$ignoreInvalidInColumns = this.getIgnoreInvalidInColumns();
        Set<String> other$ignoreInvalidInColumns = other.getIgnoreInvalidInColumns();
        return !(this$ignoreInvalidInColumns == null ? other$ignoreInvalidInColumns != null : !((Object)this$ignoreInvalidInColumns).equals(other$ignoreInvalidInColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Reducer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $keyColumns = this.getKeyColumns();
        result = result * 59 + ($keyColumns == null ? 43 : ((Object)$keyColumns).hashCode());
        ReduceOp $defaultOp = this.getDefaultOp();
        result = result * 59 + ($defaultOp == null ? 43 : ((Object)((Object)$defaultOp)).hashCode());
        Map<String, ReduceOp> $opMap = this.getOpMap();
        result = result * 59 + ($opMap == null ? 43 : ((Object)$opMap).hashCode());
        Map<String, ColumnReduction> $customReductions = this.getCustomReductions();
        result = result * 59 + ($customReductions == null ? 43 : ((Object)$customReductions).hashCode());
        Map<String, ConditionalReduction> $conditionalReductions = this.getConditionalReductions();
        result = result * 59 + ($conditionalReductions == null ? 43 : ((Object)$conditionalReductions).hashCode());
        Set<String> $ignoreInvalidInColumns = this.getIgnoreInvalidInColumns();
        result = result * 59 + ($ignoreInvalidInColumns == null ? 43 : ((Object)$ignoreInvalidInColumns).hashCode());
        return result;
    }

    private static class ConditionalReduction
    implements Serializable {
        private final String columnName;
        private final String outputName;
        private final ReduceOp reduction;
        private final Condition condition;

        @ConstructorProperties(value={"columnName", "outputName", "reduction", "condition"})
        public ConditionalReduction(String columnName, String outputName, ReduceOp reduction, Condition condition) {
            this.columnName = columnName;
            this.outputName = outputName;
            this.reduction = reduction;
            this.condition = condition;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public ReduceOp getReduction() {
            return this.reduction;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalReduction)) {
                return false;
            }
            ConditionalReduction other = (ConditionalReduction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$outputName = this.getOutputName();
            String other$outputName = other.getOutputName();
            if (this$outputName == null ? other$outputName != null : !this$outputName.equals(other$outputName)) {
                return false;
            }
            ReduceOp this$reduction = this.getReduction();
            ReduceOp other$reduction = other.getReduction();
            if (this$reduction == null ? other$reduction != null : !((Object)((Object)this$reduction)).equals((Object)other$reduction)) {
                return false;
            }
            Condition this$condition = this.getCondition();
            Condition other$condition = other.getCondition();
            return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConditionalReduction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $outputName = this.getOutputName();
            result = result * 59 + ($outputName == null ? 43 : $outputName.hashCode());
            ReduceOp $reduction = this.getReduction();
            result = result * 59 + ($reduction == null ? 43 : ((Object)((Object)$reduction)).hashCode());
            Condition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            return result;
        }

        public String toString() {
            return "Reducer.ConditionalReduction(columnName=" + this.getColumnName() + ", outputName=" + this.getOutputName() + ", reduction=" + (Object)((Object)this.getReduction()) + ", condition=" + this.getCondition() + ")";
        }
    }

    public static class Builder {
        private ReduceOp defaultOp;
        private Map<String, ReduceOp> opMap = new HashMap<String, ReduceOp>();
        private Map<String, ColumnReduction> customReductions = new HashMap<String, ColumnReduction>();
        private Map<String, ConditionalReduction> conditionalReductions = new HashMap<String, ConditionalReduction>();
        private Set<String> ignoreInvalidInColumns = new HashSet<String>();
        private String[] keyColumns;

        public Builder(ReduceOp defaultOp) {
            this.defaultOp = defaultOp;
        }

        public Builder keyColumns(String ... keyColumns) {
            this.keyColumns = keyColumns;
            return this;
        }

        private Builder add(ReduceOp op, String[] cols) {
            for (String s : cols) {
                this.opMap.put(s, op);
            }
            return this;
        }

        public Builder minColumns(String ... columns) {
            return this.add(ReduceOp.Min, columns);
        }

        public Builder maxColumn(String ... columns) {
            return this.add(ReduceOp.Max, columns);
        }

        public Builder sumColumns(String ... columns) {
            return this.add(ReduceOp.Sum, columns);
        }

        public Builder meanColumns(String ... columns) {
            return this.add(ReduceOp.Mean, columns);
        }

        public Builder stdevColumns(String ... columns) {
            return this.add(ReduceOp.Stdev, columns);
        }

        public Builder countColumns(String ... columns) {
            return this.add(ReduceOp.Count, columns);
        }

        public Builder rangeColumns(String ... columns) {
            return this.add(ReduceOp.Range, columns);
        }

        public Builder countUniqueColumns(String ... columns) {
            return this.add(ReduceOp.CountUnique, columns);
        }

        public Builder takeFirstColumns(String ... columns) {
            return this.add(ReduceOp.TakeFirst, columns);
        }

        public Builder takeLastColumns(String ... columns) {
            return this.add(ReduceOp.TakeLast, columns);
        }

        public Builder customReduction(String column, ColumnReduction columnReduction) {
            this.customReductions.put(column, columnReduction);
            return this;
        }

        public Builder conditionalReduction(String column, String outputName, ReduceOp reduction, Condition condition) {
            this.conditionalReductions.put(column, new ConditionalReduction(column, outputName, reduction, condition));
            return this;
        }

        public Builder setIgnoreInvalid(String ... columns) {
            Collections.addAll(this.ignoreInvalidInColumns, columns);
            return this;
        }

        public Reducer build() {
            return new Reducer(this);
        }
    }
}

