/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class DoubleColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final Double value;
    private final Set<Double> set;

    public DoubleColumnCondition(String columnName, ConditionOp op, double value) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public DoubleColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, double value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public DoubleColumnCondition(String column, ConditionOp op, Set<Double> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public DoubleColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Double> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    private DoubleColumnCondition(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="op") ConditionOp op, @JsonProperty(value="value") double value, @JsonProperty(value="set") Set<Double> set) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
        this.op = op;
        this.value = set == null ? Double.valueOf(value) : null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case LessThan: {
                return writable.toDouble() < this.value;
            }
            case LessOrEqual: {
                return writable.toDouble() <= this.value;
            }
            case GreaterThan: {
                return writable.toDouble() > this.value;
            }
            case GreaterOrEqual: {
                return writable.toDouble() >= this.value;
            }
            case Equal: {
                return writable.toDouble() == this.value.doubleValue();
            }
            case NotEqual: {
                return writable.toDouble() != this.value.doubleValue();
            }
            case InSet: {
                return this.set.contains(writable.toDouble());
            }
            case NotInSet: {
                return !this.set.contains(writable.toDouble());
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "DoubleColumnCondition(columnName=\"" + this.columnName + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleColumnCondition)) {
            return false;
        }
        DoubleColumnCondition other = (DoubleColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionOp this$op = this.op;
        ConditionOp other$op = other.op;
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        Double this$value = this.value;
        Double other$value = other.value;
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Set<Double> this$set = this.set;
        Set<Double> other$set = other.set;
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleColumnCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConditionOp $op = this.op;
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        Double $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Set<Double> $set = this.set;
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }
}

