/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class HikariCPConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        long validationTimeout;
        long connectionTimeout;
        long maxLifeTime;
        long threshold;
        long timeout;
        int idle;
        int size;
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.zaxxer.hikari.HikariConfig", (String)"hikaricp.jar");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(storeMgr.getConnectionURL());
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        config.setUsername(dbUser);
        String dbPassword = storeMgr.getConnectionPassword();
        if (dbPassword == null) {
            dbPassword = "";
        }
        config.setPassword(dbPassword);
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, clr);
            config.setDriverClassName(dbDriver);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_POOL_SIZE) && (size = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_POOL_SIZE)) >= 0) {
            config.setMaximumPoolSize(size);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_IDLE) && (idle = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_IDLE)) >= 0) {
            config.setMinimumIdle(idle);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_IDLE_TIMEOUT) && (timeout = (long)storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_IDLE_TIMEOUT)) >= 0L) {
            config.setIdleTimeout(timeout);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_LEAK_DETECTION_THRESHOLD) && (threshold = (long)storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_LEAK_DETECTION_THRESHOLD)) >= 0L) {
            config.setLeakDetectionThreshold(threshold);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_LIFETIME) && (maxLifeTime = (long)storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_LIFETIME)) >= 0L) {
            config.setMaxLifetime(maxLifeTime);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_AUTO_COMMIT)) {
            boolean autoCommit = storeMgr.getBooleanProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_AUTO_COMMIT);
            config.setAutoCommit(autoCommit);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_CONNECTION_WAIT_TIMEOUT) && (connectionTimeout = (long)storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_CONNECTION_WAIT_TIMEOUT)) >= 0L) {
            config.setConnectionTimeout(connectionTimeout);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_NAME)) {
            String poolName = storeMgr.getStringProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_NAME);
            config.setPoolName(poolName);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TRANSACTION_ISOLATION)) {
            String transactionIsolation = storeMgr.getStringProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TRANSACTION_ISOLATION);
            config.setTransactionIsolation(transactionIsolation);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_CATALOG)) {
            String catalog = storeMgr.getStringProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_CATALOG);
            config.setCatalog(catalog);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_READ_ONLY)) {
            boolean readOnly = storeMgr.getBooleanProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_READ_ONLY);
            config.setReadOnly(readOnly);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_ALLOW_POOL_SUPSENSION)) {
            boolean allowPoolSuspension = storeMgr.getBooleanProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_ALLOW_POOL_SUPSENSION);
            config.setAllowPoolSuspension(allowPoolSuspension);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_VALIDATION_TIMEOUT) && (validationTimeout = (long)storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_VALIDATION_TIMEOUT)) >= 0L) {
            config.setValidationTimeout(validationTimeout);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.connectionInitSQL")) {
            String connectionInitSQL = storeMgr.getStringProperty("datanucleus.connectionPool.connectionInitSQL");
            config.setConnectionInitSql(connectionInitSQL);
        }
        HikariDataSource ds = new HikariDataSource(config);
        return new HikariCPConnectionPool(ds);
    }

    public class HikariCPConnectionPool
    implements ConnectionPool {
        final HikariDataSource dataSource;

        public HikariCPConnectionPool(HikariDataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public void close() {
            this.dataSource.close();
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

