/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;

public class ArrayStoreIterator<E>
implements Iterator<E> {
    private final ExecutionContext ec;
    private final Iterator<E> delegate;
    private E lastElement = null;

    ArrayStoreIterator(DNStateManager sm, ResultSet rs, ResultObjectFactory<E> rof, ElementContainerStore backingStore) {
        this.ec = sm.getExecutionContext();
        ArrayList<Object> results = new ArrayList<Object>();
        if (rs != null) {
            JavaTypeMapping elementMapping = backingStore.getElementMapping();
            while (this.next(rs)) {
                Object nextElement;
                int i;
                int[] param;
                if (backingStore.isElementsAreEmbedded() || backingStore.isElementsAreSerialised()) {
                    param = new int[elementMapping.getNumberOfColumnMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (elementMapping instanceof SerialisedPCMapping || elementMapping instanceof SerialisedReferenceMapping || elementMapping instanceof EmbeddedElementPCMapping) {
                        int ownerFieldNumber = -1;
                        if (backingStore.getContainerTable() != null) {
                            ownerFieldNumber = this.getOwnerFieldMetaData(backingStore.getContainerTable()).getAbsoluteFieldNumber();
                        }
                        nextElement = elementMapping.getObject(this.ec, rs, param, sm, ownerFieldNumber);
                    } else {
                        nextElement = elementMapping.getObject(this.ec, rs, param);
                    }
                } else if (elementMapping instanceof ReferenceMapping) {
                    param = new int[elementMapping.getNumberOfColumnMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    nextElement = elementMapping.getObject(this.ec, rs, param);
                } else {
                    nextElement = rof != null ? (Object)rof.getObject() : null;
                }
                results.add(nextElement);
            }
        }
        this.delegate = results.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public E next() {
        this.lastElement = this.delegate.next();
        return this.lastElement;
    }

    @Override
    public synchronized void remove() {
    }

    protected boolean next(Object rs) {
        try {
            return ((ResultSet)rs).next();
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("SQLException", (Throwable)e);
        }
    }

    protected AbstractMemberMetaData getOwnerFieldMetaData(Table containerTable) {
        return ((JoinTable)containerTable).getOwnerMemberMetaData();
    }
}

