/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.DatastorePoolException;
import org.datanucleus.store.rdbms.datasource.dbcp2.DriverManagerConnectionFactory;
import org.datanucleus.store.rdbms.datasource.dbcp2.PoolableConnection;
import org.datanucleus.store.rdbms.datasource.dbcp2.PoolableConnectionFactory;
import org.datanucleus.store.rdbms.datasource.dbcp2.PoolingDataSource;
import org.datanucleus.store.rdbms.datasource.dbcp2.pool2.impl.GenericObjectPool;
import org.datanucleus.util.StringUtils;

public class DBCP2BuiltinConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        GenericObjectPool<PoolableConnection> connectionPool;
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, storeMgr.getNucleusContext().getClassLoaderResolver(null));
        }
        String dbURL = storeMgr.getConnectionURL();
        PoolingDataSource<PoolableConnection> ds = null;
        try {
            int value;
            int validationTimeout;
            Properties dbProps = DBCP2BuiltinConnectionPoolFactory.getPropertiesForDriver(storeMgr);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbProps);
            PoolableConnectionFactory poolableCF = null;
            poolableCF = new PoolableConnectionFactory(connectionFactory, null);
            String testSQL = null;
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TEST_SQL)) {
                testSQL = storeMgr.getStringProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TEST_SQL);
                poolableCF.setValidationQuery(testSQL);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_VALIDATION_TIMEOUT) && (validationTimeout = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_VALIDATION_TIMEOUT)) >= 0) {
                poolableCF.setValidationQueryTimeout(validationTimeout);
            }
            connectionPool = new GenericObjectPool<PoolableConnection>(poolableCF);
            poolableCF.setPool(connectionPool);
            if (testSQL != null) {
                connectionPool.setTestOnBorrow(true);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_IDLE) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_IDLE)) > 0) {
                connectionPool.setMaxIdle(value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_IDLE) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_IDLE)) > 0) {
                connectionPool.setMinIdle(value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_ACTIVE) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_ACTIVE)) > 0) {
                connectionPool.setMaxTotal(value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_WAIT) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_WAIT)) > 0) {
                connectionPool.setMaxWaitMillis(value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TIME_BETWEEN_EVICTOR_RUNS_MILLIS) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TIME_BETWEEN_EVICTOR_RUNS_MILLIS)) > 0) {
                connectionPool.setTimeBetweenEvictionRunsMillis(value);
                int maxIdle = connectionPool.getMaxIdle();
                int numTestsPerEvictionRun = (int)Math.ceil((double)maxIdle / 4.0);
                connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME_MILLIS) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME_MILLIS)) > 0) {
                connectionPool.setMinEvictableIdleTimeMillis(value);
            }
            ds = new PoolingDataSource<PoolableConnection>(connectionPool);
        }
        catch (Exception e) {
            throw new DatastorePoolException("DBCP2", dbDriver, dbURL, e);
        }
        return new DBCPConnectionPool(ds, connectionPool);
    }

    public class DBCPConnectionPool
    implements ConnectionPool {
        final PoolingDataSource dataSource;
        final GenericObjectPool<PoolableConnection> pool;

        public DBCPConnectionPool(PoolingDataSource ds, GenericObjectPool<PoolableConnection> pool) {
            this.dataSource = ds;
            this.pool = pool;
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

