/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.AggregateNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.AvgFunction;

public class AvgWithCastFunction
extends AvgFunction {
    @Override
    protected SQLExpression getAggregateExpression(SQLStatement stmt, List args, JavaTypeMapping m) {
        Class argType = ((SQLExpression)args.get(0)).getJavaTypeMapping().getJavaType();
        ArrayList<StringExpression> checkedArgs = null;
        if (!argType.equals(Double.class) && !argType.equals(Float.class)) {
            SQLExpression argExpr = (SQLExpression)args.get(0);
            boolean applyDistinct = false;
            String argSql = argExpr.toSQLText().toString();
            if (argSql.startsWith("DISTINCT ") && argSql.endsWith(")")) {
                argExpr.unDistinct();
                applyDistinct = true;
            }
            StringExpression checkedArg = new StringExpression(stmt, m, "CAST", (List<SQLExpression>)args, Arrays.asList("double"));
            if (applyDistinct) {
                checkedArg.distinct();
            }
            checkedArgs = new ArrayList<StringExpression>();
            checkedArgs.add(checkedArg);
        } else {
            checkedArgs = args;
        }
        return new AggregateNumericExpression(stmt, m, this.getFunctionName(), checkedArgs);
    }
}

