/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.scostore.AbstractCollectionStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractSetStore<E>
extends AbstractCollectionStore<E>
implements SetStore<E> {
    protected AbstractSetStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    @Override
    public abstract Iterator<E> iterator(DNStateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(DNStateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            NucleusLogger.DATASTORE.debug((Object)("Attempt to remove element=" + StringUtils.toJVMIDString((Object)element) + " but doesn't exist in this Set."));
            return false;
        }
        Object elementToRemove = element;
        ExecutionContext ec = sm.getExecutionContext();
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        boolean modified = false;
        String removeStmt = this.getRemoveStmt(elementToRemove);
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeStmt, false);
                try {
                    int[] rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, elementToRemove, jdbcPosition, this.elementMapping);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    modified = (rowsDeleted = sqlControl.executeStatementUpdate(ec, mconn, removeStmt, ps, true))[0] == 1;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = Localiser.msg((String)"056012", (Object[])new Object[]{removeStmt});
            NucleusLogger.DATASTORE.error((Object)msg, (Throwable)e);
            throw new NucleusDataStoreException(msg, (Throwable)e);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (allowDependentField && dependent && !collmd.isEmbeddedElement()) {
            sm.getExecutionContext().deleteObjectInternal(elementToRemove);
        }
        return modified;
    }
}

