/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.ResultSet;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;

public class PostgreSQLTypeInfo
extends SQLTypeInfo {
    public static final int MAX_PRECISION = 65000;

    public PostgreSQLTypeInfo(ResultSet rs) {
        super(rs);
        if (this.typeName.equalsIgnoreCase("varchar") || this.typeName.equalsIgnoreCase("char")) {
            this.precision = 65000;
        } else if (this.typeName.equalsIgnoreCase("numeric")) {
            this.precision = 64;
        } else if (this.typeName.equalsIgnoreCase("text")) {
            this.dataType = (short)-1;
        } else if (this.typeName.equalsIgnoreCase("bytea")) {
            this.dataType = (short)-4;
        } else if (this.typeName.equalsIgnoreCase("float8")) {
            this.allowsPrecisionSpec = false;
        }
        if (this.precision > 65000) {
            this.precision = 65000;
        }
    }

    public PostgreSQLTypeInfo(String typeName, short dataType, int precision, String literalPrefix, String literalSuffix, String createParams, int nullable, boolean caseSensitive, short searchable, boolean unsignedAttribute, boolean fixedPrecScale, boolean autoIncrement, String localTypeName, short minimumScale, short maximumScale, int numPrecRadix) {
        super(typeName, dataType, precision, literalPrefix, literalSuffix, createParams, nullable, caseSensitive, searchable, unsignedAttribute, fixedPrecScale, autoIncrement, localTypeName, minimumScale, maximumScale, numPrecRadix);
    }

    @Override
    public boolean isCompatibleWith(RDBMSColumnInfo colInfo) {
        if (super.isCompatibleWith(colInfo)) {
            return true;
        }
        short colDataType = colInfo.getDataType();
        if (this.dataType == 2005 && colDataType == -1 || this.dataType == -1 && colDataType == 2005) {
            return true;
        }
        return this.dataType == 2004 && colDataType == -4 || this.dataType == -4 && colDataType == 2004;
    }
}

