/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.rdbms.query.AbstractROF;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.query.StatementNewObjectMapping;
import org.datanucleus.store.rdbms.query.StatementResultMapping;
import org.datanucleus.store.types.converters.TypeConversionHelper;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ResultClassROF
extends AbstractROF {
    private final Class resultClass;
    private final StatementMappingIndex[] stmtMappings;
    private StatementResultMapping resultDefinition;
    private final String[] resultFieldNames;
    private final Class[] resultFieldTypes;
    private final Map<String, Field> resultClassFieldsByName = new HashMap<String, Field>();
    boolean constructionDefined = false;
    private Constructor resultClassArgConstructor = null;
    private Constructor resultClassDefaultConstructor = null;
    private ResultClassMemberSetter[] resultClassMemberSetters = null;
    private static Map<Class, ResultSetGetter> resultSetGetters = new HashMap<Class, ResultSetGetter>(15);

    public ResultClassROF(ExecutionContext ec, ResultSet rs, FetchPlan fp, Class cls, StatementResultMapping resultDefinition) {
        super(ec, rs, fp);
        this.resultClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : (cls == null ? (resultDefinition != null && resultDefinition.getNumberOfResultExpressions() == 1 ? Object.class : Object[].class) : cls);
        this.resultDefinition = resultDefinition;
        this.stmtMappings = null;
        if (resultDefinition != null) {
            this.resultFieldNames = new String[resultDefinition.getNumberOfResultExpressions()];
            this.resultFieldTypes = new Class[resultDefinition.getNumberOfResultExpressions()];
            for (int i = 0; i < this.resultFieldNames.length; ++i) {
                Object stmtMap = resultDefinition.getMappingForResultExpression(i);
                if (stmtMap instanceof StatementMappingIndex) {
                    StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                    this.resultFieldNames[i] = idx.getColumnAlias();
                    this.resultFieldTypes[i] = idx.getMapping().getJavaType();
                    continue;
                }
                if (stmtMap instanceof StatementNewObjectMapping || stmtMap instanceof StatementClassMapping) continue;
                throw new NucleusUserException("Unsupported component " + stmtMap.getClass().getName() + " found in results");
            }
        } else {
            this.resultFieldNames = null;
            this.resultFieldTypes = null;
        }
    }

    public ResultClassROF(ExecutionContext ec, ResultSet rs, Class cls, StatementClassMapping classDefinition) {
        super(ec, rs, null);
        this.resultClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : cls;
        this.resultDefinition = null;
        int[] memberNumbers = classDefinition.getMemberNumbers();
        this.stmtMappings = new StatementMappingIndex[memberNumbers.length];
        this.resultFieldNames = new String[this.stmtMappings.length];
        this.resultFieldTypes = new Class[this.stmtMappings.length];
        for (int i = 0; i < this.stmtMappings.length; ++i) {
            this.stmtMappings[i] = classDefinition.getMappingForMemberPosition(memberNumbers[i]);
            this.resultFieldNames[i] = this.stmtMappings[i].getMapping().getMemberMetaData().getName();
            this.resultFieldTypes[i] = this.stmtMappings[i].getMapping().getJavaType();
        }
    }

    public ResultClassROF(ExecutionContext ec, ResultSet rs, Class cls, String[] resultFieldNames) {
        super(ec, rs, null);
        Class clazz = this.resultClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : cls;
        if (QueryUtils.resultClassIsUserType((String)this.resultClass.getName())) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ResultClassROF.this.populateDeclaredFieldsForUserType(ResultClassROF.this.resultClass);
                    return null;
                }
            });
        }
        this.stmtMappings = null;
        this.resultFieldTypes = null;
        this.resultFieldNames = resultFieldNames != null ? resultFieldNames : new String[]{};
    }

    @Override
    public Object getObject() {
        int i;
        Object[] resultFieldValues = null;
        if (this.resultDefinition != null) {
            resultFieldValues = new Object[this.resultDefinition.getNumberOfResultExpressions()];
            for (i = 0; i < this.resultDefinition.getNumberOfResultExpressions(); ++i) {
                Object stmtMap = this.resultDefinition.getMappingForResultExpression(i);
                if (stmtMap instanceof StatementMappingIndex) {
                    StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                    resultFieldValues[i] = idx.getMapping().getObject(this.ec, this.rs, idx.getColumnPositions());
                    continue;
                }
                if (stmtMap instanceof StatementNewObjectMapping) {
                    StatementNewObjectMapping newIdx = (StatementNewObjectMapping)stmtMap;
                    resultFieldValues[i] = this.getValueForNewObject(newIdx, this.ec, this.rs);
                    continue;
                }
                if (!(stmtMap instanceof StatementClassMapping)) continue;
                StatementClassMapping classMap = (StatementClassMapping)stmtMap;
                Class cls = this.ec.getClassLoaderResolver().classForName(classMap.getClassName());
                AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(cls, this.ec.getClassLoaderResolver());
                PersistentClassROF rof = new PersistentClassROF(this.ec, this.rs, this.fp, classMap, acmd, cls);
                rof.setIgnoreCache(this.ignoreCache);
                resultFieldValues[i] = rof.getObject();
                if (this.resultDefinition.getNumberOfResultExpressions() != 1 || !classMap.getClassName().equals(this.resultClass.getName())) continue;
                return resultFieldValues[0];
            }
        } else if (this.stmtMappings != null) {
            resultFieldValues = new Object[this.stmtMappings.length];
            for (i = 0; i < this.stmtMappings.length; ++i) {
                resultFieldValues[i] = this.stmtMappings[i] != null ? this.stmtMappings[i].getMapping().getObject(this.ec, this.rs, this.stmtMappings[i].getColumnPositions()) : null;
            }
        } else {
            try {
                resultFieldValues = new Object[this.resultFieldNames != null ? this.resultFieldNames.length : 0];
                for (i = 0; i < resultFieldValues.length; ++i) {
                    resultFieldValues[i] = this.getResultObject(this.rs, i + 1);
                }
            }
            catch (SQLException sqe) {
                String msg = Localiser.msg((String)"021043", (Object[])new Object[]{sqe.getMessage()});
                NucleusLogger.QUERY.error((Object)msg);
                throw new NucleusUserException(msg);
            }
        }
        if (this.resultClass == Object[].class) {
            return resultFieldValues;
        }
        if (QueryUtils.resultClassIsSimple((String)this.resultClass.getName())) {
            if (resultFieldValues.length == 1) {
                if (resultFieldValues[0] == null) {
                    return null;
                }
                Object theValue = TypeConversionHelper.convertTo((Object)resultFieldValues[0], (Class)this.resultClass);
                if (theValue != null && this.resultClass.isAssignableFrom(theValue.getClass())) {
                    return theValue;
                }
            }
        } else {
            if (resultFieldValues.length == 1 && resultFieldValues[0] != null && this.resultClass.isAssignableFrom(resultFieldValues[0].getClass())) {
                return resultFieldValues[0];
            }
            if (this.constructionDefined) {
                if (this.resultClassArgConstructor != null) {
                    return QueryUtils.createResultObjectUsingArgumentedConstructor((Constructor)this.resultClassArgConstructor, (Object[])resultFieldValues);
                }
                if (this.resultClassDefaultConstructor != null) {
                    Object obj = null;
                    try {
                        obj = this.resultClassDefaultConstructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        String msg = Localiser.msg((String)"021205", (Object[])new Object[]{this.resultClass.getName()});
                        NucleusLogger.QUERY.error((Object)msg);
                        throw new NucleusUserException(msg);
                    }
                    for (int i2 = 0; i2 < resultFieldValues.length; ++i2) {
                        boolean set;
                        ResultClassMemberSetter setMember = this.resultClassMemberSetters[i2];
                        if (setMember == null || (set = setMember.set(obj, this.resultFieldNames[i2], resultFieldValues[i2]))) continue;
                        String fieldType = resultFieldValues[i2] != null ? resultFieldValues[i2].getClass().getName() : "null";
                        String msg = Localiser.msg((String)"021204", (Object[])new Object[]{this.resultClass.getName(), this.resultFieldNames[i2], fieldType});
                        NucleusLogger.QUERY.error((Object)msg);
                        throw new NucleusUserException(msg);
                    }
                    return obj;
                }
            }
            if (!this.constructionDefined) {
                Object obj2;
                Constructor ctr = QueryUtils.getResultClassConstructorForArguments((Class)this.resultClass, (Class[])this.resultFieldTypes, (Object[])resultFieldValues);
                if (ctr != null) {
                    try {
                        obj2 = ctr.newInstance(resultFieldValues);
                        if (NucleusLogger.QUERY.isDebugEnabled()) {
                            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021216", (Object[])new Object[]{this.resultClass.getName(), StringUtils.objectArrayToString((Object[])resultFieldValues)}));
                        }
                        this.resultClassArgConstructor = ctr;
                        this.constructionDefined = true;
                        return obj2;
                    }
                    catch (Exception obj2) {}
                } else {
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        if (this.resultFieldNames != null) {
                            Object[] ctrArgTypes = new Class[this.resultFieldNames.length];
                            for (int i3 = 0; i3 < this.resultFieldNames.length; ++i3) {
                                ctrArgTypes[i3] = resultFieldValues[i3] != null ? resultFieldValues[i3].getClass() : null;
                            }
                            if (NucleusLogger.QUERY.isDebugEnabled()) {
                                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021206", (Object[])new Object[]{this.resultClass.getName(), StringUtils.objectArrayToString((Object[])ctrArgTypes)}));
                            }
                        } else {
                            StringBuilder str = new StringBuilder();
                            if (this.stmtMappings != null) {
                                for (StatementMappingIndex stmtMapping : this.stmtMappings) {
                                    if (str.length() > 0) {
                                        str.append(",");
                                    }
                                    Class javaType = stmtMapping.getMapping().getJavaType();
                                    str.append(javaType.getName());
                                }
                                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021206", (Object[])new Object[]{this.resultClass.getName(), str.toString()}));
                            }
                        }
                    }
                    obj2 = null;
                    try {
                        ctr = this.resultClass.getDeclaredConstructor(new Class[0]);
                        obj2 = ctr.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        String msg = Localiser.msg((String)"021205", (Object[])new Object[]{this.resultClass.getName()});
                        NucleusLogger.QUERY.error((Object)msg);
                        throw new NucleusUserException(msg);
                    }
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021217", (Object[])new Object[]{this.resultClass.getName()}));
                    }
                    this.resultClassDefaultConstructor = ctr;
                    this.resultClassMemberSetters = new ResultClassMemberSetter[resultFieldValues.length];
                    for (int i4 = 0; i4 < resultFieldValues.length; ++i4) {
                        String fieldName = this.resultFieldNames[i4];
                        Field field = this.resultClassFieldsByName.get(fieldName.toUpperCase());
                        Object value = resultFieldValues[i4];
                        String declaredFieldName = field != null ? field.getName() : fieldName;
                        Field f = ClassUtils.getFieldForClass((Class)this.resultClass, (String)declaredFieldName);
                        if (f != null && Modifier.isPublic(f.getModifiers())) {
                            block69: {
                                try {
                                    f.set(obj2, value);
                                    this.resultClassMemberSetters[i4] = new ResultClassFieldSetter(f);
                                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                                        NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021218", (Object[])new Object[]{this.resultClass.getName(), fieldName}));
                                    }
                                }
                                catch (Exception e) {
                                    Object convertedValue = TypeConversionHelper.convertTo((Object)value, f.getType());
                                    if (convertedValue == value) break block69;
                                    try {
                                        f.set(obj2, convertedValue);
                                        this.resultClassMemberSetters[i4] = new ResultClassFieldSetter(f);
                                        if (NucleusLogger.QUERY.isDebugEnabled()) {
                                            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021219", (Object[])new Object[]{this.resultClass.getName(), fieldName}));
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (this.resultClassMemberSetters[i4] == null && NucleusLogger.QUERY.isDebugEnabled()) {
                                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021209", (Object[])new Object[]{obj2.getClass().getName(), declaredFieldName}));
                            }
                        }
                        if (this.resultClassMemberSetters[i4] == null) {
                            String setMethodName;
                            String string = setMethodName = field != null ? "set" + fieldName.substring(0, 1).toUpperCase() + field.getName().substring(1) : "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                            Class<Object> argType = value != null ? value.getClass() : (field != null ? field.getType() : null);
                            Method setMethod = ClassUtils.getMethodWithArgument((Class)this.resultClass, (String)setMethodName, argType);
                            if (setMethod != null && Modifier.isPublic(setMethod.getModifiers())) {
                                try {
                                    setMethod.invoke(obj2, value);
                                    this.resultClassMemberSetters[i4] = new ResultClassSetMethodSetter(setMethod, null);
                                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                                        NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021220", (Object[])new Object[]{this.resultClass.getName(), fieldName}));
                                    }
                                }
                                catch (Exception exception) {}
                            } else if (setMethod == null) {
                                Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        return ResultClassROF.this.resultClass.getDeclaredMethods();
                                    }
                                });
                                for (int j = 0; j < methods.length; ++j) {
                                    Class<?>[] args = methods[j].getParameterTypes();
                                    if (!methods[j].getName().equals(setMethodName) || !Modifier.isPublic(methods[j].getModifiers()) || args == null || args.length != 1) continue;
                                    try {
                                        Object convValue = TypeConversionHelper.convertTo((Object)value, args[0]);
                                        methods[i4].invoke(obj2, convValue);
                                        this.resultClassMemberSetters[i4] = new ResultClassSetMethodSetter(setMethod, args[0]);
                                        if (!NucleusLogger.QUERY.isDebugEnabled()) break;
                                        NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021221", (Object[])new Object[]{this.resultClass.getName(), fieldName}));
                                        break;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (this.resultClassMemberSetters[i4] == null && NucleusLogger.QUERY.isDebugEnabled()) {
                                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021207", (Object[])new Object[]{obj2.getClass().getName(), setMethodName, argType != null ? argType.getName() : null}));
                            }
                        }
                        if (this.resultClassMemberSetters[i4] == null) {
                            Method putMethod = QueryUtils.getPublicPutMethodForResultClass((Class)this.resultClass);
                            if (putMethod != null) {
                                try {
                                    putMethod.invoke(obj2, fieldName, value);
                                    this.resultClassMemberSetters[i4] = new ResultClassPutMethodSetter(putMethod);
                                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                                        NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021222", (Object[])new Object[]{this.resultClass.getName(), fieldName}));
                                    }
                                }
                                catch (Exception argType) {}
                            } else if (NucleusLogger.QUERY.isDebugEnabled()) {
                                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021208", (Object[])new Object[]{obj2.getClass().getName(), "put"}));
                            }
                        }
                        if (this.resultClassMemberSetters[i4] != null) continue;
                        if (field == null) {
                            NucleusLogger.QUERY.info((Object)Localiser.msg((String)"021215", (Object[])new Object[]{this.resultFieldNames[i4]}));
                            continue;
                        }
                        String fieldType = resultFieldValues[i4] != null ? resultFieldValues[i4].getClass().getName() : "null";
                        String msg = Localiser.msg((String)"021204", (Object[])new Object[]{this.resultClass.getName(), this.resultFieldNames[i4], fieldType});
                        NucleusLogger.QUERY.error((Object)msg);
                        throw new NucleusUserException(msg);
                    }
                    this.constructionDefined = true;
                    return obj2;
                }
            }
        }
        String msg = Localiser.msg((String)"021203", (Object[])new Object[]{this.resultClass.getName()});
        NucleusLogger.QUERY.error((Object)msg);
        throw new NucleusUserException(msg);
    }

    protected Object getValueForNewObject(StatementNewObjectMapping newMap, ExecutionContext ec, ResultSet rs) {
        Object value = null;
        if (newMap.getNumberOfConstructorArgMappings() == 0) {
            try {
                value = newMap.getObjectClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to create object for query result row of type " + newMap.getObjectClass().getName() + " threw an exception", (Throwable)e);
            }
        }
        int numArgs = newMap.getNumberOfConstructorArgMappings();
        Class[] ctrArgTypes = new Class[numArgs];
        Object[] ctrArgValues = new Object[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            Object obj = newMap.getConstructorArgMapping(i);
            if (obj instanceof StatementMappingIndex) {
                StatementMappingIndex idx = (StatementMappingIndex)obj;
                ctrArgValues[i] = idx.getMapping().getObject(ec, rs, idx.getColumnPositions());
            } else {
                ctrArgValues[i] = obj instanceof StatementNewObjectMapping ? this.getValueForNewObject((StatementNewObjectMapping)obj, ec, rs) : obj;
            }
            ctrArgTypes[i] = ctrArgValues[i] != null ? ctrArgValues[i].getClass() : null;
        }
        Constructor ctr = ClassUtils.getConstructorWithArguments((Class)newMap.getObjectClass(), (Class[])ctrArgTypes);
        if (ctr == null) {
            StringBuilder str = new StringBuilder(newMap.getObjectClass().getName() + "(");
            for (int i = 0; i < ctrArgTypes.length; ++i) {
                if (ctrArgTypes[i] != null) {
                    str.append(ctrArgTypes[i].getName());
                } else {
                    str.append("(null)");
                }
                if (i == ctrArgTypes.length - 1) continue;
                str.append(',');
            }
            str.append(")");
            throw new NucleusUserException(Localiser.msg((String)"037013", (Object[])new Object[]{str.toString()}));
        }
        try {
            value = ctr.newInstance(ctrArgValues);
        }
        catch (Exception e) {
            throw new NucleusUserException(Localiser.msg((String)"037015", (Object[])new Object[]{newMap.getObjectClass().getName(), e}));
        }
        return value;
    }

    private void populateDeclaredFieldsForUserType(Class cls) {
        Field[] declaredFields;
        for (Field field : declaredFields = cls.getDeclaredFields()) {
            Field currValue;
            if (field.isSynthetic() || field.getName().startsWith(this.ec.getMetaDataManager().getEnhancedMethodNamePrefix()) || (currValue = this.resultClassFieldsByName.put(field.getName().toUpperCase(), field)) == null) continue;
            if (currValue.getName().equals(field.getName())) {
                NucleusLogger.QUERY.info((Object)("Result column=" + field.getName().toUpperCase() + " is already mapped to \"" + currValue.toString() + "\" but result class also has \"" + field.toString() + "\"; this latter field will not be set."));
                continue;
            }
            throw new NucleusUserException(Localiser.msg((String)"021210", (Object[])new Object[]{field.getName()}));
        }
        if (cls.getSuperclass() != null) {
            this.populateDeclaredFieldsForUserType(cls.getSuperclass());
        }
    }

    private Object getResultObject(ResultSet rs, int columnNumber) throws SQLException {
        ResultSetGetter getter = resultSetGetters.get(this.resultClass);
        if (getter != null) {
            return getter.getValue(rs, columnNumber);
        }
        return rs.getObject(columnNumber);
    }

    static {
        resultSetGetters.put(Boolean.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBoolean(i);
            }
        });
        resultSetGetters.put(Byte.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getByte(i);
            }
        });
        resultSetGetters.put(Short.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getShort(i);
            }
        });
        resultSetGetters.put(Integer.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getInt(i);
            }
        });
        resultSetGetters.put(Long.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getLong(i);
            }
        });
        resultSetGetters.put(Float.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return Float.valueOf(rs.getFloat(i));
            }
        });
        resultSetGetters.put(Double.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getDouble(i);
            }
        });
        resultSetGetters.put(BigDecimal.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBigDecimal(i);
            }
        });
        resultSetGetters.put(String.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getString(i);
            }
        });
        ResultSetGetter timestampGetter = new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getTimestamp(i);
            }
        };
        resultSetGetters.put(Timestamp.class, timestampGetter);
        resultSetGetters.put(java.util.Date.class, timestampGetter);
        resultSetGetters.put(Date.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getDate(i);
            }
        });
        resultSetGetters.put(byte[].class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBytes(i);
            }
        });
        resultSetGetters.put(Reader.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getCharacterStream(i);
            }
        });
        resultSetGetters.put(Array.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getArray(i);
            }
        });
    }

    class ResultClassPutMethodSetter
    implements ResultClassMemberSetter {
        Method putMethod;

        public ResultClassPutMethodSetter(Method m) {
            this.putMethod = m;
        }

        @Override
        public boolean set(Object obj, String fieldName, Object value) {
            try {
                this.putMethod.invoke(obj, fieldName, value);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    class ResultClassSetMethodSetter
    implements ResultClassMemberSetter {
        Method setterMethod;
        Class argType;

        public ResultClassSetMethodSetter(Method m, Class argType) {
            this.setterMethod = m;
            this.argType = argType;
        }

        @Override
        public boolean set(Object obj, String fieldName, Object value) {
            if (this.argType == null) {
                try {
                    this.setterMethod.invoke(obj, value);
                    return true;
                }
                catch (Exception exception) {}
            } else {
                try {
                    Object convValue = TypeConversionHelper.convertTo((Object)value, (Class)this.argType);
                    this.setterMethod.invoke(obj, convValue);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    class ResultClassFieldSetter
    implements ResultClassMemberSetter {
        Field field;

        public ResultClassFieldSetter(Field f) {
            this.field = f;
        }

        @Override
        public boolean set(Object obj, String fieldName, Object value) {
            Object convertedValue;
            Object fieldValue = value;
            if (this.field.getType().isAssignableFrom(value.getClass()) && (convertedValue = TypeConversionHelper.convertTo((Object)value, this.field.getType())) != value) {
                fieldValue = convertedValue;
            }
            try {
                this.field.set(obj, fieldValue);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    static interface ResultClassMemberSetter {
        public boolean set(Object var1, String var2, Object var3);
    }

    private static interface ResultSetGetter {
        public Object getValue(ResultSet var1, int var2) throws SQLException;
    }
}

