/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.types.converters.TypeConversionHelper;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MappingHelper {
    private MappingHelper() {
    }

    public static int[] getMappingIndices(int initialPosition, JavaTypeMapping mapping) {
        if (mapping.getNumberOfColumnMappings() == 0) {
            return new int[]{initialPosition};
        }
        int[] parameter = new int[mapping.getNumberOfColumnMappings()];
        for (int i = 0; i < parameter.length; ++i) {
            parameter[i] = initialPosition + i;
        }
        return parameter;
    }

    public static Object getObjectForDatastoreIdentity(ExecutionContext ec, JavaTypeMapping mapping, ResultSet rs, int[] resultIndexes, AbstractClassMetaData cmd) {
        Object id = MappingHelper.getDatastoreIdentityForResultSetRow(ec, mapping, rs, resultIndexes, cmd);
        if (id == null) {
            return null;
        }
        return ec.findObject(id, false, true, null);
    }

    public static Object getDatastoreIdentityForResultSetRow(ExecutionContext ec, JavaTypeMapping mapping, ResultSet rs, int[] resultIndexes, AbstractClassMetaData cmd) {
        Object idValue = null;
        if (mapping.getNumberOfColumnMappings() > 0) {
            idValue = mapping.getColumnMapping(0).getObject(rs, resultIndexes[0]);
        } else {
            if (mapping.getReferenceMapping() != null) {
                return mapping.getReferenceMapping().getObject(ec, rs, resultIndexes);
            }
            Class fieldType = mapping.getMemberMetaData().getType();
            JavaTypeMapping referenceMapping = mapping.getStoreManager().getDatastoreClass(fieldType.getName(), ec.getClassLoaderResolver()).getIdMapping();
            idValue = referenceMapping.getColumnMapping(0).getObject(rs, resultIndexes[0]);
        }
        if (idValue == null) {
            return null;
        }
        return ec.getNucleusContext().getIdentityManager().getDatastoreId(mapping.getType(), idValue);
    }

    public static Object getApplicationIdentityForResultSetRow(ExecutionContext ec, JavaTypeMapping mapping, ResultSet rs, int[] resultIndexes, AbstractClassMetaData cmd) {
        if (((RDBMSStoreManager)ec.getStoreManager()).getResultValueAtPosition(rs, mapping, resultIndexes[0]) == null) {
            return null;
        }
        if (((ClassMetaData)cmd).isAbstract() && cmd.getObjectidClass() != null) {
            return MappingHelper.getObjectForAbstractClass(ec, mapping, rs, resultIndexes, cmd);
        }
        int totalFieldCount = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        StatementMappingIndex[] statementExpressionIndex = new StatementMappingIndex[totalFieldCount];
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        DatastoreClass datastoreClass = mapping.getStoreManager().getDatastoreClass(cmd.getFullClassName(), clr);
        int[] pkFieldNumbers = cmd.getPKMemberPositions();
        int paramIndex = 0;
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
            JavaTypeMapping m = datastoreClass.getMemberMapping(fmd);
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
            int[] expressionsIndex = new int[m.getNumberOfColumnMappings()];
            for (int j = 0; j < expressionsIndex.length; ++j) {
                expressionsIndex[j] = resultIndexes[paramIndex++];
            }
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setColumnPositions(expressionsIndex);
        }
        StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            resultMappings.addMappingForMember(pkFieldNumbers[i], statementExpressionIndex[pkFieldNumbers[i]]);
        }
        ResultSetGetter resultsFM = new ResultSetGetter(ec, rs, resultMappings, cmd);
        return IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)resultsFM);
    }

    public static Object getObjectForApplicationIdentity(ExecutionContext ec, JavaTypeMapping mapping, ResultSet rs, int[] resultIndexes, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract() && cmd.getObjectidClass() != null) {
            return MappingHelper.getObjectForAbstractClass(ec, mapping, rs, resultIndexes, cmd);
        }
        int totalMemberCount = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        StatementMappingIndex[] statementExpressionIndex = new StatementMappingIndex[totalMemberCount];
        DatastoreClass datastoreClass = mapping.getStoreManager().getDatastoreClass(cmd.getFullClassName(), clr);
        final int[] pkMemberPositions = cmd.getPKMemberPositions();
        int paramIndex = 0;
        for (int i = 0; i < pkMemberPositions.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkMemberPositions[i]);
            JavaTypeMapping m = datastoreClass.getMemberMapping(mmd);
            statementExpressionIndex[mmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
            int[] expressionsIndex = new int[m.getNumberOfColumnMappings()];
            for (int j = 0; j < expressionsIndex.length; ++j) {
                expressionsIndex[j] = resultIndexes[paramIndex++];
            }
            statementExpressionIndex[mmd.getAbsoluteFieldNumber()].setColumnPositions(expressionsIndex);
        }
        StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < pkMemberPositions.length; ++i) {
            resultMappings.addMappingForMember(pkMemberPositions[i], statementExpressionIndex[pkMemberPositions[i]]);
        }
        ResultSetGetter resultsFM = new ResultSetGetter(ec, rs, resultMappings, cmd);
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)resultsFM);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        return ec.findObject(id, new FieldValues((FieldManager)resultsFM, ec){
            final /* synthetic */ FieldManager val$resultsFM;
            final /* synthetic */ ExecutionContext val$ec;
            {
                this.val$resultsFM = fieldManager;
                this.val$ec = executionContext;
            }

            public void fetchFields(DNStateManager sm) {
                sm.replaceFields(pkMemberPositions, this.val$resultsFM);
            }

            public void fetchNonLoadedFields(DNStateManager sm) {
                sm.replaceNonLoadedFields(pkMemberPositions, this.val$resultsFM);
            }

            public FetchPlan getFetchPlanForLoading() {
                return this.val$ec.getFetchPlan();
            }
        }, type, false, true);
    }

    protected static Object getObjectForAbstractClass(ExecutionContext ec, JavaTypeMapping mapping, ResultSet rs, int[] resultIndexes, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Class objectIdClass = clr.classForName(cmd.getObjectidClass());
        Object id = cmd.usesSingleFieldIdentityClass() ? MappingHelper.createSingleFieldIdentity(ec, mapping, rs, resultIndexes, cmd, objectIdClass, clr.classForName(cmd.getFullClassName())) : MappingHelper.createObjectIdentityUsingReflection(ec, mapping, rs, resultIndexes, cmd, objectIdClass);
        return ec.findObject(id, false, true, null);
    }

    protected static Object createSingleFieldIdentity(ExecutionContext ec, JavaTypeMapping mapping, ResultSet rs, int[] resultIndexes, AbstractClassMetaData cmd, Class objectIdClass, Class pcClass) {
        int paramNumber = resultIndexes[0];
        try {
            Object idValue = mapping.getStoreManager().getResultValueAtPosition(rs, mapping, paramNumber);
            if (idValue == null) {
                throw new NucleusException(Localiser.msg((String)"041039")).setFatal();
            }
            idValue = TypeConversionHelper.convertTo((Object)idValue, (Class)IdentityUtils.getKeyTypeForSingleFieldIdentityType((Class)objectIdClass));
            return ec.getNucleusContext().getIdentityManager().getSingleFieldId(objectIdClass, pcClass, idValue);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)Localiser.msg((String)"041036", (Object[])new Object[]{cmd.getObjectidClass(), e}));
            return null;
        }
    }

    protected static Object createObjectIdentityUsingReflection(ExecutionContext ec, JavaTypeMapping mapping, ResultSet rs, int[] resultIndexes, AbstractClassMetaData cmd, Class objectIdClass) {
        Object fieldValue = null;
        try {
            Object id = objectIdClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            int paramIndex = 0;
            int[] pkFieldNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkFieldNums.length; ++i) {
                AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                Field field = objectIdClass.getField(fmd.getName());
                JavaTypeMapping m = mapping.getStoreManager().getDatastoreClass(cmd.getFullClassName(), ec.getClassLoaderResolver()).getMemberMapping(fmd);
                for (int j = 0; j < m.getNumberOfColumnMappings(); ++j) {
                    Class keyType;
                    BigDecimal bigDecimal;
                    Object obj = mapping.getStoreManager().getResultValueAtPosition(rs, mapping, resultIndexes[paramIndex++]);
                    if (obj instanceof BigDecimal && !(bigDecimal = (BigDecimal)obj).subtract(new BigDecimal("" + (obj = TypeConversionHelper.convertTo((Object)bigDecimal, (Class)(keyType = IdentityUtils.getKeyTypeForSingleFieldIdentityType(field.getType())))))).equals(new BigDecimal("0"))) {
                        throw new NucleusException("Cannot convert retrieved BigInteger value to field of object id class!").setFatal();
                    }
                    fieldValue = obj;
                }
                field.set(id, fieldValue);
            }
            return id;
        }
        catch (Exception e) {
            AbstractMemberMetaData mmd = mapping.getMemberMetaData();
            NucleusLogger.PERSISTENCE.error((Object)Localiser.msg((String)"041037", (Object[])new Object[]{cmd.getObjectidClass(), mmd == null ? null : mmd.getName(), fieldValue, e}));
            return null;
        }
    }
}

