/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class StringLength4Method
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (!expr.isParameter() && expr instanceof StringLiteral) {
            SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
            JavaTypeMapping m = exprFactory.getMappingForType(Integer.TYPE, false);
            String val = (String)((StringLiteral)expr).getValue();
            return new IntegerLiteral(stmt, m, val.length(), null);
        }
        if (expr instanceof StringExpression || expr instanceof ParameterLiteral) {
            ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
            funcArgs.add(expr);
            return new NumericExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(Integer.TYPE), "LEN", funcArgs);
        }
        throw new NucleusException(Localiser.msg((String)"060001", (Object[])new Object[]{"length", expr}));
    }
}

