/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;

public class ListStoreIterator<E>
implements ListIterator<E> {
    private final DNStateManager sm;
    private final ListIterator<E> delegate;
    private E lastElement = null;
    private int currentIndex = -1;
    private final AbstractListStore<E> abstractListStore;

    ListStoreIterator(DNStateManager sm, ResultSet resultSet, ResultObjectFactory rof, AbstractListStore<E> als) throws MappedDatastoreException {
        this.sm = sm;
        this.abstractListStore = als;
        ExecutionContext ec = sm.getExecutionContext();
        ArrayList results = new ArrayList();
        if (resultSet != null) {
            Table containerTable = als.getContainerTable();
            boolean elementsAreSerialised = als.isElementsAreSerialised();
            boolean elementsAreEmbedded = als.isElementsAreEmbedded();
            JavaTypeMapping elementMapping = als.getElementMapping();
            while (this.next(resultSet)) {
                Object nextElement;
                int i;
                int[] param;
                if (elementsAreEmbedded || elementsAreSerialised) {
                    param = new int[elementMapping.getNumberOfColumnMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (elementMapping instanceof SerialisedPCMapping || elementMapping instanceof SerialisedReferenceMapping || elementMapping instanceof EmbeddedElementPCMapping) {
                        int ownerFieldNumber = -1;
                        if (containerTable != null) {
                            ownerFieldNumber = this.getOwnerMemberMetaData(this.abstractListStore.containerTable).getAbsoluteFieldNumber();
                        }
                        nextElement = elementMapping.getObject(ec, resultSet, param, sm, ownerFieldNumber);
                    } else {
                        nextElement = elementMapping.getObject(ec, resultSet, param);
                    }
                } else if (elementMapping instanceof ReferenceMapping) {
                    param = new int[elementMapping.getNumberOfColumnMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    nextElement = elementMapping.getObject(ec, resultSet, param);
                } else {
                    nextElement = rof.getObject();
                }
                results.add(nextElement);
            }
        }
        this.delegate = results.listIterator();
    }

    @Override
    public void add(E elem) {
        this.currentIndex = this.delegate.nextIndex();
        this.abstractListStore.add(this.sm, elem, this.currentIndex, -1);
        this.delegate.add(elem);
        this.lastElement = null;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    @Override
    public E next() {
        this.currentIndex = this.delegate.nextIndex();
        this.lastElement = this.delegate.next();
        return this.lastElement;
    }

    @Override
    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    @Override
    public E previous() {
        this.currentIndex = this.delegate.previousIndex();
        this.lastElement = this.delegate.previous();
        return this.lastElement;
    }

    @Override
    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    @Override
    public synchronized void remove() {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to remove");
        }
        this.abstractListStore.remove(this.sm, this.currentIndex, -1);
        this.delegate.remove();
        this.lastElement = null;
        this.currentIndex = -1;
    }

    @Override
    public synchronized void set(E elem) {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to replace");
        }
        this.abstractListStore.set(this.sm, this.currentIndex, elem, true);
        this.delegate.set(elem);
        this.lastElement = elem;
    }

    protected AbstractMemberMetaData getOwnerMemberMetaData(Table containerTable) {
        return ((JoinTable)containerTable).getOwnerMemberMetaData();
    }

    protected boolean next(Object resultSet) throws MappedDatastoreException {
        try {
            return ((ResultSet)resultSet).next();
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(e.getMessage(), e);
        }
    }
}

