/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.AbstractCollectionStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;

class CollectionStoreIterator<E>
implements Iterator<E> {
    private final AbstractCollectionStore<E> collStore;
    private final DNStateManager sm;
    private final ExecutionContext ec;
    private final Iterator<E> delegate;
    private E lastElement = null;

    CollectionStoreIterator(DNStateManager sm, ResultSet rs, ResultObjectFactory rof, AbstractCollectionStore<E> store) throws MappedDatastoreException {
        this.sm = sm;
        this.ec = sm.getExecutionContext();
        this.collStore = store;
        ArrayList results = new ArrayList();
        if (rs != null) {
            while (this.next(rs)) {
                Object nextElement;
                int i;
                int[] param;
                if (this.collStore.elementsAreEmbedded || this.collStore.elementsAreSerialised) {
                    param = new int[this.collStore.elementMapping.getNumberOfColumnMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (this.collStore.elementMapping instanceof SerialisedPCMapping || this.collStore.elementMapping instanceof SerialisedReferenceMapping || this.collStore.elementMapping instanceof EmbeddedElementPCMapping) {
                        int ownerFieldNumber = -1;
                        if (this.collStore.containerTable != null) {
                            ownerFieldNumber = this.getOwnerMemberMetaData(this.collStore.containerTable).getAbsoluteFieldNumber();
                        }
                        nextElement = this.collStore.elementMapping.getObject(this.ec, rs, param, sm, ownerFieldNumber);
                    } else {
                        nextElement = this.collStore.elementMapping.getObject(this.ec, rs, param);
                    }
                } else if (this.collStore.elementMapping instanceof ReferenceMapping) {
                    param = new int[this.collStore.elementMapping.getNumberOfColumnMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    nextElement = this.collStore.elementMapping.getObject(this.ec, rs, param);
                } else {
                    nextElement = rof.getObject();
                }
                results.add(nextElement);
            }
        }
        this.delegate = results.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public E next() {
        this.lastElement = this.delegate.next();
        return this.lastElement;
    }

    @Override
    public synchronized void remove() {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to remove");
        }
        this.collStore.remove(this.sm, this.lastElement, -1, true);
        this.delegate.remove();
        this.lastElement = null;
    }

    protected boolean next(Object rs) throws MappedDatastoreException {
        try {
            return ((ResultSet)rs).next();
        }
        catch (SQLException e) {
            throw new MappedDatastoreException("SQLException", e);
        }
    }

    protected AbstractMemberMetaData getOwnerMemberMetaData(Table containerTable) {
        return ((JoinTable)containerTable).getOwnerMemberMetaData();
    }
}

