/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class TomcatConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        int value;
        int value2;
        int value3;
        int size;
        int value4;
        String dbDriver;
        String dbPassword;
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        if ((dbPassword = storeMgr.getConnectionPassword()) == null) {
            dbPassword = "";
        }
        if (!StringUtils.isWhitespace((String)(dbDriver = storeMgr.getConnectionDriverName()))) {
            this.loadDriver(dbDriver, clr);
        }
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.tomcat.jdbc.pool.DataSource", (String)"tomcat-jdbc.jar");
        PoolProperties config = new PoolProperties();
        String dbURL = storeMgr.getConnectionURL();
        config.setUrl(dbURL);
        config.setDriverClassName(dbDriver != null ? dbDriver : "");
        config.setUsername(dbUser);
        config.setPassword(dbPassword);
        Properties dbProps = TomcatConnectionPoolFactory.getPropertiesForDriver(storeMgr);
        config.setDbProperties(dbProps);
        if (storeMgr.hasProperty("datanucleus.connectionPool.abandonWhenPercentageFull") && (value4 = storeMgr.getIntProperty("datanucleus.connectionPool.abandonWhenPercentageFull")) >= 0) {
            config.setAbandonWhenPercentageFull(value4);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.initialPoolSize")) > 0) {
            config.setInitialSize(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.initSQL")) {
            String value5 = storeMgr.getStringProperty("datanucleus.connectionPool.initSQL");
            config.setInitSQL(value5);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.jdbcInterceptors")) {
            String value6 = storeMgr.getStringProperty("datanucleus.connectionPool.jdbcInterceptors");
            config.setJdbcInterceptors(value6);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.logAbandonded")) {
            String value7 = storeMgr.getStringProperty("datanucleus.connectionPool.logAbandonded");
            config.setLogAbandoned(Boolean.parseBoolean(value7));
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxActive") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxActive")) > 0) {
            config.setMaxActive(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxAge") && (value3 = storeMgr.getIntProperty("datanucleus.connectionPool.maxAge")) >= 0) {
            config.setMaxAge((long)value3);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) >= 0) {
            config.setMaxIdle(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxWait") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxWait")) > 0) {
            config.setMaxWait(value);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis")) > 0) {
            config.setMinEvictableIdleTimeMillis(value);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minIdle") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.minIdle")) >= 0) {
            config.setMinIdle(value);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.removeAbandonded")) {
            String value8 = storeMgr.getStringProperty("datanucleus.connectionPool.removeAbandonded");
            config.setRemoveAbandoned(Boolean.parseBoolean(value8));
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.removeAbandondedTimeout") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.removeAbandondedTimeout")) > 0) {
            config.setRemoveAbandonedTimeout(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.suspectTimeout") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.suspectTimeout")) > 0) {
            config.setSuspectTimeout(value);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.testOnBorrow")) {
            String value9 = storeMgr.getStringProperty("datanucleus.connectionPool.testOnBorrow");
            config.setTestOnBorrow(Boolean.parseBoolean(value9));
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.testOnConnect")) {
            String value10 = storeMgr.getStringProperty("datanucleus.connectionPool.testOnConnect");
            config.setTestOnConnect(Boolean.parseBoolean(value10));
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.testOnReturn")) {
            String value11 = storeMgr.getStringProperty("datanucleus.connectionPool.testOnReturn");
            config.setTestOnReturn(Boolean.parseBoolean(value11));
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.testWhileIdle")) {
            String value12 = storeMgr.getStringProperty("datanucleus.connectionPool.testWhileIdle");
            config.setTestWhileIdle(Boolean.parseBoolean(value12));
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis")) > 0) {
            config.setTimeBetweenEvictionRunsMillis(value);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.validationInterval") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.validationInterval")) >= 0) {
            config.setValidationInterval((long)value);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.validationQuery")) {
            String value13 = storeMgr.getStringProperty("datanucleus.connectionPool.validationQuery");
            config.setValidationQuery(value13);
        }
        return new TomcatConnectionPool(new DataSource((PoolConfiguration)config));
    }

    public class TomcatConnectionPool
    implements ConnectionPool {
        final DataSource dataSource;

        public TomcatConnectionPool(DataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public void close() {
            this.dataSource.close();
        }

        @Override
        public javax.sql.DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

