/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CaseNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class StringIndexOf5Method
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 0, "StringExpression/CharacterExpression/ParameterLiteral"}));
        }
        SQLExpression substrExpr = args.get(0);
        if (!(substrExpr instanceof StringExpression || substrExpr instanceof CharacterExpression || substrExpr instanceof ParameterLiteral)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 0, "StringExpression/CharacterExpression/ParameterLiteral"}));
        }
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        if (args.size() == 1) {
            funcArgs.add(expr);
            funcArgs.add(substrExpr);
            SQLExpression oneExpr = ExpressionUtils.getLiteralForOne(stmt);
            NumericExpression locateExpr = new NumericExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(Integer.TYPE, true), "STRPOS", funcArgs);
            return new NumericExpression(locateExpr, Expression.OP_SUB, oneExpr);
        }
        SQLExpression fromExpr = args.get(1);
        if (!(fromExpr instanceof NumericExpression)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 1, "NumericExpression"}));
        }
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        ArrayList<SQLExpression> substrArgs = new ArrayList<SQLExpression>(1);
        substrArgs.add(fromExpr);
        SQLExpression strExpr = exprFactory.invokeMethod(stmt, "java.lang.String", "substring", expr, substrArgs);
        funcArgs.add(strExpr);
        funcArgs.add(substrExpr);
        NumericExpression locateExpr = new NumericExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(Integer.TYPE, true), "STRPOS", funcArgs);
        SQLExpression[] whenExprs = new SQLExpression[1];
        IntegerLiteral zeroExpr = new IntegerLiteral(stmt, exprFactory.getMappingForType(Integer.class, false), 0, null);
        whenExprs[0] = locateExpr.gt(zeroExpr);
        SQLExpression[] actionExprs = new SQLExpression[1];
        SQLExpression oneExpr = ExpressionUtils.getLiteralForOne(stmt);
        NumericExpression posExpr1 = new NumericExpression(locateExpr, Expression.OP_SUB, oneExpr);
        actionExprs[0] = new NumericExpression(posExpr1, Expression.OP_ADD, fromExpr);
        IntegerLiteral elseExpr = new IntegerLiteral(stmt, exprFactory.getMappingForType(Integer.class, false), -1, null);
        return new CaseNumericExpression(whenExprs, actionExprs, (SQLExpression)elseExpr);
    }
}

