/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class SQLNumericMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression ignore, List<SQLExpression> args) {
        if (args == null || args.size() != 1) {
            throw new NucleusUserException("Cannot invoke SQL_numeric() without a string argument");
        }
        SQLExpression expr = args.get(0);
        if (!(expr instanceof StringLiteral)) {
            throw new NucleusUserException("Cannot use SQL_numeric() without string argument");
        }
        String sql = (String)((StringLiteral)expr).getValue();
        JavaTypeMapping m = stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false);
        NumericExpression retExpr = new NumericExpression(stmt, m, sql);
        return retExpr;
    }
}

