/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.java.ArrayMapping;
import org.datanucleus.store.rdbms.mapping.java.BigDecimalMapping;
import org.datanucleus.store.rdbms.mapping.java.BigIntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.BooleanMapping;
import org.datanucleus.store.rdbms.mapping.java.ByteMapping;
import org.datanucleus.store.rdbms.mapping.java.CharacterMapping;
import org.datanucleus.store.rdbms.mapping.java.CollectionMapping;
import org.datanucleus.store.rdbms.mapping.java.DatastoreIdMapping;
import org.datanucleus.store.rdbms.mapping.java.DateMapping;
import org.datanucleus.store.rdbms.mapping.java.DiscriminatorMapping;
import org.datanucleus.store.rdbms.mapping.java.DoubleMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.EnumMapping;
import org.datanucleus.store.rdbms.mapping.java.FloatMapping;
import org.datanucleus.store.rdbms.mapping.java.GregorianCalendarMapping;
import org.datanucleus.store.rdbms.mapping.java.IntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.InterfaceMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.LongMapping;
import org.datanucleus.store.rdbms.mapping.java.MapMapping;
import org.datanucleus.store.rdbms.mapping.java.NullMapping;
import org.datanucleus.store.rdbms.mapping.java.NumberMapping;
import org.datanucleus.store.rdbms.mapping.java.ObjectMapping;
import org.datanucleus.store.rdbms.mapping.java.OptionalMapping;
import org.datanucleus.store.rdbms.mapping.java.OracleArrayMapping;
import org.datanucleus.store.rdbms.mapping.java.OracleCollectionMapping;
import org.datanucleus.store.rdbms.mapping.java.OracleMapMapping;
import org.datanucleus.store.rdbms.mapping.java.OracleStringLobMapping;
import org.datanucleus.store.rdbms.mapping.java.OrderIndexMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableIdMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceIdMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.ShortMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleCollectionMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlDateMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlTimeMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlTimestampMapping;
import org.datanucleus.store.rdbms.mapping.java.StringMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMultiMapping;
import org.datanucleus.store.rdbms.mapping.java.UUIDMapping;
import org.datanucleus.store.rdbms.mapping.java.VersionMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.ArrayExpression;
import org.datanucleus.store.rdbms.sql.expression.ArrayLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ByteExpression;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.OptionalExpression;
import org.datanucleus.store.rdbms.sql.expression.OptionalLiteral;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SingleCollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.SingleCollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.rdbms.sql.expression.TypeConverterExpression;
import org.datanucleus.store.rdbms.sql.expression.TypeConverterLiteral;
import org.datanucleus.store.rdbms.sql.expression.TypeConverterMultiExpression;
import org.datanucleus.store.rdbms.sql.expression.TypeConverterMultiLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.operation.SQLOperation;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SQLExpressionFactory {
    private static final Class[] EXPR_CREATION_ARG_TYPES = new Class[]{SQLStatement.class, SQLTable.class, JavaTypeMapping.class};
    private static final Class[] LIT_CREATION_ARG_TYPES = new Class[]{SQLStatement.class, JavaTypeMapping.class, Object.class, String.class};
    RDBMSStoreManager storeMgr;
    ClassLoaderResolver clr;
    Map<String, Class> expressionClassByMappingName = new ConcurrentHashMap<String, Class>();
    Map<String, Class> literalClassByMappingName = new ConcurrentHashMap<String, Class>();
    Set<MethodKey> pluginSqlMethodsKeysSupported = new HashSet<MethodKey>();
    Map<MethodKey, SQLMethod> sqlMethodsByKey = new HashMap<MethodKey, SQLMethod>();
    Set<String> pluginSqlOperationKeysSupported = new HashSet<String>();
    Map<String, SQLOperation> sqlOperationsByName = new HashMap<String, SQLOperation>();
    Map<Class, JavaTypeMapping> mappingByClass = new HashMap<Class, JavaTypeMapping>();

    public SQLExpressionFactory(RDBMSStoreManager storeMgr) {
        ConfigurationElement[] operationElems;
        Object key;
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        PluginManager pluginMgr = storeMgr.getNucleusContext().getPluginManager();
        ConfigurationElement[] methodElems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.sql_method", null, null);
        if (methodElems != null) {
            for (int i = 0; i < methodElems.length; ++i) {
                String datastoreName = methodElems[i].getAttribute("datastore");
                if (!StringUtils.isWhitespace((String)datastoreName) && !storeMgr.getDatastoreAdapter().getVendorID().equals(datastoreName)) continue;
                String className = methodElems[i].getAttribute("class");
                String methodName = methodElems[i].getAttribute("method").trim();
                key = this.getSQLMethodKey(datastoreName, className, methodName);
                this.pluginSqlMethodsKeysSupported.add((MethodKey)key);
            }
        }
        if ((operationElems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.sql_operation", null, null)) != null) {
            for (int i = 0; i < operationElems.length; ++i) {
                String datastoreName = operationElems[i].getAttribute("datastore");
                if (!StringUtils.isWhitespace((String)datastoreName) && !storeMgr.getDatastoreAdapter().getVendorID().equals(datastoreName)) continue;
                String name = operationElems[i].getAttribute("name").trim();
                key = this.getSQLOperationKey(datastoreName, name);
                this.pluginSqlOperationKeysSupported.add((String)key);
            }
        }
        this.expressionClassByMappingName.put(BigDecimalMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(BigIntegerMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(BooleanMapping.class.getName(), BooleanExpression.class);
        this.expressionClassByMappingName.put(ByteMapping.class.getName(), ByteExpression.class);
        this.expressionClassByMappingName.put(CharacterMapping.class.getName(), CharacterExpression.class);
        this.expressionClassByMappingName.put(DoubleMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(FloatMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(IntegerMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(LongMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(ShortMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(EnumMapping.class.getName(), EnumExpression.class);
        this.expressionClassByMappingName.put(NumberMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(StringMapping.class.getName(), StringExpression.class);
        this.expressionClassByMappingName.put(OracleStringLobMapping.class.getName(), StringExpression.class);
        this.expressionClassByMappingName.put(OptionalMapping.class.getName(), OptionalExpression.class);
        this.expressionClassByMappingName.put(DateMapping.class.getName(), TemporalExpression.class);
        this.expressionClassByMappingName.put(SqlDateMapping.class.getName(), TemporalExpression.class);
        this.expressionClassByMappingName.put(SqlTimeMapping.class.getName(), TemporalExpression.class);
        this.expressionClassByMappingName.put(SqlTimestampMapping.class.getName(), TemporalExpression.class);
        this.expressionClassByMappingName.put(GregorianCalendarMapping.class.getName(), TemporalExpression.class);
        this.expressionClassByMappingName.put(ArrayMapping.class.getName(), ArrayExpression.class);
        this.expressionClassByMappingName.put(OracleArrayMapping.class.getName(), ArrayExpression.class);
        this.expressionClassByMappingName.put(CollectionMapping.class.getName(), CollectionExpression.class);
        this.expressionClassByMappingName.put(OracleCollectionMapping.class.getName(), CollectionExpression.class);
        this.expressionClassByMappingName.put(SingleCollectionMapping.class.getName(), SingleCollectionExpression.class);
        this.expressionClassByMappingName.put(MapMapping.class.getName(), MapExpression.class);
        this.expressionClassByMappingName.put(OracleMapMapping.class.getName(), MapExpression.class);
        this.expressionClassByMappingName.put(DiscriminatorMapping.DiscriminatorLongMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(DiscriminatorMapping.DiscriminatorStringMapping.class.getName(), StringExpression.class);
        this.expressionClassByMappingName.put(VersionMapping.VersionLongMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(VersionMapping.VersionTimestampMapping.class.getName(), TemporalExpression.class);
        this.expressionClassByMappingName.put(OrderIndexMapping.class.getName(), NumericExpression.class);
        this.expressionClassByMappingName.put(DatastoreIdMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(PersistableMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(PersistableIdMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(ReferenceIdMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(ObjectMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(ReferenceMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(InterfaceMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(EmbeddedPCMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(EmbeddedElementPCMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(EmbeddedKeyPCMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(EmbeddedValuePCMapping.class.getName(), ObjectExpression.class);
        this.expressionClassByMappingName.put(TypeConverterMapping.class.getName(), TypeConverterExpression.class);
        this.expressionClassByMappingName.put(TypeConverterMultiMapping.class.getName(), TypeConverterMultiExpression.class);
        this.literalClassByMappingName.put(BigDecimalMapping.class.getName(), FloatingPointLiteral.class);
        this.literalClassByMappingName.put(BigIntegerMapping.class.getName(), IntegerLiteral.class);
        this.literalClassByMappingName.put(BooleanMapping.class.getName(), BooleanLiteral.class);
        this.literalClassByMappingName.put(ByteMapping.class.getName(), ByteLiteral.class);
        this.literalClassByMappingName.put(CharacterMapping.class.getName(), CharacterLiteral.class);
        this.literalClassByMappingName.put(DoubleMapping.class.getName(), FloatingPointLiteral.class);
        this.literalClassByMappingName.put(FloatMapping.class.getName(), FloatingPointLiteral.class);
        this.literalClassByMappingName.put(IntegerMapping.class.getName(), IntegerLiteral.class);
        this.literalClassByMappingName.put(LongMapping.class.getName(), IntegerLiteral.class);
        this.literalClassByMappingName.put(ShortMapping.class.getName(), IntegerLiteral.class);
        this.literalClassByMappingName.put(EnumMapping.class.getName(), EnumLiteral.class);
        this.literalClassByMappingName.put(NumberMapping.class.getName(), FloatingPointLiteral.class);
        this.literalClassByMappingName.put(StringMapping.class.getName(), StringLiteral.class);
        this.literalClassByMappingName.put(OracleStringLobMapping.class.getName(), StringLiteral.class);
        this.literalClassByMappingName.put(OptionalMapping.class.getName(), OptionalLiteral.class);
        this.literalClassByMappingName.put(DateMapping.class.getName(), TemporalLiteral.class);
        this.literalClassByMappingName.put(SqlDateMapping.class.getName(), TemporalLiteral.class);
        this.literalClassByMappingName.put(SqlTimeMapping.class.getName(), TemporalLiteral.class);
        this.literalClassByMappingName.put(SqlTimestampMapping.class.getName(), TemporalLiteral.class);
        this.literalClassByMappingName.put(GregorianCalendarMapping.class.getName(), TemporalLiteral.class);
        this.literalClassByMappingName.put(ArrayMapping.class.getName(), ArrayLiteral.class);
        this.literalClassByMappingName.put(OracleArrayMapping.class.getName(), ArrayLiteral.class);
        this.literalClassByMappingName.put(CollectionMapping.class.getName(), CollectionLiteral.class);
        this.literalClassByMappingName.put(OracleCollectionMapping.class.getName(), CollectionLiteral.class);
        this.literalClassByMappingName.put(SingleCollectionMapping.class.getName(), SingleCollectionLiteral.class);
        this.literalClassByMappingName.put(MapMapping.class.getName(), MapLiteral.class);
        this.literalClassByMappingName.put(OracleMapMapping.class.getName(), MapLiteral.class);
        this.literalClassByMappingName.put(DiscriminatorMapping.DiscriminatorLongMapping.class.getName(), IntegerLiteral.class);
        this.literalClassByMappingName.put(DiscriminatorMapping.DiscriminatorStringMapping.class.getName(), StringLiteral.class);
        this.literalClassByMappingName.put(VersionMapping.VersionLongMapping.class.getName(), IntegerLiteral.class);
        this.literalClassByMappingName.put(VersionMapping.VersionTimestampMapping.class.getName(), TemporalLiteral.class);
        this.literalClassByMappingName.put(OrderIndexMapping.class.getName(), IntegerLiteral.class);
        this.literalClassByMappingName.put(NullMapping.class.getName(), NullLiteral.class);
        this.literalClassByMappingName.put(DatastoreIdMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(PersistableMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(PersistableIdMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(ReferenceIdMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(ObjectMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(ReferenceMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(InterfaceMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(EmbeddedPCMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(EmbeddedElementPCMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(EmbeddedKeyPCMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(EmbeddedValuePCMapping.class.getName(), ObjectLiteral.class);
        this.literalClassByMappingName.put(TypeConverterMapping.class.getName(), TypeConverterLiteral.class);
        this.literalClassByMappingName.put(TypeConverterMultiMapping.class.getName(), TypeConverterMultiLiteral.class);
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping) {
        return this.newExpression(stmt, sqlTbl, mapping, null);
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping, JavaTypeMapping parentMapping) {
        SQLTable exprSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sqlTbl, parentMapping == null ? mapping : parentMapping);
        Object[] args = new Object[]{stmt, exprSqlTbl, mapping};
        Class expressionClass = this.expressionClassByMappingName.get(mapping.getClass().getName());
        if (expressionClass != null) {
            return (SQLExpression)ClassUtils.newInstance((Class)expressionClass, (Class[])EXPR_CREATION_ARG_TYPES, (Object[])new Object[]{stmt, exprSqlTbl, mapping});
        }
        try {
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "expression-class", EXPR_CREATION_ARG_TYPES, args);
            if (sqlExpr != null) {
                this.expressionClassByMappingName.put(mapping.getClass().getName(), sqlExpr.getClass());
                return sqlExpr;
            }
        }
        catch (Exception e) {
            String msg = Localiser.msg((String)"060005", (Object[])new Object[]{mapping.getClass().getName()});
            NucleusLogger.QUERY.error((Object)msg, (Throwable)e);
            throw new NucleusException(msg, (Throwable)e);
        }
        if (mapping.getClass().getName().equals(UUIDMapping.class.getName())) {
            return (SQLExpression)ClassUtils.newInstance(StringExpression.class, (Class[])EXPR_CREATION_ARG_TYPES, (Object[])new Object[]{stmt, exprSqlTbl, mapping});
        }
        throw new NucleusException(Localiser.msg((String)"060004", (Object[])new Object[]{mapping.getClass().getName()}));
    }

    public SQLExpression newLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        Class literalClass;
        Object[] args = new Object[]{stmt, mapping, value, null};
        if (mapping != null && (literalClass = this.literalClassByMappingName.get(mapping.getClass().getName())) != null) {
            return (SQLExpression)ClassUtils.newInstance((Class)literalClass, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
        }
        try {
            if (mapping == null) {
                return (SQLExpression)ClassUtils.newInstance(NullLiteral.class, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            literalClass = this.literalClassByMappingName.get(mapping.getClass().getName());
            if (literalClass != null) {
                return (SQLExpression)ClassUtils.newInstance((Class)literalClass, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "literal-class", LIT_CREATION_ARG_TYPES, args);
            if (sqlExpr != null) {
                this.literalClassByMappingName.put(mapping.getClass().getName(), sqlExpr.getClass());
                return sqlExpr;
            }
            if (mapping.getClass().getName().equals(UUIDMapping.class.getName())) {
                return (SQLExpression)ClassUtils.newInstance(StringLiteral.class, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            throw new NucleusException(Localiser.msg((String)"060006", (Object[])new Object[]{mapping.getClass().getName()}));
        }
        catch (Exception e) {
            String mappingName = mapping != null ? mapping.getClass().getName() : null;
            NucleusLogger.QUERY.error((Object)("Exception creating SQLLiteral for mapping " + mappingName), (Throwable)e);
            throw new NucleusException(Localiser.msg((String)"060007", (Object[])new Object[]{mappingName}));
        }
    }

    public SQLExpression newLiteralParameter(SQLStatement stmt, JavaTypeMapping mapping, Object value, String paramName) {
        Object[] args = new Object[]{stmt, mapping, value, paramName};
        try {
            if (mapping == null) {
                return (SQLExpression)ClassUtils.newInstance(ParameterLiteral.class, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            Class literalClass = this.literalClassByMappingName.get(mapping.getClass().getName());
            if (literalClass != null) {
                return (SQLExpression)ClassUtils.newInstance((Class)literalClass, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "literal-class", LIT_CREATION_ARG_TYPES, args);
            if (sqlExpr != null) {
                return sqlExpr;
            }
            return new ParameterLiteral(stmt, mapping, value, paramName);
        }
        catch (Exception e) {
            String mappingName = mapping != null ? mapping.getClass().getName() : null;
            NucleusLogger.QUERY.error((Object)("Exception creating SQLLiteral for mapping " + mappingName), (Throwable)e);
            throw new NucleusException(Localiser.msg((String)"060007", (Object[])new Object[]{mappingName}));
        }
    }

    public SQLExpression replaceParameterLiteral(ParameterLiteral paramLit, SQLExpression comparisonExpr) {
        if (comparisonExpr.getJavaTypeMapping().getClass().getName().equals(UUIDMapping.class.getName()) && comparisonExpr.getClass().getName().equals(StringExpression.class.getName())) {
            Object[] args = new Object[]{paramLit.getSQLStatement(), comparisonExpr.getJavaTypeMapping(), paramLit.getValue(), paramLit.getParameterName()};
            return (SQLExpression)ClassUtils.newInstance(StringLiteral.class, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
        }
        return this.newLiteralParameter(paramLit.getSQLStatement(), comparisonExpr.getJavaTypeMapping(), paramLit.getValue(), paramLit.getParameterName());
    }

    public SQLExpression invokeMethod(SQLStatement stmt, String className, String methodName, SQLExpression expr, List args) {
        SQLMethod method = this.getMethod(className, methodName, args);
        if (method != null) {
            return method.getExpression(stmt, expr, args);
        }
        return null;
    }

    public boolean isMethodRegistered(String className, String methodName) {
        if (this.storeMgr.getDatastoreAdapter().getSQLMethodClass(className, methodName, this.clr) != null) {
            return true;
        }
        if (this.pluginSqlMethodsKeysSupported.contains(this.getSQLMethodKey(this.storeMgr.getDatastoreAdapter().getVendorID(), className, methodName))) {
            return true;
        }
        return this.pluginSqlMethodsKeysSupported.contains(this.getSQLMethodKey(null, className, methodName));
    }

    public void registerMethod(String className, String methodName, SQLMethod method) {
        if (this.isMethodRegistered(className, methodName)) {
            throw new NucleusUserException("SQLMethod already defined for class=" + className + " method=" + methodName);
        }
        MethodKey methodKey = this.getSQLMethodKey(this.storeMgr.getDatastoreAdapter().getVendorID(), className, methodName);
        this.pluginSqlMethodsKeysSupported.add(methodKey);
        this.sqlMethodsByKey.put(methodKey, method);
    }

    protected SQLMethod getMethod(String className, String methodName, List args) {
        String[] stringArray;
        String[] stringArray2;
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        MethodKey methodKey1 = this.getSQLMethodKey(datastoreId, className, methodName);
        MethodKey methodKey2 = null;
        SQLMethod method = this.sqlMethodsByKey.get(methodKey1);
        if (method == null) {
            methodKey2 = this.getSQLMethodKey(null, className, methodName);
            method = this.sqlMethodsByKey.get(methodKey2);
        }
        if (method != null) {
            return method;
        }
        Class sqlMethodCls = this.storeMgr.getDatastoreAdapter().getSQLMethodClass(className, methodName, this.clr);
        if (sqlMethodCls != null) {
            try {
                method = (SQLMethod)sqlMethodCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                MethodKey key = this.getSQLMethodKey(datastoreId, className, methodName);
                this.sqlMethodsByKey.put(key, method);
                return method;
            }
            catch (Exception e) {
                throw new NucleusException("Error creating SQLMethod of type " + sqlMethodCls.getName() + " for class=" + className + " method=" + methodName);
            }
        }
        boolean datastoreDependent = true;
        if (!this.pluginSqlMethodsKeysSupported.contains(methodKey1)) {
            datastoreDependent = false;
            if (!this.pluginSqlMethodsKeysSupported.contains(methodKey2)) {
                boolean unsupported = true;
                if (!StringUtils.isWhitespace((String)className)) {
                    Class methodCls;
                    Class cls = this.clr.classForName(className);
                    for (MethodKey methodKey : this.pluginSqlMethodsKeysSupported) {
                        if (!methodKey.methodName.equals(methodName) || !methodKey.datastoreName.equals(datastoreId)) continue;
                        methodCls = null;
                        try {
                            methodCls = this.clr.classForName(methodKey.clsName);
                        }
                        catch (ClassNotResolvedException classNotResolvedException) {
                            // empty catch block
                        }
                        if (methodCls == null || !methodCls.isAssignableFrom(cls)) continue;
                        method = this.sqlMethodsByKey.get(methodKey);
                        if (method != null) {
                            MethodKey superMethodKey = new MethodKey();
                            superMethodKey.clsName = className;
                            superMethodKey.methodName = methodKey.methodName;
                            superMethodKey.datastoreName = methodKey.datastoreName;
                            this.sqlMethodsByKey.put(superMethodKey, method);
                            return method;
                        }
                        className = methodKey.clsName;
                        datastoreId = methodKey.datastoreName;
                        datastoreDependent = true;
                        unsupported = false;
                        break;
                    }
                    if (unsupported) {
                        for (MethodKey methodKey : this.pluginSqlMethodsKeysSupported) {
                            if (!methodKey.methodName.equals(methodName) || !methodKey.datastoreName.equals("ALL")) continue;
                            methodCls = null;
                            try {
                                methodCls = this.clr.classForName(methodKey.clsName);
                            }
                            catch (ClassNotResolvedException superMethodKey) {
                                // empty catch block
                            }
                            if (methodCls == null || !methodCls.isAssignableFrom(cls)) continue;
                            method = this.sqlMethodsByKey.get(methodKey);
                            if (method != null) {
                                MethodKey superMethodKey = new MethodKey();
                                superMethodKey.clsName = className;
                                superMethodKey.methodName = methodKey.methodName;
                                superMethodKey.datastoreName = methodKey.datastoreName;
                                this.sqlMethodsByKey.put(superMethodKey, method);
                                return method;
                            }
                            className = methodKey.clsName;
                            datastoreId = methodKey.datastoreName;
                            datastoreDependent = false;
                            unsupported = false;
                            break;
                        }
                    }
                }
                if (unsupported) {
                    if (className != null) {
                        throw new NucleusUserException(Localiser.msg((String)"060008", (Object[])new Object[]{methodName, className}));
                    }
                    throw new NucleusUserException(Localiser.msg((String)"060009", (Object[])new Object[]{methodName}));
                }
            }
        }
        PluginManager pluginMgr = this.storeMgr.getNucleusContext().getPluginManager();
        if (datastoreDependent) {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "class";
            stringArray3[1] = "method";
            stringArray2 = stringArray3;
            stringArray3[2] = "datastore";
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "class";
            stringArray2 = stringArray4;
            stringArray4[1] = "method";
        }
        String[] attrNames = stringArray2;
        if (datastoreDependent) {
            String[] stringArray5 = new String[3];
            stringArray5[0] = className;
            stringArray5[1] = methodName;
            stringArray = stringArray5;
            stringArray5[2] = datastoreId;
        } else {
            String[] stringArray6 = new String[2];
            stringArray6[0] = className;
            stringArray = stringArray6;
            stringArray6[1] = methodName;
        }
        String[] attrValues = stringArray;
        try {
            method = (SQLMethod)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.sql_method", attrNames, attrValues, "evaluator", new Class[0], new Object[0]);
            this.sqlMethodsByKey.put(this.getSQLMethodKey(datastoreDependent ? datastoreId : null, className, methodName), method);
            return method;
        }
        catch (Exception e) {
            throw new NucleusUserException(Localiser.msg((String)"060011", (Object[])new Object[]{"class=" + className + " method=" + methodName}), (Throwable)e);
        }
    }

    private MethodKey getSQLMethodKey(String datastoreName, String className, String methodName) {
        MethodKey key = new MethodKey();
        key.clsName = className != null ? className.trim() : "";
        key.methodName = methodName;
        key.datastoreName = datastoreName != null ? datastoreName.trim() : "ALL";
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExpression invokeOperation(String name, SQLExpression expr, SQLExpression expr2) {
        String[] stringArray;
        String[] stringArray2;
        DatastoreAdapter dba = this.storeMgr.getDatastoreAdapter();
        SQLOperation operation = this.sqlOperationsByName.get(name);
        if (operation != null) {
            return operation.getExpression(expr, expr2);
        }
        Class sqlOpClass = dba.getSQLOperationClass(name);
        if (sqlOpClass != null) {
            try {
                operation = (SQLOperation)sqlOpClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.sqlOperationsByName.put(name, operation);
                return operation.getExpression(expr, expr2);
            }
            catch (Exception e) {
                throw new NucleusException("Error creating SQLOperation of type " + sqlOpClass.getName() + " for operation " + name);
            }
        }
        String datastoreId = dba.getVendorID();
        String key = this.getSQLOperationKey(datastoreId, name);
        boolean datastoreDependent = true;
        if (!this.pluginSqlOperationKeysSupported.contains(key)) {
            key = this.getSQLOperationKey(null, name);
            datastoreDependent = false;
            if (!this.pluginSqlOperationKeysSupported.contains(key)) {
                throw new UnsupportedOperationException("Operation " + name + " on datastore=" + datastoreId + " not supported");
            }
        }
        PluginManager pluginMgr = this.storeMgr.getNucleusContext().getPluginManager();
        if (datastoreDependent) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "name";
            stringArray2 = stringArray3;
            stringArray3[1] = "datastore";
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = "name";
        }
        String[] attrNames = stringArray2;
        if (datastoreDependent) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = name;
            stringArray = stringArray5;
            stringArray5[1] = datastoreId;
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = name;
        }
        String[] attrValues = stringArray;
        try {
            SQLOperation sQLOperation = operation = (SQLOperation)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.sql_operation", attrNames, attrValues, "evaluator", null, null);
            synchronized (sQLOperation) {
                this.sqlOperationsByName.put(key, operation);
                return operation.getExpression(expr, expr2);
            }
        }
        catch (Exception e) {
            throw new NucleusUserException(Localiser.msg((String)"060011", (Object[])new Object[]{"operation=" + name}), (Throwable)e);
        }
    }

    private String getSQLOperationKey(String datastoreName, String name) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + name;
    }

    public JavaTypeMapping getMappingForType(Class cls, boolean useCached) {
        JavaTypeMapping mapping = null;
        if (useCached && (mapping = this.mappingByClass.get(cls)) != null) {
            return mapping;
        }
        mapping = this.storeMgr.getMappingManager().getMappingWithColumnMapping(cls, false, false, this.clr);
        this.mappingByClass.put(cls, mapping);
        return mapping;
    }

    public JavaTypeMapping getMappingForType(Class cls) {
        return this.getMappingForType(cls, true);
    }

    private class MethodKey {
        String clsName;
        String methodName;
        String datastoreName;

        private MethodKey() {
        }

        public int hashCode() {
            return (this.clsName + this.methodName + this.datastoreName).hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof MethodKey)) {
                return false;
            }
            MethodKey otherKey = (MethodKey)other;
            return otherKey.clsName.equals(this.clsName) && otherKey.methodName.equals(this.methodName) && otherKey.datastoreName.equals(this.datastoreName);
        }
    }
}

