/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.BitSet;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.column.BlobImpl;
import org.datanucleus.store.rdbms.mapping.column.ColumnMappingPostSet;
import org.datanucleus.store.rdbms.mapping.java.ArrayMapping;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.util.Localiser;

public class OracleArrayMapping
extends ArrayMapping {
    @Override
    public void performSetPostProcessing(ObjectProvider op) {
        if (this.containerIsStoredInSingleColumn() && this.columnMappings[0] instanceof ColumnMappingPostSet) {
            Object value = op.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value == null) {
                return;
            }
            byte[] bytes = new byte[]{};
            try {
                if (this.mmd.isSerialized()) {
                    if (!(value instanceof Serializable)) {
                        throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                    }
                    BlobImpl b = new BlobImpl(value);
                    bytes = b.getBytes(0L, (int)b.length());
                } else if (value instanceof boolean[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromBooleanArray((boolean[])((boolean[])value));
                } else if (value instanceof char[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromCharArray((char[])((char[])value));
                } else if (value instanceof double[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromDoubleArray((double[])((double[])value));
                } else if (value instanceof float[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromFloatArray((float[])((float[])value));
                } else if (value instanceof int[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromIntArray((int[])((int[])value));
                } else if (value instanceof long[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromLongArray((long[])((long[])value));
                } else if (value instanceof short[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromShortArray((short[])((short[])value));
                } else if (value instanceof Boolean[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromBooleanObjectArray((Boolean[])((Boolean[])value));
                } else if (value instanceof Byte[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromByteObjectArray((Byte[])((Byte[])value));
                } else if (value instanceof Character[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromCharObjectArray((Character[])((Character[])value));
                } else if (value instanceof Double[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromDoubleObjectArray((Double[])((Double[])value));
                } else if (value instanceof Float[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromFloatObjectArray((Float[])((Float[])value));
                } else if (value instanceof Integer[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromIntObjectArray((Integer[])((Integer[])value));
                } else if (value instanceof Long[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromLongObjectArray((Long[])((Long[])value));
                } else if (value instanceof Short[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromShortObjectArray((Short[])((Short[])value));
                } else if (value instanceof BigDecimal[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromBigDecimalArray((BigDecimal[])((BigDecimal[])value));
                } else if (value instanceof BigInteger[]) {
                    bytes = ArrayConversionHelper.getByteArrayFromBigIntegerArray((BigInteger[])((BigInteger[])value));
                } else if (value instanceof byte[]) {
                    bytes = (byte[])value;
                } else if (value instanceof BitSet) {
                    bytes = ArrayConversionHelper.getByteArrayFromBooleanArray((boolean[])ArrayConversionHelper.getBooleanArrayFromBitSet((BitSet)((BitSet)value)));
                } else {
                    if (!(value instanceof Serializable)) {
                        throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                    }
                    BlobImpl b = new BlobImpl(value);
                    bytes = b.getBytes(0L, (int)b.length());
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.mmd, e.getMessage()}), (Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ((ColumnMappingPostSet)((Object)this.columnMappings[0])).setPostProcessing(op, bytes);
        }
    }

    @Override
    public void postInsert(ObjectProvider op) {
        if (this.containerIsStoredInSingleColumn()) {
            Object value = op.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value == null) {
                return;
            }
            ExecutionContext ec = op.getExecutionContext();
            if (this.mmd.getArray().elementIsPersistent()) {
                Object[] arrElements;
                for (Object elem : arrElements = (Object[])value) {
                    ObjectProvider elemOP;
                    if (elem == null || (elemOP = ec.findObjectProvider(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, elem, false, op, this.mmd.getAbsoluteFieldNumber());
                }
            }
        } else {
            super.postInsert(op);
        }
    }

    @Override
    public void postUpdate(ObjectProvider op) {
        if (this.containerIsStoredInSingleColumn()) {
            Object value = op.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value == null) {
                return;
            }
            ExecutionContext ec = op.getExecutionContext();
            if (this.mmd.getArray().elementIsPersistent()) {
                Object[] arrElements;
                for (Object elem : arrElements = (Object[])value) {
                    ObjectProvider elemOP;
                    if (elem == null || (elemOP = ec.findObjectProvider(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, elem, false, op, this.mmd.getAbsoluteFieldNumber());
                }
            }
        } else {
            super.postUpdate(op);
        }
    }
}

