/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.key;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.key.Key;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class ColumnOrderedKey
extends Key {
    protected List<Boolean> columnOrdering = new ArrayList<Boolean>();
    protected Map<String, String> extensions = null;

    public ColumnOrderedKey(Table table, Map<String, String> extensions) {
        super(table);
        this.extensions = extensions;
    }

    public String getValueForExtension(String key) {
        return this.extensions != null ? this.extensions.get(key) : null;
    }

    @Override
    public void addColumn(Column col) {
        this.assertSameDatastoreObject(col);
        this.columns.add(col);
        this.columnOrdering.add(null);
    }

    public void setColumnOrdering(String ordering) {
        if (StringUtils.isWhitespace((String)ordering)) {
            return;
        }
        StringTokenizer tokeniser = new StringTokenizer(ordering, ",");
        if (tokeniser.countTokens() != this.columns.size()) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Attempt to specify orderings of index with name=" + this.name + " but incorrect number of orderings (" + tokeniser.countTokens() + ") for columns (" + this.columns.size() + "). IGNORED"));
            return;
        }
        Iterator colIter = this.columns.iterator();
        int i = 0;
        while (tokeniser.hasMoreTokens()) {
            String orderingToken = tokeniser.nextToken();
            colIter.next();
            this.columnOrdering.set(i, orderingToken.equalsIgnoreCase("ASC") ? Boolean.TRUE : (orderingToken.equalsIgnoreCase("DESC") ? Boolean.FALSE : null));
            ++i;
        }
    }

    @Override
    public void setColumn(int seq, Column col) {
        this.assertSameDatastoreObject(col);
        ColumnOrderedKey.setListMinimumSize(this.columns, seq + 1);
        ColumnOrderedKey.setListMinimumSize(this.columnOrdering, seq + 1);
        if (this.columns.get(seq) != null) {
            throw new NucleusException("Index/candidate part #" + seq + " for " + this.table + " already set").setFatal();
        }
        this.columns.set(seq, col);
        this.columnOrdering.set(seq, null);
    }

    public String getColumnList(boolean includeOrdering) {
        StringBuilder s = new StringBuilder("(");
        Iterator colIter = this.columns.iterator();
        Iterator<Boolean> colOrderIter = this.columnOrdering.iterator();
        while (colIter.hasNext()) {
            Boolean colOrder;
            Column col = (Column)colIter.next();
            s.append(col != null ? col.getIdentifier() : "?");
            if (includeOrdering && (colOrder = colOrderIter.next()) != null) {
                s.append(colOrder != false ? " ASC" : " DESC");
            }
            if (!colIter.hasNext()) continue;
            s.append(',');
        }
        s.append(')');
        return s.toString();
    }
}

