/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.query.compiler.CompilationComponent;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.InExpression;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MapContainsValueMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        AbstractMemberMetaData mmd;
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"containsValue", "MapExpression", 1}));
        }
        MapExpression mapExpr = (MapExpression)expr;
        SQLExpression valExpr = args.get(0);
        if (valExpr.isParameter() && (mmd = mapExpr.getJavaTypeMapping().getMemberMetaData()) != null && mmd.getMap() != null) {
            Class valCls = stmt.getQueryGenerator().getClassLoaderResolver().classForName(mmd.getMap().getValueType());
            stmt.getQueryGenerator().bindParameter(valExpr.getParameterName(), valCls);
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        if (mapExpr instanceof MapLiteral) {
            MapLiteral lit = (MapLiteral)mapExpr;
            Map map = (Map)lit.getValue();
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            if (map == null || map.size() == 0) {
                return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, false));
            }
            boolean useInExpression = false;
            List<SQLExpression> mapValExprs = lit.getValueLiteral().getValueExpressions();
            if (mapValExprs != null && !mapValExprs.isEmpty()) {
                SQLExpression mapKeyExpr2;
                boolean incompatible = true;
                Class elemtype = clr.classForName(valExpr.getJavaTypeMapping().getType());
                for (SQLExpression mapKeyExpr2 : mapValExprs) {
                    Class mapKeyType = clr.classForName(mapKeyExpr2.getJavaTypeMapping().getType());
                    if (!this.valueTypeCompatible(elemtype, mapKeyType)) continue;
                    incompatible = false;
                    break;
                }
                if (incompatible) {
                    return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, false));
                }
                mapKeyExpr2 = mapValExprs.get(0);
                if (mapKeyExpr2 instanceof StringExpression || mapKeyExpr2 instanceof NumericExpression || mapKeyExpr2 instanceof TemporalExpression || mapKeyExpr2 instanceof CharacterExpression || mapKeyExpr2 instanceof EnumExpression) {
                    useInExpression = true;
                }
            }
            if (useInExpression) {
                SQLExpression[] exprs = mapValExprs != null ? mapValExprs.toArray(new SQLExpression[mapValExprs.size()]) : null;
                return new InExpression(valExpr, exprs);
            }
            MapLiteral.MapValueLiteral mapValueLiteral = lit.getValueLiteral();
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = mapValueLiteral.getValueExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                bExpr = bExpr == null ? elementExprs.get(i).eq(valExpr) : ((BooleanExpression)bExpr).ior(elementExprs.get(i).eq(valExpr));
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        if (stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            boolean useSubquery = this.getNeedsSubquery(stmt);
            SQLJoin.JoinType joinType = SQLJoin.JoinType.INNER_JOIN;
            if (valExpr instanceof UnboundExpression) {
                String varName = ((UnboundExpression)valExpr).getVariableName();
                String extensionName = "datanucleus.query.jdoql." + varName + ".join";
                String extensionValue = (String)stmt.getQueryGenerator().getValueForExtension(extensionName);
                if (extensionValue != null) {
                    if (extensionValue.equalsIgnoreCase("SUBQUERY")) {
                        useSubquery = true;
                    } else if (extensionValue.equalsIgnoreCase("INNERJOIN")) {
                        useSubquery = false;
                    } else if (extensionValue.equalsIgnoreCase("LEFTOUTERJOIN")) {
                        joinType = SQLJoin.JoinType.LEFT_OUTER_JOIN;
                    }
                }
            }
            if (useSubquery) {
                return this.containsAsSubquery(stmt, mapExpr, valExpr);
            }
            return this.containsAsJoin(stmt, mapExpr, valExpr, joinType);
        }
        return this.containsAsSubquery(stmt, mapExpr, valExpr);
    }

    protected boolean getNeedsSubquery(SQLStatement stmt) {
        Boolean hasNOT;
        boolean needsSubquery = false;
        Boolean hasOR = (Boolean)stmt.getQueryGenerator().getProperty("Filter.OR");
        if (hasOR != null && hasOR.booleanValue()) {
            needsSubquery = true;
        }
        if ((hasNOT = (Boolean)stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
            needsSubquery = true;
        }
        return needsSubquery;
    }

    protected SQLExpression containsAsJoin(SQLStatement stmt, MapExpression mapExpr, SQLExpression valExpr, SQLJoin.JoinType joinType) {
        boolean valIsUnbound = valExpr instanceof UnboundExpression;
        String varName = null;
        String valAlias = null;
        if (valIsUnbound) {
            varName = ((UnboundExpression)valExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("map.containsValue(" + valExpr + ") binding unbound variable " + varName + " using INNER JOIN"));
        } else if (!stmt.getQueryGenerator().hasExplicitJoins() && stmt.getJoinTypeForTable(valExpr.getSQLTable()) == SQLJoin.JoinType.CROSS_JOIN) {
            valAlias = stmt.removeCrossJoin(valExpr.getSQLTable());
            valIsUnbound = true;
            NucleusLogger.QUERY.debug((Object)("map.containsValue(" + valExpr + ") was previously bound as CROSS JOIN but changing to INNER JOIN"));
        }
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr);
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            MapTable mapTbl = (MapTable)storeMgr.getTable(mmd);
            SQLTable joinSqlTbl = stmt.join(joinType, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), mapTbl, null, mapTbl.getOwnerMapping(), null, null);
            if (valCmd != null) {
                if (valIsUnbound) {
                    DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), clr);
                    SQLTable valSqlTbl = stmt.join(joinType, joinSqlTbl, mapTbl.getValueMapping(), valTbl, valAlias, valTbl.getIdMapping(), null, null);
                    valExpr = exprFactory.newExpression(stmt, valSqlTbl, valSqlTbl.getTable().getIdMapping());
                    stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = exprFactory.newExpression(stmt, joinSqlTbl, mapTbl.getValueMapping());
                    stmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else if (valIsUnbound) {
                valExpr = exprFactory.newExpression(stmt, joinSqlTbl, mapTbl.getValueMapping());
                stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = exprFactory.newExpression(stmt, joinSqlTbl, mapTbl.getValueMapping());
                stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            SQLTable valSqlTbl = stmt.join(joinType, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), valTbl, valAlias, ownerMapping, null, null);
            if (valIsUnbound) {
                valExpr = exprFactory.newExpression(stmt, valSqlTbl, valTbl.getIdMapping());
                stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = exprFactory.newExpression(stmt, valSqlTbl, valTbl.getIdMapping());
                stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), clr);
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(mmd.getValueMetaData().getMappedBy());
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            SQLTable keySqlTbl = stmt.join(joinType, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), keyTbl, null, ownerMapping, null, null);
            if (valCmd != null) {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), clr);
                SQLTable valSqlTbl = stmt.join(joinType, keySqlTbl, keyTbl.getMemberMapping(keyValMmd), valTbl, valAlias, valTbl.getIdMapping(), null, null);
                if (valIsUnbound) {
                    valExpr = exprFactory.newExpression(stmt, valSqlTbl, valTbl.getIdMapping());
                    stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = exprFactory.newExpression(stmt, valSqlTbl, valTbl.getIdMapping());
                    stmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else if (valIsUnbound) {
                valExpr = exprFactory.newExpression(stmt, keySqlTbl, keyTbl.getMemberMapping(keyValMmd));
                stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = exprFactory.newExpression(stmt, keySqlTbl, keyTbl.getMemberMapping(keyValMmd));
                stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        }
        JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
        return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(SQLStatement stmt, MapExpression mapExpr, SQLExpression valExpr) {
        boolean valIsUnbound = valExpr instanceof UnboundExpression;
        String varName = null;
        if (valIsUnbound) {
            varName = ((UnboundExpression)valExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("map.containsValue binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr);
        MapTable joinTbl = (MapTable)storeMgr.getTable(mmd);
        SelectStatement subStmt = null;
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            if (valCmd == null) {
                subStmt = new SelectStatement(stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getValueMapping());
                    stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getValueMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), clr);
                subStmt = new SelectStatement(stmt, storeMgr, valTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.join(SQLJoin.JoinType.INNER_JOIN, subStmt.getPrimaryTable(), valTbl.getIdMapping(), (Table)joinTbl, null, joinTbl.getValueMapping(), null, null, true);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            subStmt = new SelectStatement(stmt, storeMgr, valTbl, null, null);
            subStmt.setClassLoaderResolver(clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            SQLExpression ownerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            if (valIsUnbound) {
                valExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                JavaTypeMapping valMapping = valTbl.getIdMapping();
                SQLExpression valIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
                subStmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(mmd.getValueMetaData().getMappedBy());
            if (valCmd == null) {
                subStmt = new SelectStatement(stmt, storeMgr, keyTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getMemberMapping(keyValMmd));
                    stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    JavaTypeMapping valMapping = keyTbl.getMemberMapping(keyValMmd);
                    SQLExpression valIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), clr);
                subStmt = new SelectStatement(stmt, storeMgr, valTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable keySqlTbl = subStmt.join(SQLJoin.JoinType.INNER_JOIN, subStmt.getPrimaryTable(), valTbl.getIdMapping(), (Table)keyTbl, null, keyTbl.getMemberMapping(keyValMmd), null, null, true);
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, keySqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            }
        }
        return new BooleanSubqueryExpression(stmt, "EXISTS", subStmt);
    }

    protected boolean valueTypeCompatible(Class valType, Class mapValType) {
        if (!valType.isPrimitive() && mapValType.isPrimitive() && !mapValType.isAssignableFrom(valType) && !valType.isAssignableFrom(mapValType)) {
            return false;
        }
        if (valType.isPrimitive()) {
            if (valType == Boolean.TYPE && mapValType == Boolean.class) {
                return true;
            }
            if (valType == Byte.TYPE && mapValType == Byte.class) {
                return true;
            }
            if (valType == Character.TYPE && mapValType == Character.class) {
                return true;
            }
            if (valType == Double.TYPE && mapValType == Double.class) {
                return true;
            }
            if (valType == Float.TYPE && mapValType == Float.class) {
                return true;
            }
            if (valType == Integer.TYPE && mapValType == Integer.class) {
                return true;
            }
            if (valType == Long.TYPE && mapValType == Long.class) {
                return true;
            }
            return valType == Short.TYPE && mapValType == Short.class;
        }
        return true;
    }
}

