/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.UUID;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.PostgreSQLTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.column.ArrayColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.OtherColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SqlXmlColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TinyIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.schema.ForeignKeyInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.LogFunction2;
import org.datanucleus.store.rdbms.sql.method.StringConcat1Method;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf5Method;
import org.datanucleus.store.rdbms.sql.method.StringSimilarPostgresqlMethod;
import org.datanucleus.store.rdbms.sql.method.StringSubstring5Method;
import org.datanucleus.store.rdbms.sql.method.StringTranslateMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrim3Method;
import org.datanucleus.store.rdbms.sql.method.StringTrimLeft3Method;
import org.datanucleus.store.rdbms.sql.method.StringTrimRight3Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalQuarterMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalWeekMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod3;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PostgreSQLAdapter
extends BaseDatastoreAdapter {
    public static final String POSTGRESQL_RESERVED_WORDS = "ALL,ANALYSE,ANALYZE,DO,FREEZE,ILIKE,ISNULL,OFFSET,PLACING,VERBOSE";

    public PostgreSQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        if (this.datastoreMajorVersion < 7) {
            throw new NucleusDataStoreException("PostgreSQL version is " + this.datastoreMajorVersion + '.' + this.datastoreMinorVersion + ", 7.0 or later required");
        }
        if (this.datastoreMajorVersion == 7 && this.datastoreMinorVersion <= 2) {
            --this.maxTableNameLength;
            --this.maxConstraintNameLength;
            --this.maxIndexNameLength;
        }
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)POSTGRESQL_RESERVED_WORDS));
        this.supportedOptions.add("LockRowUsingSelectForUpdate");
        this.supportedOptions.add("LockRowSelectForUpdateNowait");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.add("ParameterInCaseInUpdateClause");
        this.supportedOptions.remove("IdentityColumnTypeSpecification");
        this.supportedOptions.remove("IdentityNullSpecification");
        this.supportedOptions.remove("DistinctWithSelectForUpdate");
        this.supportedOptions.remove("PersistOfUnassignedChar");
        if (this.datastoreMajorVersion == 7 && this.datastoreMinorVersion < 2) {
            this.supportedOptions.remove("AlterTableDropConstraint_Syntax");
        } else {
            this.supportedOptions.add("AlterTableDropConstraint_Syntax");
        }
        this.supportedOptions.add("BitIsReallyBoolean");
        this.supportedOptions.add("CharColumnsPaddedWithSpaces");
        if (this.datastoreMajorVersion >= 11) {
            this.supportedOptions.add("StoredProcs");
        }
        this.supportedOptions.remove("TxIsolationNone");
        this.supportedOptions.remove("UpdateStmtAllowTableAliasInSet");
        this.supportedOptions.remove("TxIsolationReadUncommitted");
        this.supportedOptions.add("BitwiseAndOperator");
        this.supportedOptions.add("BitwiseOrOperator");
        this.supportedOptions.add("BitwiseXOrOperator");
        this.supportedOptions.add("NativeEnumType");
        this.supportedOptions.remove("ValueGeneratorUUIDString");
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        PostgreSQLTypeInfo sqlType = new PostgreSQLTypeInfo("char", 1, 65000, null, null, null, 0, false, 3, false, false, false, "char", 0, 0, 10);
        boolean added = this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("text", 2005, 0, null, null, null, 1, true, 3, true, false, false, "text", 0, 0, 10);
        added = this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        if (added) {
            this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.CLOB, "text", false);
        } else {
            this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        }
        sqlType = new PostgreSQLTypeInfo("bytea", 2004, 0, null, null, null, 1, true, 3, true, false, false, "bytea", 0, 0, 10);
        added = this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType, true);
        if (added) {
            this.registerColumnMapping(String.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.BLOB, "bytea", false);
            this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.BLOB, "bytea", false);
            this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.BLOB, "bytea", false);
        } else {
            this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
            this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
            this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        }
        sqlType = new PostgreSQLTypeInfo("bool", 16, 0, null, null, null, 1, false, 3, true, false, false, "bool", 0, 0, 10);
        added = this.addSQLTypeForJDBCType(handler, mconn, (short)16, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("int2", -6, 0, null, null, null, 1, false, 3, false, false, false, "int2", 0, 0, 10);
        added = this.addSQLTypeForJDBCType(handler, mconn, (short)-6, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("text array", 2003, 0, null, null, null, 1, false, 3, false, false, false, "text array", 0, 0, 10);
        added = this.addSQLTypeForJDBCType(handler, mconn, (short)2003, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("int array", 2003, 0, null, null, null, 1, false, 3, false, false, false, "int array", 0, 0, 10);
        added = this.addSQLTypeForJDBCType(handler, mconn, (short)2003, sqlType, true);
    }

    @Override
    public String getVendorID() {
        return "postgresql";
    }

    @Override
    public String getPreferredDefaultSQLTypeForJDBCType(JdbcType jdbcType) {
        if (jdbcType == JdbcType.BIGINT) {
            return "int8";
        }
        if (jdbcType == JdbcType.BIT) {
            return "bool";
        }
        if (jdbcType == JdbcType.BLOB) {
            return "bytea";
        }
        if (jdbcType == JdbcType.CHAR) {
            return "char";
        }
        if (jdbcType == JdbcType.CLOB) {
            return "text";
        }
        if (jdbcType == JdbcType.DATE) {
            return "date";
        }
        if (jdbcType == JdbcType.DOUBLE) {
            return "float8";
        }
        if (jdbcType == JdbcType.INTEGER) {
            return "int4";
        }
        if (jdbcType == JdbcType.LONGVARCHAR) {
            return "text";
        }
        if (jdbcType == JdbcType.NUMERIC) {
            return "numeric";
        }
        if (jdbcType == JdbcType.REAL) {
            return "float4";
        }
        if (jdbcType == JdbcType.SMALLINT) {
            return "int2";
        }
        if (jdbcType == JdbcType.TIME) {
            return "time";
        }
        if (jdbcType == JdbcType.TIMESTAMP) {
            return "timestamptz";
        }
        if (jdbcType == JdbcType.VARCHAR) {
            return "varchar";
        }
        return super.getPreferredDefaultSQLTypeForJDBCType(jdbcType);
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        PostgreSQLTypeInfo info = new PostgreSQLTypeInfo(rs);
        return info;
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        String columnDef;
        int decimalDigits;
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        String typeName = info.getTypeName();
        if (typeName.equalsIgnoreCase("text")) {
            info.setDataType((short)-1);
        } else if (typeName.equalsIgnoreCase("bytea")) {
            info.setDataType((short)-4);
        }
        int columnSize = info.getColumnSize();
        if (columnSize > 65000) {
            info.setColumnSize(-1);
        }
        if ((decimalDigits = info.getDecimalDigits()) > 65000) {
            info.setDecimalDigits(-1);
        }
        if ((columnDef = info.getColumnDef()) != null) {
            if (columnDef.startsWith("nextval(")) {
                info.setColumnDef(null);
            } else if (!(columnDef.startsWith("'") && columnDef.endsWith("'") || !columnDef.contains("::"))) {
                info.setColumnDef(columnDef.substring(0, columnDef.indexOf("::")));
            }
        }
        return info;
    }

    @Override
    public ForeignKeyInfo newFKInfo(ResultSet rs) {
        ForeignKeyInfo info = super.newFKInfo(rs);
        String fkName = (String)info.getProperty("fk_name");
        int firstBackslashIdx = fkName.indexOf(92);
        if (firstBackslashIdx > 0) {
            info.addProperty("fk_name", fkName.substring(0, firstBackslashIdx));
        }
        return info;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP SCHEMA IF EXISTS " + schemaName + " CASCADE";
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getDropTableStatement(Table table) {
        if (this.datastoreMajorVersion < 7 || this.datastoreMajorVersion == 7 && this.datastoreMinorVersion < 3) {
            return "DROP TABLE " + table.toString();
        }
        return super.getDropTableStatement(table);
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String extendedSetting = idx.getValueForExtension("extended-setting");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ").append(idx.getUnique() ? "UNIQUE " : "").append("INDEX ");
        stringBuilder.append(factory.getIdentifierInAdapterCase(idx.getName()));
        stringBuilder.append(" ON ").append(idx.getTable().toString());
        stringBuilder.append(" ").append(idx.getColumnList(true));
        if (extendedSetting != null) {
            stringBuilder.append(" ").append(extendedSetting);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getIdentityLastValueStmt(Table table, String columnName) {
        String tableName;
        boolean quoted;
        StringBuilder stmt = new StringBuilder("SELECT currval('");
        if (table.getSchemaName() != null) {
            stmt.append(table.getSchemaName().replace(this.getIdentifierQuoteString(), ""));
            stmt.append(this.getCatalogSeparator());
        }
        if (quoted = (tableName = table.getIdentifier().toString()).startsWith(this.getIdentifierQuoteString())) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append(tableName.replace(this.getIdentifierQuoteString(), ""));
        stmt.append("_");
        stmt.append(columnName.replace(this.getIdentifierQuoteString(), ""));
        stmt.append("_seq");
        if (quoted) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append("')");
        return stmt.toString();
    }

    @Override
    public String getIdentityKeyword() {
        return "SERIAL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sequenceExists(Connection conn, String catalogName, String schemaName, String seqName) {
        String stmtStr = "SELECT relname FROM pg_class WHERE relname=?";
        Statement ps = null;
        ResultSet rs = null;
        String seqNameToSearch = seqName;
        if (seqName.startsWith("\"") && seqName.endsWith("\"")) {
            seqNameToSearch = seqName.substring(1, seqName.length() - 1);
        }
        try {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)(stmtStr + " : for sequence=" + seqNameToSearch));
            ps = conn.prepareStatement(stmtStr);
            ps.setString(1, seqNameToSearch);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqle) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Exception while executing query for sequence " + seqNameToSearch + " : " + stmtStr + " - " + sqle.getMessage()));
        }
        finally {
            try {
                try {
                    if (rs != null && !rs.isClosed()) {
                        rs.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException sQLException) {}
        }
        return super.sequenceExists(conn, catalogName, schemaName, seqName);
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        } else {
            stmt.append(" CACHE 1");
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("SELECT nextval('");
        stmt.append(sequenceName);
        stmt.append("')");
        return stmt.toString();
    }

    @Override
    public boolean supportsQueryFetchSize(int size) {
        return this.driverMajorVersion > 7;
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset <= 0L && count <= 0L) {
            return "";
        }
        if (this.datastoreMajorVersion < 8 || this.datastoreMajorVersion == 8 && this.datastoreMinorVersion <= 3) {
            String str = "";
            if (count > 0L) {
                str = str + "LIMIT " + count + " ";
            }
            if (offset >= 0L) {
                str = str + "OFFSET " + offset + " ";
            }
            return str;
        }
        StringBuilder str = new StringBuilder();
        if (offset > 0L) {
            str.append("OFFSET " + offset + (offset > 1L ? " ROWS " : " ROW "));
        }
        if (count > 0L) {
            str.append("FETCH NEXT " + (count > 1L ? count + " ROWS ONLY " : "ROW ONLY "));
        }
        return str.toString();
    }

    @Override
    public String getEscapePatternExpression() {
        if (this.datastoreMajorVersion > 8 || this.datastoreMajorVersion == 8 && this.datastoreMinorVersion >= 3) {
            return "ESCAPE E'\\\\'";
        }
        return "ESCAPE '\\\\'";
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == 57014;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("log".equals(methodName)) {
                return LogFunction2.class;
            }
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod3.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod3.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod3.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod3.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod2.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod3.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod3.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod3.class;
            }
            if ("WEEK".equals(methodName)) {
                return TemporalWeekMethod3.class;
            }
            if ("QUARTER".equals(methodName)) {
                return TemporalQuarterMethod3.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("concat".equals(methodName)) {
                    return StringConcat1Method.class;
                }
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf5Method.class;
                }
                if ("similarTo".equals(methodName)) {
                    return StringSimilarPostgresqlMethod.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring5Method.class;
                }
                if ("translate".equals(methodName)) {
                    return StringTranslateMethod.class;
                }
                if ("trim".equals(methodName)) {
                    return StringTrim3Method.class;
                }
                if ("trimLeft".equals(methodName)) {
                    return StringTrimLeft3Method.class;
                }
                if ("trimRight".equals(methodName)) {
                    return StringTrimRight3Method.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && java.util.Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod2.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod3.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod3.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod3.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod3.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod3.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod3.class;
                }
            } else if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod2.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
            } else if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod2.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod3.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod3.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod3.class;
                }
            } else if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
            } else if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
            } else if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, "BOOL", true);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", false);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Short.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), SqlXmlColumnMapping.class, JDBCType.SQLXML, "SQLXML", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMPTZ", false);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIMETZ", false);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMPTZ", false);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMPTZ", true);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIMETZ", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMPTZ", true);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(java.util.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(java.util.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIMETZ", false);
        this.registerColumnMapping(java.util.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(UUID.class.getName(), OtherColumnMapping.class, JDBCType.OTHER, "UUID", false);
        this.registerColumnMapping(UUID.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(UUID.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Collection.class.getName(), ArrayColumnMapping.class, JDBCType.ARRAY, "TEXT ARRAY", false);
        this.registerColumnMapping(Collection.class.getName(), ArrayColumnMapping.class, JDBCType.ARRAY, "INT ARRAY", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadColumnMappings(mgr, clr);
    }
}

