/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.store.rdbms.mapping.java.DatastoreIdMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.util.ClassUtils;

public class PersistableIdMapping
extends PersistableMapping {
    public PersistableIdMapping(PersistableMapping pcMapping) {
        this.initialize(pcMapping.storeMgr, pcMapping.type);
        this.table = pcMapping.table;
        this.javaTypeMappings = new JavaTypeMapping[pcMapping.javaTypeMappings.length];
        System.arraycopy(pcMapping.javaTypeMappings, 0, this.javaTypeMappings, 0, this.javaTypeMappings.length);
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] param) {
        Object value = super.getObject(ec, rs, param);
        if (value != null) {
            ApiAdapter api = ec.getApiAdapter();
            return api.getIdForObject(value);
        }
        return null;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] param, Object value) {
        if (value == null) {
            super.setObject(ec, ps, param, null);
            return;
        }
        if (this.cmd == null) {
            this.cmd = ec.getMetaDataManager().getMetaDataForClass(this.getType(), ec.getClassLoaderResolver());
        }
        if (IdentityUtils.isDatastoreIdentity((Object)value)) {
            if (this.getJavaTypeMapping()[0] instanceof DatastoreIdMapping) {
                this.getJavaTypeMapping()[0].setObject(ec, ps, param, value);
            } else {
                Object key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)value);
                if (key instanceof String) {
                    this.getJavaTypeMapping()[0].setString(ec, ps, param, (String)key);
                } else {
                    this.getJavaTypeMapping()[0].setObject(ec, ps, param, key);
                }
            }
        } else if (IdentityUtils.isSingleFieldIdentity((Object)value)) {
            Object key = IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)value);
            if (key instanceof String) {
                this.getJavaTypeMapping()[0].setString(ec, ps, param, (String)key);
            } else {
                this.getJavaTypeMapping()[0].setObject(ec, ps, param, key);
            }
        } else {
            String[] pkMemberNames = this.cmd.getPrimaryKeyMemberNames();
            for (int i = 0; i < pkMemberNames.length; ++i) {
                Object pkMemberValue = ClassUtils.getValueForIdentityField((Object)value, (String)pkMemberNames[i]);
                if (pkMemberValue instanceof Byte) {
                    this.getColumnMapping(i).setByte(ps, param[i], (Byte)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Character) {
                    this.getColumnMapping(i).setChar(ps, param[i], ((Character)pkMemberValue).charValue());
                    continue;
                }
                if (pkMemberValue instanceof Integer) {
                    this.getColumnMapping(i).setInt(ps, param[i], (Integer)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Long) {
                    this.getColumnMapping(i).setLong(ps, param[i], (Long)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Short) {
                    this.getColumnMapping(i).setShort(ps, param[i], (Short)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof String) {
                    this.getColumnMapping(i).setString(ps, param[i], (String)pkMemberValue);
                    continue;
                }
                this.getColumnMapping(i).setObject(ps, param[i], pkMemberValue);
            }
        }
    }
}

