/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NotYetFlushedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.AppIdObjectIdFieldConsumer;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.rdbms.mapping.AppIDObjectIdFieldManager;
import org.datanucleus.store.rdbms.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.MultiMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.ElementContainerHandler;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.scostore.PersistableRelationStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PersistableMapping
extends MultiMapping
implements MappingCallbacks {
    protected AbstractClassMetaData cmd;

    @Override
    public Class getJavaType() {
        return null;
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        super.initialize(mmd, table, clr);
        this.prepareColumnMapping(clr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prepareColumnMapping(ClassLoaderResolver clr) {
        if (this.roleForMember == FieldRole.ROLE_COLLECTION_ELEMENT || this.roleForMember == FieldRole.ROLE_ARRAY_ELEMENT || this.roleForMember == FieldRole.ROLE_MAP_KEY || this.roleForMember == FieldRole.ROLE_MAP_VALUE) return;
        AbstractClassMetaData refCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(this.mmd.getType(), clr);
        JavaTypeMapping referenceMapping = null;
        if (refCmd == null) {
            throw new NucleusUserException("You have a field " + this.mmd.getFullFieldName() + " that has type " + this.mmd.getTypeName() + " but this type has no known metadata. Your mapping is incorrect");
        }
        if (refCmd.getInheritanceMetaData() != null && refCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = this.storeMgr.getClassesManagingTableForClass(refCmd, clr);
            if (cmds == null || cmds.length <= 0) return;
            if (cmds.length > 1) {
                NucleusLogger.PERSISTENCE.warn((Object)("Field " + this.mmd.getFullFieldName() + " represents either a 1-1 relation, or a N-1 relation where the other end uses \"subclass-table\" inheritance strategy and more than 1 subclasses with a table. This is not fully supported"));
            }
            referenceMapping = this.storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIdMapping();
        } else if (refCmd.getInheritanceMetaData() != null && refCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
            DatastoreClass refTable = null;
            if (refCmd instanceof ClassMetaData && !((ClassMetaData)refCmd).isAbstract()) {
                refTable = this.storeMgr.getDatastoreClass(refCmd.getFullClassName(), clr);
            } else {
                Collection refSubclasses = this.storeMgr.getSubClassesForClass(refCmd.getFullClassName(), true, clr);
                if (refSubclasses != null && !refSubclasses.isEmpty()) {
                    String refSubclassName = (String)refSubclasses.iterator().next();
                    refTable = this.storeMgr.getDatastoreClass(refSubclassName, clr);
                    if (refSubclasses.size() > 1) {
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)("Field " + this.mmd.getFullFieldName() + " is a 1-1/N-1 relation and the other side had multiple possible classes to which to create a foreign-key. Using first possible (" + refSubclassName + ")"));
                    }
                }
            }
            if (refTable == null) throw new NucleusUserException("Field " + this.mmd.getFullFieldName() + " represents either a 1-1 relation, or a N-1 relation where the other end uses \"complete-table\" inheritance strategy and either no table was found, or multiple possible tables!");
            referenceMapping = refTable.getIdMapping();
        } else {
            referenceMapping = this.storeMgr.getDatastoreClass(this.mmd.getType().getName(), clr).getIdMapping();
        }
        CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper((ColumnMetaDataContainer)this.mmd, this.table, referenceMapping, true);
        RelationType relationType = this.mmd.getRelationType(clr);
        boolean createColumnMappings = true;
        if (relationType == RelationType.MANY_TO_ONE_BI) {
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
            createColumnMappings = relatedMmds[0].getJoinMetaData() == null;
        } else if (relationType == RelationType.ONE_TO_ONE_BI) {
            boolean bl = createColumnMappings = this.mmd.getMappedBy() == null;
        }
        if (this.mmd.getJoinMetaData() != null && (relationType == RelationType.MANY_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI)) {
            if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI) {
                throw new NucleusUserException("We do not currently support 1-1 relations via join table : " + this.mmd.getFullFieldName());
            }
            this.storeMgr.newJoinTable(this.table, this.mmd, clr);
            return;
        } else {
            for (int i = 0; i < referenceMapping.getNumberOfColumnMappings(); ++i) {
                ColumnMapping refColumnMapping = referenceMapping.getColumnMapping(i);
                JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(refColumnMapping.getJavaTypeMapping().getJavaType());
                this.addJavaTypeMapping(mapping);
                if (createColumnMappings) {
                    ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refColumnMapping.getColumn().getIdentifier());
                    if (colmd == null) {
                        throw new NucleusUserException(Localiser.msg((String)"041038", (Object[])new Object[]{refColumnMapping.getColumn().getIdentifier(), this.toString()})).setFatal();
                    }
                    MappingManager mmgr = this.storeMgr.getMappingManager();
                    Column col = mmgr.createColumn(this.mmd, this.table, mapping, colmd, refColumnMapping.getColumn(), clr);
                    ColumnMapping colMapping = mmgr.createColumnMapping(mapping, col, refColumnMapping.getJavaTypeMapping().getJavaTypeForColumnMapping(i));
                    this.addColumnMapping(colMapping);
                    continue;
                }
                mapping.setReferenceMapping(referenceMapping);
            }
        }
    }

    @Override
    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        ExecutionContext ec = nucleusCtx.getApiAdapter().getExecutionContext(value);
        if (this.cmd == null) {
            this.cmd = nucleusCtx.getMetaDataManager().getMetaDataForClass(this.getType(), ec != null ? ec.getClassLoaderResolver() : nucleusCtx.getClassLoaderResolver(null));
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.cmd.getPKMemberPositions()[index]);
            ObjectProvider op = null;
            if (ec != null) {
                op = ec.findObjectProvider(value);
            }
            if (op == null) {
                if (mmd instanceof FieldMetaData) {
                    return ClassUtils.getValueOfFieldByReflection((Object)value, (String)mmd.getName());
                }
                return ClassUtils.getValueOfMethodByReflection((Object)value, (String)ClassUtils.getJavaBeanGetterName((String)mmd.getName(), (boolean)false), (Object[])new Object[0]);
            }
            if (!mmd.isPrimaryKey()) {
                op.isLoaded(mmd.getAbsoluteFieldNumber());
            }
            SingleValueFieldManager fm = new SingleValueFieldManager();
            op.provideFields(new int[]{mmd.getAbsoluteFieldNumber()}, (FieldManager)fm);
            return fm.fetchObjectField(mmd.getAbsoluteFieldNumber());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            Object id = nucleusCtx.getApiAdapter().getIdForObject(value);
            return id != null ? IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id) : null;
        }
        return null;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] param, Object value) {
        this.setObject(ec, ps, param, value, null, -1);
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] param, Object value, ObjectProvider ownerOP, int ownerFieldNumber) {
        if (value == null) {
            this.setObjectAsNull(ec, ps, param);
        } else {
            this.setObjectAsValue(ec, ps, param, value, ownerOP, ownerFieldNumber);
        }
    }

    private void setObjectAsNull(ExecutionContext ec, PreparedStatement ps, int[] param) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (mapping.getNumberOfColumnMappings() <= 0) continue;
            int[] posMapping = new int[mapping.getNumberOfColumnMappings()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            mapping.setObject(ec, ps, posMapping, null);
        }
    }

    private boolean hasDatastoreAttributedPrimaryKeyValues(MetaDataManager mdm, StoreManager srm, ClassLoaderResolver clr) {
        AbstractClassMetaData acmd;
        boolean hasDatastoreAttributedPrimaryKeyValues = false;
        if (this.mmd != null && this.roleForMember != FieldRole.ROLE_ARRAY_ELEMENT && this.roleForMember != FieldRole.ROLE_COLLECTION_ELEMENT && this.roleForMember != FieldRole.ROLE_MAP_KEY && this.roleForMember != FieldRole.ROLE_MAP_VALUE && (acmd = mdm.getMetaDataForClass(this.mmd.getType(), clr)).getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < acmd.getPKMemberPositions().length; ++i) {
                ValueGenerationStrategy strategy = acmd.getMetaDataForManagedMemberAtAbsolutePosition(acmd.getPKMemberPositions()[i]).getValueStrategy();
                if (strategy == null) continue;
                hasDatastoreAttributedPrimaryKeyValues |= srm.isValueGenerationStrategyDatastoreAttributed(acmd, acmd.getPKMemberPositions()[i]);
            }
        }
        return hasDatastoreAttributedPrimaryKeyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectAsValue(ExecutionContext ec, PreparedStatement ps, int[] param, Object value, ObjectProvider ownerOP, int ownerFieldNumber) {
        block57: {
            ApiAdapter api = ec.getApiAdapter();
            if (!api.isPersistable(value)) {
                throw new NucleusException(Localiser.msg((String)"041016", (Object[])new Object[]{value.getClass(), value})).setFatal();
            }
            ObjectProvider valueOP = ec.findObjectProvider(value);
            try {
                ClassLoaderResolver clr = ec.getClassLoaderResolver();
                boolean hasDatastoreAttributedPrimaryKeyValues = this.hasDatastoreAttributedPrimaryKeyValues(ec.getMetaDataManager(), (StoreManager)this.storeMgr, clr);
                boolean inserted = false;
                if (ownerFieldNumber >= 0) {
                    inserted = this.storeMgr.isObjectInserted(valueOP, ownerFieldNumber);
                } else if (this.mmd == null) {
                    inserted = this.storeMgr.isObjectInserted(valueOP, this.type);
                }
                if (valueOP != null) {
                    if (ec.getApiAdapter().isDetached(value) && valueOP.getReferencedPC() != null && ownerOP != null && this.mmd != null) {
                        ownerOP.replaceFieldMakeDirty(ownerFieldNumber, valueOP.getReferencedPC());
                    }
                    if (valueOP.isWaitingToBeFlushedToDatastore()) {
                        try {
                            valueOP.flush();
                        }
                        catch (NotYetFlushedException nfe) {
                            if (ownerOP != null) {
                                ownerOP.updateFieldAfterInsert(value, ownerFieldNumber);
                            }
                            this.setObjectAsNull(ec, ps, param);
                            if (valueOP != null) {
                                valueOP.unsetStoringPC();
                            }
                            return;
                        }
                    }
                } else if (ec.getApiAdapter().isDetached(value)) {
                    Object attachedValue = ec.persistObjectInternal(value, null, -1, 0);
                    if (attachedValue != value && ownerOP != null) {
                        ownerOP.replaceFieldMakeDirty(ownerFieldNumber, attachedValue);
                        value = attachedValue;
                    }
                    valueOP = ec.findObjectProvider(value);
                }
                if (inserted || !ec.isInserting(value) || !hasDatastoreAttributedPrimaryKeyValues && this.mmd != null && this.mmd.isPrimaryKey() || !hasDatastoreAttributedPrimaryKeyValues && ownerOP == valueOP && api.getIdForObject(value) != null) {
                    Object id = api.getIdForObject(value);
                    boolean requiresPersisting = false;
                    if (ec.getApiAdapter().isDetached(value) && ownerOP != null) {
                        if (ownerOP.isInserting()) {
                            if (!ec.getBooleanProperty("datanucleus.attachSameDatastore").booleanValue() && ec.getObjectFromCache(api.getIdForObject(value)) == null) {
                                try {
                                    Object obj = ec.findObject(api.getIdForObject(value), true, false, value.getClass().getName());
                                    if (obj != null) {
                                        ObjectProvider objOP = ec.findObjectProvider(obj);
                                        if (objOP != null) {
                                            ec.evictFromTransaction(objOP);
                                        }
                                        ec.removeObjectFromLevel1Cache(api.getIdForObject(value));
                                    }
                                }
                                catch (NucleusObjectNotFoundException onfe) {
                                    requiresPersisting = true;
                                }
                            }
                        } else {
                            requiresPersisting = true;
                        }
                    } else if (id == null) {
                        requiresPersisting = true;
                    } else {
                        ExecutionContext pcEC = ec.getApiAdapter().getExecutionContext(value);
                        if (pcEC != null && ec != pcEC) {
                            throw new NucleusUserException(Localiser.msg((String)"041015"), id);
                        }
                    }
                    if (requiresPersisting) {
                        if (this.mmd != null && !this.mmd.isCascadePersist() && !ec.getApiAdapter().isDetached(value)) {
                            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{this.mmd.getFullFieldName()}));
                            }
                            throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), value);
                        }
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007007", (Object[])new Object[]{this.mmd != null ? this.mmd.getFullFieldName() : null}));
                        }
                        try {
                            Object pcNew = ec.persistObjectInternal(value, null, -1, 0);
                            if (hasDatastoreAttributedPrimaryKeyValues) {
                                ec.flushInternal(false);
                            }
                            id = api.getIdForObject(pcNew);
                            if (ec.getApiAdapter().isDetached(value) && ownerOP != null && this.mmd != null) {
                                ownerOP.replaceFieldMakeDirty(ownerFieldNumber, pcNew);
                                RelationType relationType = this.mmd.getRelationType(clr);
                                if (relationType == RelationType.MANY_TO_ONE_BI) {
                                    if (NucleusLogger.PERSISTENCE.isInfoEnabled()) {
                                        NucleusLogger.PERSISTENCE.info((Object)("PCMapping.setObject : object " + ownerOP.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional. Have just attached the N side so should really update the reference in the 1 side collection to refer to this attached object. Not yet implemented"));
                                    }
                                } else if (relationType == RelationType.ONE_TO_ONE_BI) {
                                    AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                                    ObjectProvider relatedOP = ec.findObjectProvider(pcNew);
                                    relatedOP.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), ownerOP.getObject());
                                }
                            }
                        }
                        catch (NotYetFlushedException e) {
                            this.setObjectAsNull(ec, ps, param);
                            throw new NotYetFlushedException(value);
                        }
                    }
                    if (valueOP != null) {
                        valueOP.setStoringPC();
                    }
                    if (this.getNumberOfColumnMappings() > 0) {
                        if (IdentityUtils.isDatastoreIdentity((Object)id)) {
                            Object idKey = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id);
                            try {
                                this.getColumnMapping(0).setObject(ps, param[0], idKey);
                            }
                            catch (Exception e) {
                                this.getColumnMapping(0).setObject(ps, param[0], idKey.toString());
                            }
                        } else {
                            boolean fieldsSet = false;
                            if (IdentityUtils.isSingleFieldIdentity((Object)id) && this.javaTypeMappings.length > 1) {
                                Object key = IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)id);
                                AbstractClassMetaData keyCmd = ec.getMetaDataManager().getMetaDataForClass(key.getClass(), clr);
                                if (keyCmd != null && keyCmd.getIdentityType() == IdentityType.NONDURABLE) {
                                    ObjectProvider keyOP = ec.findObjectProvider(key);
                                    int[] fieldNums = keyCmd.getAllMemberPositions();
                                    AppIDObjectIdFieldManager fm = new AppIDObjectIdFieldManager(param, ec, ps, this.javaTypeMappings);
                                    for (int i = 0; i < fieldNums.length; ++i) {
                                        keyOP.provideFields(new int[]{fieldNums[i]}, (FieldManager)fm);
                                    }
                                    fieldsSet = true;
                                }
                            }
                            if (!fieldsSet) {
                                AppIDObjectIdFieldManager fm = new AppIDObjectIdFieldManager(param, ec, ps, this.javaTypeMappings);
                                api.copyKeyFieldsFromIdToObject(value, (Persistable.ObjectIdFieldConsumer)new AppIdObjectIdFieldConsumer(api, (FieldManager)fm), id);
                            }
                        }
                    }
                    break block57;
                }
                if (valueOP != null) {
                    valueOP.setStoringPC();
                }
                if (this.getNumberOfColumnMappings() > 0) {
                    this.setObjectAsNull(ec, ps, param);
                    throw new NotYetFlushedException(value);
                }
            }
            finally {
                if (valueOP != null) {
                    valueOP.unsetStoringPC();
                }
            }
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] resultIndexes) {
        VersionMetaData vermd;
        if (this.storeMgr.getResultValueAtPosition(rs, this, resultIndexes[0]) == null) {
            return null;
        }
        if (this.cmd == null) {
            this.cmd = ec.getMetaDataManager().getMetaDataForClass(this.getType(), ec.getClassLoaderResolver());
        }
        Object pc = null;
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            pc = MappingHelper.getObjectForDatastoreIdentity(ec, this, rs, resultIndexes, this.cmd);
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            pc = MappingHelper.getObjectForApplicationIdentity(ec, this, rs, resultIndexes, this.cmd);
        } else {
            return null;
        }
        ObjectProvider pcOP = ec.findObjectProvider(pc);
        if (pcOP != null && (vermd = this.cmd.getVersionMetaDataForTable()) != null && vermd.getVersionStrategy() != VersionStrategy.NONE && ec.getTransaction().getOptimistic() && !pcOP.isVersionLoaded()) {
            pcOP.loadUnloadedFieldsInFetchPlan();
        }
        return pc;
    }

    @Override
    public void postFetch(ObjectProvider op) {
    }

    @Override
    public void insertPostProcessing(ObjectProvider op) {
    }

    @Override
    public void postInsert(ObjectProvider op) {
        Object pc = op.provideField(this.mmd.getAbsoluteFieldNumber());
        TypeManager typeManager = op.getExecutionContext().getTypeManager();
        Object object = pc = this.mmd.isSingleCollection() ? SCOUtils.singleCollectionValue((TypeManager)typeManager, (Object)pc) : pc;
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        RelationType relationType = this.mmd.getRelationType(clr);
        if (relationType == RelationType.ONE_TO_ONE_BI) {
            ObjectProvider otherOP = op.getExecutionContext().findObjectProvider(pc);
            if (otherOP == null) {
                return;
            }
            AbstractMemberMetaData relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, op.getObject(), pc);
            if (relatedMmd == null) {
                throw new NucleusUserException("You have a field " + this.mmd.getFullFieldName() + " that is 1-1 bidir yet cannot find the equivalent field at the other side. Why is that?");
            }
            Object relatedValue = otherOP.provideField(relatedMmd.getAbsoluteFieldNumber());
            Object object2 = relatedValue = relatedMmd.isSingleCollection() ? SCOUtils.singleCollectionValue((TypeManager)typeManager, (Object)relatedValue) : relatedValue;
            if (relatedValue == null) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"041018", (Object[])new Object[]{op.getObjectAsPrintable(), this.mmd.getFullFieldName(), StringUtils.toJVMIDString((Object)pc), relatedMmd.getFullFieldName()}));
                }
                Object replaceValue = op.getObject();
                if (relatedMmd.isSingleCollection()) {
                    ElementContainerHandler containerHandler = (ElementContainerHandler)typeManager.getContainerHandler(relatedMmd.getType());
                    replaceValue = containerHandler.newContainer(relatedMmd, new Object[]{op.getObject()});
                }
                otherOP.replaceField(relatedMmd.getAbsoluteFieldNumber(), replaceValue);
            } else if (relatedValue != op.getObject()) {
                throw new NucleusUserException(Localiser.msg((String)"041020", (Object[])new Object[]{op.getObjectAsPrintable(), this.mmd.getFullFieldName(), StringUtils.toJVMIDString((Object)pc), StringUtils.toJVMIDString((Object)relatedValue)}));
            }
        } else if (relationType == RelationType.MANY_TO_ONE_BI && relatedMmds[0].hasCollection()) {
            boolean contained;
            Collection relatedColl;
            ObjectProvider otherOP = op.getExecutionContext().findObjectProvider(pc);
            if (otherOP != null && (relatedColl = (Collection)otherOP.provideField(relatedMmds[0].getAbsoluteFieldNumber())) != null && !(relatedColl instanceof SCOCollection) && !(contained = relatedColl.contains(op.getObject()))) {
                NucleusLogger.PERSISTENCE.info((Object)Localiser.msg((String)"041022", (Object[])new Object[]{op.getObjectAsPrintable(), this.mmd.getFullFieldName(), StringUtils.toJVMIDString((Object)pc), relatedMmds[0].getFullFieldName()}));
            }
        } else if (relationType == RelationType.MANY_TO_ONE_UNI) {
            ObjectProvider otherOP = op.getExecutionContext().findObjectProvider(pc);
            if (otherOP == null) {
                Object other = op.getExecutionContext().persistObjectInternal(pc, null, -1, 0);
                otherOP = op.getExecutionContext().findObjectProvider(other);
            }
            PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(clr, this.mmd, this.mmd.getType());
            store.add(op, otherOP);
        }
    }

    @Override
    public void postUpdate(ObjectProvider op) {
        Object pc = op.provideField(this.mmd.getAbsoluteFieldNumber());
        pc = this.mmd.isSingleCollection() ? SCOUtils.singleCollectionValue((TypeManager)this.getStoreManager().getNucleusContext().getTypeManager(), (Object)pc) : pc;
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        RelationType relationType = this.mmd.getRelationType(clr);
        if (pc == null) {
            if (relationType == RelationType.MANY_TO_ONE_UNI) {
                PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(clr, this.mmd, this.mmd.getType());
                store.remove(op);
            }
            return;
        }
        ObjectProvider otherOP = op.getExecutionContext().findObjectProvider(pc);
        if (otherOP == null && (relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_UNI)) {
            Object other = op.getExecutionContext().persistObjectInternal(pc, null, -1, 0);
            otherOP = op.getExecutionContext().findObjectProvider(other);
        }
        if (relationType == RelationType.MANY_TO_ONE_UNI) {
            PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(clr, this.mmd, this.mmd.getType());
            store.update(op, otherOP);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void preDelete(ObjectProvider op) {
        int fieldNumber = this.mmd.getAbsoluteFieldNumber();
        if (!op.isFieldLoaded(fieldNumber)) {
            try {
                op.loadField(fieldNumber);
            }
            catch (NucleusObjectNotFoundException onfe) {
                return;
            }
        }
        Object pc = op.provideField(fieldNumber);
        Object object = pc = this.mmd.isSingleCollection() ? SCOUtils.singleCollectionValue((TypeManager)this.getStoreManager().getNucleusContext().getTypeManager(), (Object)pc) : pc;
        if (pc == null) {
            return;
        }
        ExecutionContext ec = op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = this.mmd.getRelationType(clr);
        if (relationType == RelationType.MANY_TO_ONE_UNI) {
            PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(clr, this.mmd, this.mmd.getType());
            store.remove(op);
        }
        boolean dependent = this.mmd.isDependent();
        if (this.mmd.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        boolean hasFK = false;
        if (!dependent) {
            if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (RelationType.isBidirectional((RelationType)relationType) && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (ec.getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
                hasFK = false;
            }
        }
        if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI && this.mmd.getMappedBy() == null) {
            if (dependent) {
                boolean relatedObjectDeleted = ec.getApiAdapter().isDeleted(pc);
                if (this.isNullable() && !relatedObjectDeleted) {
                    op.replaceFieldMakeDirty(fieldNumber, null);
                    this.storeMgr.getPersistenceHandler().updateObject(op, new int[]{fieldNumber});
                    if (relatedObjectDeleted) return;
                    ec.deleteObjectInternal(pc);
                    return;
                }
                if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) return;
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"041017", (Object[])new Object[]{StringUtils.toJVMIDString((Object)op.getObject()), this.mmd.getFullFieldName()}));
                return;
            }
            AbstractMemberMetaData relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, op.getObject(), pc);
            if (relatedMmd == null) return;
            ObjectProvider otherOP = ec.findObjectProvider(pc);
            if (otherOP == null) return;
            Object currentValue = otherOP.provideField(relatedMmd.getAbsoluteFieldNumber());
            if (currentValue == null) return;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"041019", (Object[])new Object[]{StringUtils.toJVMIDString((Object)pc), relatedMmd.getFullFieldName(), op.getObjectAsPrintable()}));
            }
            otherOP.replaceFieldMakeDirty(relatedMmd.getAbsoluteFieldNumber(), null);
            if (!ec.getManageRelations()) return;
            otherOP.getExecutionContext().getRelationshipManager(otherOP).relationChange(relatedMmd.getAbsoluteFieldNumber(), op.getObject(), null);
            return;
        }
        if (relationType == RelationType.ONE_TO_ONE_BI && this.mmd.getMappedBy() != null) {
            DatastoreClass relatedTable = this.storeMgr.getDatastoreClass(relatedMmds[0].getClassName(), clr);
            JavaTypeMapping relatedMapping = relatedTable.getMemberMapping(relatedMmds[0]);
            boolean isNullable = relatedMapping.isNullable();
            ObjectProvider otherOP = ec.findObjectProvider(pc);
            if (!dependent) {
                if (hasFK) return;
                if (!this.isNullable()) return;
                Object currentRelatedValue = otherOP.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (currentRelatedValue == null) return;
                otherOP.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), null);
                this.storeMgr.getPersistenceHandler().updateObject(otherOP, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
                if (!ec.getManageRelations()) return;
                otherOP.getExecutionContext().getRelationshipManager(otherOP).relationChange(relatedMmds[0].getAbsoluteFieldNumber(), op.getObject(), null);
                return;
            }
            if (isNullable) {
                otherOP.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), null);
                this.storeMgr.getPersistenceHandler().updateObject(otherOP, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
            }
            ec.deleteObjectInternal(pc);
            return;
        }
        if (relationType == RelationType.MANY_TO_ONE_BI) {
            ObjectProvider otherOP = ec.findObjectProvider(pc);
            if (relatedMmds[0].getJoinMetaData() == null) {
                if (otherOP.isDeleting()) {
                    return;
                }
                if (dependent) {
                    if (this.isNullable()) {
                        op.replaceFieldMakeDirty(fieldNumber, null);
                        this.storeMgr.getPersistenceHandler().updateObject(op, new int[]{fieldNumber});
                    }
                    if (ec.getApiAdapter().isDeleted(pc)) {
                        return;
                    }
                    ec.deleteObjectInternal(pc);
                    return;
                }
                if (!relatedMmds[0].hasCollection()) {
                    if (!relatedMmds[0].hasMap()) return;
                    return;
                }
                if (ec.getApiAdapter().isDeleted(otherOP.getObject())) return;
                if (otherOP.isDeleting()) return;
                ec.markDirty(otherOP, false);
                otherOP.isLoaded(relatedMmds[0].getAbsoluteFieldNumber());
                Collection otherColl = (Collection)otherOP.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (otherColl == null) return;
                if (ec.getManageRelations()) {
                    otherOP.getExecutionContext().getRelationshipManager(otherOP).relationRemove(relatedMmds[0].getAbsoluteFieldNumber(), op.getObject());
                }
                NucleusLogger.PERSISTENCE.debug((Object)("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName()));
                otherColl.remove(op.getObject());
                return;
            }
            if (dependent) {
                ec.deleteObjectInternal(pc);
                return;
            }
            if (relatedMmds[0].hasCollection()) {
                if (ec.getApiAdapter().isDeleted(otherOP.getObject())) return;
                if (otherOP.isDeleting()) return;
                ec.markDirty(otherOP, false);
                otherOP.isLoaded(relatedMmds[0].getAbsoluteFieldNumber());
                Collection otherColl = (Collection)otherOP.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (otherColl == null) return;
                NucleusLogger.PERSISTENCE.debug((Object)("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName()));
                otherColl.remove(op.getObject());
                return;
            }
            if (!relatedMmds[0].hasMap()) return;
            return;
        } else {
            if (relationType != RelationType.MANY_TO_ONE_UNI) return;
            if (!dependent) return;
            ec.deleteObjectInternal(pc);
        }
    }
}

