/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.column.OracleBlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.OracleClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.StringMapping;

public class OracleStringLobMapping
extends StringMapping
implements MappingCallbacks {
    @Override
    public void insertPostProcessing(ObjectProvider op) {
        String value = (String)op.provideField(this.mmd.getAbsoluteFieldNumber());
        op.isLoaded(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            value = "";
        } else if (value.length() == 0) {
            value = this.storeMgr.getBooleanProperty("datanucleus.rdbms.persistEmptyStringAsNull") ? "" : this.storeMgr.getDatastoreAdapter().getSurrogateForEmptyStrings();
        }
        if (this.mmd.getColumnMetaData()[0].getJdbcType() == JdbcType.BLOB) {
            OracleBlobColumnMapping.updateBlobColumn(op, this.getTable(), this.getColumnMapping(0), value.getBytes());
        } else if (this.mmd.getColumnMetaData()[0].getJdbcType() == JdbcType.CLOB) {
            OracleClobColumnMapping.updateClobColumn(op, this.getTable(), this.getColumnMapping(0), value);
        } else {
            throw new NucleusException("AssertionError: Only JDBC types BLOB and CLOB are allowed!");
        }
    }

    @Override
    public void postInsert(ObjectProvider op) {
    }

    @Override
    public void postFetch(ObjectProvider op) {
    }

    @Override
    public void postUpdate(ObjectProvider op) {
        this.insertPostProcessing(op);
    }

    @Override
    public void preDelete(ObjectProvider op) {
    }
}

