/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.InformixTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.FloatColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TinyIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.operation.Mod2Operation;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class InformixAdapter
extends BaseDatastoreAdapter {
    public InformixAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("ProjectionInTableReferenceJoins");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
        this.supportedOptions.remove("IdentityNullSpecification");
        this.supportedOptions.remove("IdentityColumnTypeSpecification");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("DeferredConstraints");
    }

    @Override
    public void initialiseDatastore(Connection conn) {
        try {
            Statement st = conn.createStatement();
            try {
                st.execute(this.getSTRPOSDropFunction());
            }
            catch (SQLException e) {
                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"051027", (Object[])new Object[]{e}));
            }
            try {
                st.execute(this.getSTRPOSFunction());
            }
            catch (SQLException e) {
                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"051027", (Object[])new Object[]{e}));
            }
            st.close();
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)"Exception when trying to initialise datastore", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getVendorID() {
        return "informix";
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new InformixTypeInfo(rs);
    }

    @Override
    public String getIdentifierQuoteString() {
        return "";
    }

    @Override
    public String getIdentityLastValueStmt(Table table, String columnName) {
        String useSerial = (String)this.getValueForProperty("datanucleus.rdbms.informix.useSerialForIdentity");
        if (useSerial != null && useSerial.equalsIgnoreCase("true")) {
            return "SELECT first 1 dbinfo('sqlca.sqlerrd1') from systables";
        }
        return "SELECT first 1 dbinfo('serial8') from systables";
    }

    @Override
    public String getIdentityKeyword() {
        String useSerial = (String)this.getValueForProperty("datanucleus.rdbms.informix.useSerialForIdentity");
        if (useSerial != null && useSerial.equalsIgnoreCase("true")) {
            return "SERIAL";
        }
        return "SERIAL8";
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        if (fk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(fk.getName());
            return "ALTER TABLE " + fk.getTable().toString() + " ADD CONSTRAINT" + ' ' + fk + ' ' + "CONSTRAINT" + ' ' + identifier;
        }
        return "ALTER TABLE " + fk.getTable().toString() + " ADD " + fk;
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        if (ck.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(ck.getName());
            return "ALTER TABLE " + ck.getTable().toString() + " ADD CONSTRAINT " + ck + " CONSTRAINT " + identifier;
        }
        return "ALTER TABLE " + ck.getTable().toString() + " ADD CONSTRAINT " + ck;
    }

    @Override
    public String getDatastoreDateStatement() {
        return "SELECT FIRST 1 (CURRENT) FROM SYSTABLES";
    }

    private String getSTRPOSFunction() {
        return "create function NUCLEUS_STRPOS(str char(40),search char(40),from smallint) returning smallint\ndefine i,pos,lenstr,lensearch smallint;\nlet lensearch = length(search);\nlet lenstr = length(str);\nif lenstr=0 or lensearch=0 then return 0; end if;\nlet pos=-1;\nfor i=1+from to lenstr\nif substr(str,i,lensearch)=search then\nlet pos=i;\nexit for;\nend if;\nend for;\nreturn pos;\nend function;";
    }

    private String getSTRPOSDropFunction() {
        return "drop function NUCLEUS_STRPOS;";
    }

    @Override
    public boolean isStatementTimeout(SQLException sqle) {
        if (sqle.getErrorCode() == -213) {
            return true;
        }
        return super.isStatementTimeout(sqle);
    }

    @Override
    public Class getSQLOperationClass(String operationName) {
        if ("mod".equals(operationName)) {
            return Mod2Operation.class;
        }
        return super.getSQLOperationClass(operationName);
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className != null && "java.lang.String".equals(className) && "substring".equals(methodName)) {
            return StringSubstring3Method.class;
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, "BIT", true);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Double.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Float.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Short.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(java.util.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(java.util.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadColumnMappings(mgr, clr);
    }
}

