/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import oracle.sql.BLOB;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobImpl;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ColumnMappingPostInsert;
import org.datanucleus.store.rdbms.mapping.column.ColumnMappingPostUpdate;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class OracleBlobColumnMapping
extends AbstractColumnMapping
implements ColumnMappingPostInsert,
ColumnMappingPostUpdate {
    public OracleBlobColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    protected OracleBlobColumnMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    private void initialize() {
        this.initTypeInfo();
    }

    @Override
    public String getInsertionInputParameter() {
        return "EMPTY_BLOB()";
    }

    @Override
    public boolean insertValuesOnInsert() {
        return false;
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Object obj;
        block46: {
            obj = null;
            try {
                Blob blob = rs.getBlob(param);
                if (rs.wasNull()) break block46;
                byte[] bytes = blob.getBytes(1L, (int)blob.length());
                if (bytes.length < 1) {
                    return null;
                }
                try {
                    if (this.getJavaTypeMapping().isSerialised()) {
                        BlobImpl b = new BlobImpl(bytes);
                        obj = b.getObject();
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BOOLEAN_ARRAY)) {
                        obj = TypeConversionHelper.getBooleanArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BYTE_ARRAY)) {
                        obj = bytes;
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.CHAR_ARRAY)) {
                        obj = TypeConversionHelper.getCharArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_STRING)) {
                        obj = new String(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.DOUBLE_ARRAY)) {
                        obj = TypeConversionHelper.getDoubleArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.FLOAT_ARRAY)) {
                        obj = TypeConversionHelper.getFloatArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.INT_ARRAY)) {
                        obj = TypeConversionHelper.getIntArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.LONG_ARRAY)) {
                        obj = TypeConversionHelper.getLongArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.SHORT_ARRAY)) {
                        obj = TypeConversionHelper.getShortArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BOOLEAN_ARRAY)) {
                        obj = TypeConversionHelper.getBooleanObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BYTE_ARRAY)) {
                        obj = TypeConversionHelper.getByteObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY)) {
                        obj = TypeConversionHelper.getCharObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_DOUBLE_ARRAY)) {
                        obj = TypeConversionHelper.getDoubleObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_FLOAT_ARRAY)) {
                        obj = TypeConversionHelper.getFloatObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_INTEGER_ARRAY)) {
                        obj = TypeConversionHelper.getIntObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_LONG_ARRAY)) {
                        obj = TypeConversionHelper.getLongObjectArrayFromByteArray((byte[])bytes);
                    } else if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_SHORT_ARRAY)) {
                        obj = TypeConversionHelper.getShortObjectArrayFromByteArray((byte[])bytes);
                    } else {
                        if (this.getJavaTypeMapping().getType().equals(BigDecimal[].class.getName())) {
                            return TypeConversionHelper.getBigDecimalArrayFromByteArray((byte[])bytes);
                        }
                        if (this.getJavaTypeMapping().getType().equals(BigInteger[].class.getName())) {
                            return TypeConversionHelper.getBigIntegerArrayFromByteArray((byte[])bytes);
                        }
                        if (this.getJavaTypeMapping().getType().equals(BitSet.class.getName())) {
                            return TypeConversionHelper.getBitSetFromBooleanArray((boolean[])TypeConversionHelper.getBooleanArrayFromByteArray((byte[])bytes));
                        }
                        obj = new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
                    }
                }
                catch (StreamCorruptedException e) {
                    String msg = "StreamCorruptedException: object is corrupted";
                    NucleusLogger.DATASTORE.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)e).setFatal();
                }
                catch (IOException e) {
                    String msg = "IOException: error when reading object";
                    NucleusLogger.DATASTORE.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)e).setFatal();
                }
                catch (ClassNotFoundException e) {
                    String msg = "ClassNotFoundException: error when creating object";
                    NucleusLogger.DATASTORE.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)e).setFatal();
                }
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, sqle.getMessage()}), (Throwable)sqle);
            }
        }
        return obj;
    }

    @Override
    public String getString(ResultSet resultSet, int exprIndex) {
        return (String)this.getObject(resultSet, exprIndex);
    }

    @Override
    public int getJDBCType() {
        return 2004;
    }

    @Override
    public String getUpdateInputParameter() {
        return "EMPTY_BLOB()";
    }

    public boolean includeInSQLFetchStatement() {
        return true;
    }

    @Override
    public void updatePostProcessing(ObjectProvider op, Object value) {
        OracleBlobColumnMapping.updateBlobColumn(op, this.getJavaTypeMapping().getTable(), this, (byte[])value);
    }

    @Override
    public void insertPostProcessing(ObjectProvider op, Object value) {
        OracleBlobColumnMapping.updateBlobColumn(op, this.getJavaTypeMapping().getTable(), this, (byte[])value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBlobColumn(ObjectProvider op, Table table, ColumnMapping mapping, byte[] bytes) {
        block33: {
            ExecutionContext ec = op.getExecutionContext();
            RDBMSStoreManager storeMgr = table.getStoreManager();
            if (table instanceof DatastoreClass) {
                ObjectProvider[] embeddedOwners;
                DatastoreClass classTable = (DatastoreClass)table;
                SelectStatement sqlStmt = new SelectStatement(storeMgr, table, null, null);
                sqlStmt.setClassLoaderResolver(ec.getClassLoaderResolver());
                sqlStmt.addExtension("lock-for-update", true);
                SQLTable blobSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), mapping.getJavaTypeMapping());
                sqlStmt.select(blobSqlTbl, mapping.getColumn(), null);
                StatementClassMapping mappingDefinition = new StatementClassMapping();
                AbstractClassMetaData cmd = op.getClassMetaData();
                SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
                int inputParamNum = 1;
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    JavaTypeMapping datastoreIdMapping = classTable.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false);
                    SQLExpression expr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), datastoreIdMapping);
                    SQLExpression val = exprFactory.newLiteralParameter(sqlStmt, datastoreIdMapping, null, "ID");
                    sqlStmt.whereAnd(expr.eq(val), true);
                    StatementMappingIndex datastoreIdx = mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
                    if (datastoreIdx == null) {
                        datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                        mappingDefinition.addMappingForMember(SurrogateColumnType.DATASTORE_ID.getFieldNumber(), datastoreIdx);
                    }
                    datastoreIdx.addParameterOccurrence(new int[]{inputParamNum});
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkNums = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkNums.length; ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                        JavaTypeMapping pkMapping = classTable.getMemberMapping(mmd);
                        SQLExpression expr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), pkMapping);
                        SQLExpression val = exprFactory.newLiteralParameter(sqlStmt, pkMapping, null, "PK" + i);
                        sqlStmt.whereAnd(expr.eq(val), true);
                        StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNums[i]);
                        if (pkIdx == null) {
                            pkIdx = new StatementMappingIndex(pkMapping);
                            mappingDefinition.addMappingForMember(pkNums[i], pkIdx);
                        }
                        int[] inputParams = new int[pkMapping.getNumberOfColumnMappings()];
                        for (int j = 0; j < pkMapping.getNumberOfColumnMappings(); ++j) {
                            inputParams[j] = inputParamNum++;
                        }
                        pkIdx.addParameterOccurrence(inputParams);
                    }
                }
                String textStmt = sqlStmt.getSQLText().toSQL();
                if (op.isEmbedded() && (embeddedOwners = ec.getOwnersForEmbeddedObjectProvider(op)) != null) {
                    op = embeddedOwners[0];
                }
                try {
                    ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
                    SQLController sqlControl = storeMgr.getSQLController();
                    try {
                        PreparedStatement ps = sqlControl.getStatementForQuery(mconn, textStmt);
                        try {
                            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                                StatementMappingIndex datastoreIdx = mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
                                for (int i = 0; i < datastoreIdx.getNumberOfParameterOccurrences(); ++i) {
                                    classTable.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false).setObject(ec, ps, datastoreIdx.getParameterPositionsForOccurrence(i), op.getInternalObjectId());
                                }
                            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                                op.provideFields(cmd.getPKMemberPositions(), (FieldManager)new ParameterSetter(op, ps, mappingDefinition));
                            }
                            try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, textStmt, ps);){
                                Blob blob;
                                if (!rs.next()) {
                                    throw new NucleusObjectNotFoundException("No such database row", op.getInternalObjectId());
                                }
                                DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
                                int jdbcMajorVersion = dba.getDriverMajorVersion();
                                if (dba.getDatastoreDriverName().equalsIgnoreCase("Oracle JDBC driver") && jdbcMajorVersion < 10) {
                                    blob = null;
                                    if (jdbcMajorVersion <= 8) {
                                        Method getBlobMethod = ClassUtils.getMethodForClass(rs.getClass(), (String)"getBLOB", (Class[])new Class[]{Integer.TYPE});
                                        try {
                                            blob = (BLOB)getBlobMethod.invoke((Object)rs, 1);
                                        }
                                        catch (Throwable thr) {
                                            throw new NucleusDataStoreException("Error in getting BLOB", thr);
                                        }
                                    } else {
                                        blob = (BLOB)rs.getBlob(1);
                                    }
                                    if (blob != null) {
                                        blob.putBytes(1L, bytes);
                                    }
                                } else {
                                    blob = rs.getBlob(1);
                                    if (blob != null) {
                                        blob.setBytes(1L, bytes);
                                    }
                                }
                                break block33;
                            }
                        }
                        finally {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                    finally {
                        mconn.release();
                    }
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException("Update of BLOB value failed: " + textStmt, (Throwable)e);
                }
            }
            throw new NucleusDataStoreException("We do not support INSERT/UPDATE BLOB post processing of non-primary table " + table);
        }
    }
}

