/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class EnumMapping
extends SingleFieldMapping {
    public static final String EXTENSION_CHECK_CONSTRAINT_ENUM_VALUES = "enum-check-constraint";
    protected String datastoreJavaType = ClassNameConstants.JAVA_LANG_STRING;

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        if (mmd != null && mmd.isSerialized()) {
            this.datastoreJavaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
        } else if (mmd != null && MetaDataUtils.isJdbcTypeNumeric((JdbcType)TypeConversionHelper.getJdbcTypeForEnum((AbstractMemberMetaData)mmd, (FieldRole)this.roleForMember, (ClassLoaderResolver)clr))) {
            this.datastoreJavaType = ClassNameConstants.JAVA_LANG_INTEGER;
        }
        super.initialize(mmd, table, clr);
        if (this.storeMgr.getDatastoreAdapter().supportsOption("NativeEnumType")) {
            // empty if block
        }
    }

    @Override
    public Object[] getValidValues(int index) {
        if (this.mmd != null && this.mmd.hasExtension(EXTENSION_CHECK_CONSTRAINT_ENUM_VALUES) && this.mmd.getValueForExtension(EXTENSION_CHECK_CONSTRAINT_ENUM_VALUES).equals("true")) {
            try {
                Enum[] values = (Enum[])this.mmd.getType().getMethod("values", null).invoke(null, (Object[])null);
                if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
                    Object[] valueStrings = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        valueStrings[i] = (String)TypeConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)this.mmd, (FieldRole)this.roleForMember, (Enum)values[i]);
                    }
                    return valueStrings;
                }
                Object[] valueInts = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Number val = (Number)TypeConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)this.mmd, (FieldRole)this.roleForMember, (Enum)values[i]);
                    valueInts[i] = val.intValue();
                }
                return valueInts;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn((Object)StringUtils.getStringFromStackTrace((Throwable)e));
            }
        }
        return super.getValidValues(index);
    }

    @Override
    public String getJavaTypeForColumnMapping(int index) {
        return this.datastoreJavaType;
    }

    @Override
    public Class getJavaType() {
        return Enum.class;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (value == null) {
            this.getColumnMapping(0).setObject(ps, exprIndex[0], null);
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            int intVal = 0;
            if (value instanceof Enum) {
                intVal = ((Number)TypeConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)this.mmd, (FieldRole)this.roleForMember, (Enum)((Enum)value))).intValue();
            } else if (value instanceof BigInteger) {
                intVal = ((BigInteger)value).intValue();
            }
            this.getColumnMapping(0).setInt(ps, exprIndex[0], intVal);
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = null;
            if (value instanceof Enum) {
                stringVal = (String)TypeConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)this.mmd, (FieldRole)this.roleForMember, (Enum)((Enum)value));
            } else if (value instanceof String) {
                stringVal = (String)value;
            }
            this.getColumnMapping(0).setString(ps, exprIndex[0], stringVal);
        } else {
            super.setObject(ec, ps, exprIndex, value);
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            int intVal = this.getColumnMapping(0).getInt(resultSet, exprIndex[0]);
            Class enumType = null;
            if (this.mmd == null) {
                enumType = ec.getClassLoaderResolver().classForName(this.type);
                return enumType.getEnumConstants()[intVal];
            }
            return TypeConversionHelper.getEnumForStoredValue((AbstractMemberMetaData)this.mmd, (FieldRole)this.roleForMember, (Object)intVal, (ClassLoaderResolver)ec.getClassLoaderResolver());
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = this.getColumnMapping(0).getString(resultSet, exprIndex[0]);
            if (this.mmd == null) {
                Class enumType = ec.getClassLoaderResolver().classForName(this.type);
                return Enum.valueOf(enumType, stringVal);
            }
            return TypeConversionHelper.getEnumForStoredValue((AbstractMemberMetaData)this.mmd, (FieldRole)this.roleForMember, (Object)stringVal, (ClassLoaderResolver)ec.getClassLoaderResolver());
        }
        return super.getObject(ec, resultSet, exprIndex);
    }
}

