/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementParameterMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.FKMapStore;
import org.datanucleus.store.rdbms.scostore.JoinMapStore;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.scostore.SetStore;

class MapEntrySetStore<K, V>
extends BaseContainerStore
implements SetStore<Map.Entry<K, V>> {
    protected Table mapTable;
    protected MapStore<K, V> mapStore;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    private String sizeStmt;
    private SelectStatement iteratorSelectStmt = null;
    private int[] iteratorKeyResultCols = null;
    private int[] iteratorValueResultCols = null;
    private StatementParameterMapping iteratorMappingParams = null;

    MapEntrySetStore(MapTable mapTable, JoinMapStore<K, V> mapStore, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager(), clr);
        this.mapTable = mapTable;
        this.mapStore = mapStore;
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.valueMapping = mapTable.getValueMapping();
        this.ownerMemberMetaData = mapTable.getOwnerMemberMetaData();
    }

    MapEntrySetStore(DatastoreClass mapTable, FKMapStore<K, V> mapStore, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager(), clr);
        this.mapTable = mapTable;
        this.mapStore = mapStore;
        this.ownerMapping = mapStore.getOwnerMapping();
        this.keyMapping = mapStore.getKeyMapping();
        this.valueMapping = mapStore.getValueMapping();
        this.ownerMemberMetaData = mapStore.getOwnerMemberMetaData();
    }

    public boolean hasOrderMapping() {
        return false;
    }

    public MapStore<K, V> getMapStore() {
        return this.mapStore;
    }

    @Override
    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    public JavaTypeMapping getKeyMapping() {
        return this.keyMapping;
    }

    public JavaTypeMapping getValueMapping() {
        return this.valueMapping;
    }

    public boolean updateEmbeddedElement(ObjectProvider op, Map.Entry<K, V> element, int fieldNumber, Object value) {
        return false;
    }

    protected boolean validateElementType(Object element) {
        return element instanceof Map.Entry;
    }

    public void update(ObjectProvider op, Collection coll) {
        this.clear(op);
        this.addAll(op, coll, 0);
    }

    public boolean contains(ObjectProvider op, Object element) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        return this.mapStore.containsKey(op, entry.getKey());
    }

    public boolean add(ObjectProvider op, Map.Entry<K, V> entry, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean addAll(ObjectProvider op, Collection entries, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean remove(ObjectProvider op, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        Object removed = this.mapStore.remove(op, entry.getKey());
        return removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
    }

    public boolean removeAll(ObjectProvider op, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        Iterator iter = elements.iterator();
        boolean modified = false;
        while (iter.hasNext()) {
            Object element = iter.next();
            Map.Entry entry = (Map.Entry)element;
            Object removed = this.mapStore.remove(op, entry.getKey());
            modified = removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
        }
        return modified;
    }

    public void clear(ObjectProvider op) {
        this.mapStore.clear(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(ObjectProvider op) {
        int numRows;
        String stmt = this.getSizeStmt();
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);){
                        if (!rs.next()) {
                            throw new NucleusDataStoreException("Size request returned no result row: " + stmt);
                        }
                        numRows = rs.getInt(1);
                        JDBCUtils.logWarnings(rs);
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Size request failed: " + stmt, (Throwable)e);
        }
        return numRows;
    }

    private String getSizeStmt() {
        if (this.sizeStmt == null) {
            StringBuilder stmt = new StringBuilder("SELECT COUNT(*) FROM ");
            stmt.append(this.mapTable.toString());
            stmt.append(" WHERE ");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            if (this.keyMapping != null) {
                for (int i = 0; i < this.keyMapping.getNumberOfColumnMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(this.keyMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
                    stmt.append(" IS NOT NULL");
                }
            }
            this.sizeStmt = stmt.toString();
        }
        return this.sizeStmt;
    }

    /*
     * Exception decompiling
     */
    public Iterator<Map.Entry<K, V>> iterator(ObjectProvider ownerOP) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SelectStatement getSQLStatementForIterator(ObjectProvider ownerOP, FetchPlan fp, boolean addRestrictionOnOwner) {
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        SelectStatement sqlStmt = new SelectStatement(this.storeMgr, this.mapTable, null, null);
        sqlStmt.setClassLoaderResolver(this.clr);
        SQLTable entrySqlTblForKey = sqlStmt.getPrimaryTable();
        if (this.keyMapping.getTable() != this.mapTable && (entrySqlTblForKey = sqlStmt.getTableForDatastoreContainer(this.keyMapping.getTable())) == null) {
            entrySqlTblForKey = sqlStmt.join(SQLJoin.JoinType.INNER_JOIN, sqlStmt.getPrimaryTable(), sqlStmt.getPrimaryTable().getTable().getIdMapping(), this.keyMapping.getTable(), null, this.keyMapping.getTable().getIdMapping(), null, null, true);
        }
        this.iteratorKeyResultCols = sqlStmt.select(entrySqlTblForKey, this.keyMapping, null);
        SQLTable entrySqlTblForVal = sqlStmt.getPrimaryTable();
        if (this.valueMapping.getTable() != this.mapTable && (entrySqlTblForVal = sqlStmt.getTableForDatastoreContainer(this.valueMapping.getTable())) == null) {
            entrySqlTblForVal = sqlStmt.join(SQLJoin.JoinType.INNER_JOIN, sqlStmt.getPrimaryTable(), sqlStmt.getPrimaryTable().getTable().getIdMapping(), this.valueMapping.getTable(), null, this.valueMapping.getTable().getIdMapping(), null, null, true);
        }
        this.iteratorValueResultCols = sqlStmt.select(entrySqlTblForVal, this.valueMapping, null);
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        }
        SQLExpression keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
        SQLExpression nullExpr = exprFactory.newLiteral(sqlStmt, null, null);
        sqlStmt.whereAnd(keyExpr.ne(nullExpr), true);
        return sqlStmt;
    }

    private static class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private final ObjectProvider ownerOP;
        private final K key;
        private final V value;
        private final MapStore<K, V> mapStore;

        public EntryImpl(ObjectProvider op, K key, V value, MapStore<K, V> mapStore) {
            this.ownerOP = op;
            this.key = key;
            this.value = value;
            this.mapStore = mapStore;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            return (V)this.mapStore.put(this.ownerOP, this.key, value);
        }
    }

    public static abstract class SetIterator
    implements Iterator {
        private final ObjectProvider op;
        private final Iterator delegate;
        private Map.Entry lastElement = null;
        private final MapEntrySetStore setStore;

        protected SetIterator(ObjectProvider op, MapEntrySetStore setStore, AbstractMemberMetaData ownerMmd, ResultSet rs, int[] keyResultCols, int[] valueResultCols) throws MappedDatastoreException {
            this.op = op;
            this.setStore = setStore;
            ExecutionContext ec = op.getExecutionContext();
            ArrayList<EntryImpl<Object, Object>> results = new ArrayList<EntryImpl<Object, Object>>();
            while (this.next(rs)) {
                Object key = null;
                Object value = null;
                int ownerFieldNum = ownerMmd != null ? ownerMmd.getAbsoluteFieldNumber() : -1;
                JavaTypeMapping keyMapping = setStore.getKeyMapping();
                key = keyMapping instanceof EmbeddedKeyPCMapping || keyMapping instanceof SerialisedPCMapping || keyMapping instanceof SerialisedReferenceMapping ? keyMapping.getObject(ec, rs, keyResultCols, op, ownerFieldNum) : keyMapping.getObject(ec, rs, keyResultCols);
                JavaTypeMapping valueMapping = setStore.getValueMapping();
                value = valueMapping instanceof EmbeddedValuePCMapping || valueMapping instanceof SerialisedPCMapping || valueMapping instanceof SerialisedReferenceMapping ? valueMapping.getObject(ec, rs, valueResultCols, op, ownerFieldNum) : valueMapping.getObject(ec, rs, valueResultCols);
                results.add(new EntryImpl<Object, Object>(op, key, value, setStore.getMapStore()));
            }
            this.delegate = results.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = (Map.Entry)this.delegate.next();
            return this.lastElement;
        }

        @Override
        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            this.setStore.getMapStore().remove(this.op, this.lastElement.getKey());
            this.delegate.remove();
            this.lastElement = null;
        }

        protected abstract boolean next(Object var1) throws MappedDatastoreException;
    }
}

